/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.transform;

import co.elastic.clients.ApiClient;
import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch.transform.DeleteTransformRequest;
import co.elastic.clients.elasticsearch.transform.DeleteTransformResponse;
import co.elastic.clients.elasticsearch.transform.GetTransformRequest;
import co.elastic.clients.elasticsearch.transform.GetTransformResponse;
import co.elastic.clients.elasticsearch.transform.GetTransformStatsRequest;
import co.elastic.clients.elasticsearch.transform.GetTransformStatsResponse;
import co.elastic.clients.elasticsearch.transform.PreviewTransformRequest;
import co.elastic.clients.elasticsearch.transform.PreviewTransformResponse;
import co.elastic.clients.elasticsearch.transform.PutTransformRequest;
import co.elastic.clients.elasticsearch.transform.PutTransformResponse;
import co.elastic.clients.elasticsearch.transform.StartTransformRequest;
import co.elastic.clients.elasticsearch.transform.StartTransformResponse;
import co.elastic.clients.elasticsearch.transform.StopTransformRequest;
import co.elastic.clients.elasticsearch.transform.StopTransformResponse;
import co.elastic.clients.elasticsearch.transform.UpdateTransformRequest;
import co.elastic.clients.elasticsearch.transform.UpdateTransformResponse;
import co.elastic.clients.elasticsearch.transform.UpgradeTransformsRequest;
import co.elastic.clients.elasticsearch.transform.UpgradeTransformsResponse;
import co.elastic.clients.transport.ElasticsearchTransport;
import co.elastic.clients.transport.JsonEndpoint;
import co.elastic.clients.transport.TransportOptions;
import co.elastic.clients.transport.endpoints.EndpointWithResponseMapperAttr;
import co.elastic.clients.util.ObjectBuilder;
import java.lang.reflect.Type;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import javax.annotation.Nullable;

public class ElasticsearchTransformAsyncClient
extends ApiClient<ElasticsearchTransport, ElasticsearchTransformAsyncClient> {
    public ElasticsearchTransformAsyncClient(ElasticsearchTransport transport) {
        super(transport, null);
    }

    public ElasticsearchTransformAsyncClient(ElasticsearchTransport transport, @Nullable TransportOptions transportOptions) {
        super(transport, transportOptions);
    }

    @Override
    public ElasticsearchTransformAsyncClient withTransportOptions(@Nullable TransportOptions transportOptions) {
        return new ElasticsearchTransformAsyncClient((ElasticsearchTransport)this.transport, transportOptions);
    }

    public CompletableFuture<DeleteTransformResponse> deleteTransform(DeleteTransformRequest request) {
        JsonEndpoint endpoint = (JsonEndpoint)DeleteTransformRequest._ENDPOINT;
        return ((ElasticsearchTransport)this.transport).performRequestAsync(request, endpoint, this.transportOptions);
    }

    public final CompletableFuture<DeleteTransformResponse> deleteTransform(Function<DeleteTransformRequest.Builder, ObjectBuilder<DeleteTransformRequest>> fn) {
        return this.deleteTransform(fn.apply(new DeleteTransformRequest.Builder()).build());
    }

    public CompletableFuture<GetTransformResponse> getTransform(GetTransformRequest request) {
        JsonEndpoint endpoint = (JsonEndpoint)GetTransformRequest._ENDPOINT;
        return ((ElasticsearchTransport)this.transport).performRequestAsync(request, endpoint, this.transportOptions);
    }

    public final CompletableFuture<GetTransformResponse> getTransform(Function<GetTransformRequest.Builder, ObjectBuilder<GetTransformRequest>> fn) {
        return this.getTransform(fn.apply(new GetTransformRequest.Builder()).build());
    }

    public CompletableFuture<GetTransformResponse> getTransform() {
        return ((ElasticsearchTransport)this.transport).performRequestAsync(new GetTransformRequest.Builder().build(), GetTransformRequest._ENDPOINT, this.transportOptions);
    }

    public CompletableFuture<GetTransformStatsResponse> getTransformStats(GetTransformStatsRequest request) {
        JsonEndpoint endpoint = (JsonEndpoint)GetTransformStatsRequest._ENDPOINT;
        return ((ElasticsearchTransport)this.transport).performRequestAsync(request, endpoint, this.transportOptions);
    }

    public final CompletableFuture<GetTransformStatsResponse> getTransformStats(Function<GetTransformStatsRequest.Builder, ObjectBuilder<GetTransformStatsRequest>> fn) {
        return this.getTransformStats(fn.apply(new GetTransformStatsRequest.Builder()).build());
    }

    public <TTransform> CompletableFuture<PreviewTransformResponse<TTransform>> previewTransform(PreviewTransformRequest request, Class<TTransform> tTransformClass) {
        JsonEndpoint<Object, Object, ErrorResponse> endpoint = PreviewTransformRequest._ENDPOINT;
        endpoint = new EndpointWithResponseMapperAttr(endpoint, "co.elastic.clients:Deserializer:transform.preview_transform.TTransform", this.getDeserializer(tTransformClass));
        return ((ElasticsearchTransport)this.transport).performRequestAsync(request, endpoint, this.transportOptions);
    }

    public final <TTransform> CompletableFuture<PreviewTransformResponse<TTransform>> previewTransform(Function<PreviewTransformRequest.Builder, ObjectBuilder<PreviewTransformRequest>> fn, Class<TTransform> tTransformClass) {
        return this.previewTransform(fn.apply(new PreviewTransformRequest.Builder()).build(), tTransformClass);
    }

    public <TTransform> CompletableFuture<PreviewTransformResponse<TTransform>> previewTransform(PreviewTransformRequest request, Type tTransformType) {
        JsonEndpoint<Object, Object, ErrorResponse> endpoint = PreviewTransformRequest._ENDPOINT;
        endpoint = new EndpointWithResponseMapperAttr(endpoint, "co.elastic.clients:Deserializer:transform.preview_transform.TTransform", this.getDeserializer(tTransformType));
        return ((ElasticsearchTransport)this.transport).performRequestAsync(request, endpoint, this.transportOptions);
    }

    public final <TTransform> CompletableFuture<PreviewTransformResponse<TTransform>> previewTransform(Function<PreviewTransformRequest.Builder, ObjectBuilder<PreviewTransformRequest>> fn, Type tTransformType) {
        return this.previewTransform(fn.apply(new PreviewTransformRequest.Builder()).build(), tTransformType);
    }

    public CompletableFuture<PutTransformResponse> putTransform(PutTransformRequest request) {
        JsonEndpoint endpoint = (JsonEndpoint)PutTransformRequest._ENDPOINT;
        return ((ElasticsearchTransport)this.transport).performRequestAsync(request, endpoint, this.transportOptions);
    }

    public final CompletableFuture<PutTransformResponse> putTransform(Function<PutTransformRequest.Builder, ObjectBuilder<PutTransformRequest>> fn) {
        return this.putTransform(fn.apply(new PutTransformRequest.Builder()).build());
    }

    public CompletableFuture<StartTransformResponse> startTransform(StartTransformRequest request) {
        JsonEndpoint endpoint = (JsonEndpoint)StartTransformRequest._ENDPOINT;
        return ((ElasticsearchTransport)this.transport).performRequestAsync(request, endpoint, this.transportOptions);
    }

    public final CompletableFuture<StartTransformResponse> startTransform(Function<StartTransformRequest.Builder, ObjectBuilder<StartTransformRequest>> fn) {
        return this.startTransform(fn.apply(new StartTransformRequest.Builder()).build());
    }

    public CompletableFuture<StopTransformResponse> stopTransform(StopTransformRequest request) {
        JsonEndpoint endpoint = (JsonEndpoint)StopTransformRequest._ENDPOINT;
        return ((ElasticsearchTransport)this.transport).performRequestAsync(request, endpoint, this.transportOptions);
    }

    public final CompletableFuture<StopTransformResponse> stopTransform(Function<StopTransformRequest.Builder, ObjectBuilder<StopTransformRequest>> fn) {
        return this.stopTransform(fn.apply(new StopTransformRequest.Builder()).build());
    }

    public CompletableFuture<UpdateTransformResponse> updateTransform(UpdateTransformRequest request) {
        JsonEndpoint endpoint = (JsonEndpoint)UpdateTransformRequest._ENDPOINT;
        return ((ElasticsearchTransport)this.transport).performRequestAsync(request, endpoint, this.transportOptions);
    }

    public final CompletableFuture<UpdateTransformResponse> updateTransform(Function<UpdateTransformRequest.Builder, ObjectBuilder<UpdateTransformRequest>> fn) {
        return this.updateTransform(fn.apply(new UpdateTransformRequest.Builder()).build());
    }

    public CompletableFuture<UpgradeTransformsResponse> upgradeTransforms(UpgradeTransformsRequest request) {
        JsonEndpoint endpoint = (JsonEndpoint)UpgradeTransformsRequest._ENDPOINT;
        return ((ElasticsearchTransport)this.transport).performRequestAsync(request, endpoint, this.transportOptions);
    }

    public final CompletableFuture<UpgradeTransformsResponse> upgradeTransforms(Function<UpgradeTransformsRequest.Builder, ObjectBuilder<UpgradeTransformsRequest>> fn) {
        return this.upgradeTransforms(fn.apply(new UpgradeTransformsRequest.Builder()).build());
    }

    public CompletableFuture<UpgradeTransformsResponse> upgradeTransforms() {
        return ((ElasticsearchTransport)this.transport).performRequestAsync(new UpgradeTransformsRequest.Builder().build(), UpgradeTransformsRequest._ENDPOINT, this.transportOptions);
    }
}

