/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.sql;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch._types.Time;
import co.elastic.clients.elasticsearch._types.mapping.RuntimeField;
import co.elastic.clients.elasticsearch._types.query_dsl.Query;
import co.elastic.clients.elasticsearch.sql.QueryResponse;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class QueryRequest
extends RequestBase
implements JsonpSerializable {
    @Nullable
    private final String catalog;
    @Nullable
    private final Boolean columnar;
    @Nullable
    private final String cursor;
    @Nullable
    private final Integer fetchSize;
    @Nullable
    private final Boolean fieldMultiValueLeniency;
    @Nullable
    private final Query filter;
    @Nullable
    private final String format;
    @Nullable
    private final Boolean indexUsingFrozen;
    @Nullable
    private final Time keepAlive;
    @Nullable
    private final Boolean keepOnCompletion;
    @Nullable
    private final Time pageTimeout;
    private final Map<String, JsonData> params;
    @Nullable
    private final String query;
    @Nullable
    private final Time requestTimeout;
    private final Map<String, RuntimeField> runtimeMappings;
    @Nullable
    private final String timeZone;
    @Nullable
    private final Time waitForCompletionTimeout;
    public static final JsonpDeserializer<QueryRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, QueryRequest::setupQueryRequestDeserializer);
    public static final Endpoint<QueryRequest, QueryResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<QueryRequest, QueryResponse>("es/sql.query", request -> "POST", request -> "/_sql", request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.format != null) {
            params.put("format", request.format);
        }
        return params;
    }, SimpleEndpoint.emptyMap(), true, QueryResponse._DESERIALIZER);

    private QueryRequest(Builder builder) {
        this.catalog = builder.catalog;
        this.columnar = builder.columnar;
        this.cursor = builder.cursor;
        this.fetchSize = builder.fetchSize;
        this.fieldMultiValueLeniency = builder.fieldMultiValueLeniency;
        this.filter = builder.filter;
        this.format = builder.format;
        this.indexUsingFrozen = builder.indexUsingFrozen;
        this.keepAlive = builder.keepAlive;
        this.keepOnCompletion = builder.keepOnCompletion;
        this.pageTimeout = builder.pageTimeout;
        this.params = ApiTypeHelper.unmodifiable(builder.params);
        this.query = builder.query;
        this.requestTimeout = builder.requestTimeout;
        this.runtimeMappings = ApiTypeHelper.unmodifiable(builder.runtimeMappings);
        this.timeZone = builder.timeZone;
        this.waitForCompletionTimeout = builder.waitForCompletionTimeout;
    }

    public static QueryRequest of(Function<Builder, ObjectBuilder<QueryRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final String catalog() {
        return this.catalog;
    }

    @Nullable
    public final Boolean columnar() {
        return this.columnar;
    }

    @Nullable
    public final String cursor() {
        return this.cursor;
    }

    @Nullable
    public final Integer fetchSize() {
        return this.fetchSize;
    }

    @Nullable
    public final Boolean fieldMultiValueLeniency() {
        return this.fieldMultiValueLeniency;
    }

    @Nullable
    public final Query filter() {
        return this.filter;
    }

    @Nullable
    public final String format() {
        return this.format;
    }

    @Nullable
    public final Boolean indexUsingFrozen() {
        return this.indexUsingFrozen;
    }

    @Nullable
    public final Time keepAlive() {
        return this.keepAlive;
    }

    @Nullable
    public final Boolean keepOnCompletion() {
        return this.keepOnCompletion;
    }

    @Nullable
    public final Time pageTimeout() {
        return this.pageTimeout;
    }

    public final Map<String, JsonData> params() {
        return this.params;
    }

    @Nullable
    public final String query() {
        return this.query;
    }

    @Nullable
    public final Time requestTimeout() {
        return this.requestTimeout;
    }

    public final Map<String, RuntimeField> runtimeMappings() {
        return this.runtimeMappings;
    }

    @Nullable
    public final String timeZone() {
        return this.timeZone;
    }

    @Nullable
    public final Time waitForCompletionTimeout() {
        return this.waitForCompletionTimeout;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.catalog != null) {
            generator.writeKey("catalog");
            generator.write(this.catalog);
        }
        if (this.columnar != null) {
            generator.writeKey("columnar");
            generator.write(this.columnar);
        }
        if (this.cursor != null) {
            generator.writeKey("cursor");
            generator.write(this.cursor);
        }
        if (this.fetchSize != null) {
            generator.writeKey("fetch_size");
            generator.write(this.fetchSize);
        }
        if (this.fieldMultiValueLeniency != null) {
            generator.writeKey("field_multi_value_leniency");
            generator.write(this.fieldMultiValueLeniency);
        }
        if (this.filter != null) {
            generator.writeKey("filter");
            this.filter.serialize(generator, mapper);
        }
        if (this.indexUsingFrozen != null) {
            generator.writeKey("index_using_frozen");
            generator.write(this.indexUsingFrozen);
        }
        if (this.keepAlive != null) {
            generator.writeKey("keep_alive");
            this.keepAlive.serialize(generator, mapper);
        }
        if (this.keepOnCompletion != null) {
            generator.writeKey("keep_on_completion");
            generator.write(this.keepOnCompletion);
        }
        if (this.pageTimeout != null) {
            generator.writeKey("page_timeout");
            this.pageTimeout.serialize(generator, mapper);
        }
        if (ApiTypeHelper.isDefined(this.params)) {
            generator.writeKey("params");
            generator.writeStartObject();
            for (Map.Entry<String, JsonData> entry : this.params.entrySet()) {
                generator.writeKey(entry.getKey());
                entry.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.query != null) {
            generator.writeKey("query");
            generator.write(this.query);
        }
        if (this.requestTimeout != null) {
            generator.writeKey("request_timeout");
            this.requestTimeout.serialize(generator, mapper);
        }
        if (ApiTypeHelper.isDefined(this.runtimeMappings)) {
            generator.writeKey("runtime_mappings");
            generator.writeStartObject();
            for (Map.Entry<String, JsonpSerializable> entry : this.runtimeMappings.entrySet()) {
                generator.writeKey(entry.getKey());
                ((RuntimeField)entry.getValue()).serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.timeZone != null) {
            generator.writeKey("time_zone");
            generator.write(this.timeZone);
        }
        if (this.waitForCompletionTimeout != null) {
            generator.writeKey("wait_for_completion_timeout");
            this.waitForCompletionTimeout.serialize(generator, mapper);
        }
    }

    protected static void setupQueryRequestDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::catalog, JsonpDeserializer.stringDeserializer(), "catalog");
        op.add(Builder::columnar, JsonpDeserializer.booleanDeserializer(), "columnar");
        op.add(Builder::cursor, JsonpDeserializer.stringDeserializer(), "cursor");
        op.add(Builder::fetchSize, JsonpDeserializer.integerDeserializer(), "fetch_size");
        op.add(Builder::fieldMultiValueLeniency, JsonpDeserializer.booleanDeserializer(), "field_multi_value_leniency");
        op.add(Builder::filter, Query._DESERIALIZER, "filter");
        op.add(Builder::indexUsingFrozen, JsonpDeserializer.booleanDeserializer(), "index_using_frozen");
        op.add(Builder::keepAlive, Time._DESERIALIZER, "keep_alive");
        op.add(Builder::keepOnCompletion, JsonpDeserializer.booleanDeserializer(), "keep_on_completion");
        op.add(Builder::pageTimeout, Time._DESERIALIZER, "page_timeout");
        op.add(Builder::params, JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER), "params");
        op.add(Builder::query, JsonpDeserializer.stringDeserializer(), "query");
        op.add(Builder::requestTimeout, Time._DESERIALIZER, "request_timeout");
        op.add(Builder::runtimeMappings, JsonpDeserializer.stringMapDeserializer(RuntimeField._DESERIALIZER), "runtime_mappings");
        op.add(Builder::timeZone, JsonpDeserializer.stringDeserializer(), "time_zone");
        op.add(Builder::waitForCompletionTimeout, Time._DESERIALIZER, "wait_for_completion_timeout");
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements ObjectBuilder<QueryRequest> {
        @Nullable
        private String catalog;
        @Nullable
        private Boolean columnar;
        @Nullable
        private String cursor;
        @Nullable
        private Integer fetchSize;
        @Nullable
        private Boolean fieldMultiValueLeniency;
        @Nullable
        private Query filter;
        @Nullable
        private String format;
        @Nullable
        private Boolean indexUsingFrozen;
        @Nullable
        private Time keepAlive;
        @Nullable
        private Boolean keepOnCompletion;
        @Nullable
        private Time pageTimeout;
        @Nullable
        private Map<String, JsonData> params;
        @Nullable
        private String query;
        @Nullable
        private Time requestTimeout;
        @Nullable
        private Map<String, RuntimeField> runtimeMappings;
        @Nullable
        private String timeZone;
        @Nullable
        private Time waitForCompletionTimeout;

        public final Builder catalog(@Nullable String value) {
            this.catalog = value;
            return this;
        }

        public final Builder columnar(@Nullable Boolean value) {
            this.columnar = value;
            return this;
        }

        public final Builder cursor(@Nullable String value) {
            this.cursor = value;
            return this;
        }

        public final Builder fetchSize(@Nullable Integer value) {
            this.fetchSize = value;
            return this;
        }

        public final Builder fieldMultiValueLeniency(@Nullable Boolean value) {
            this.fieldMultiValueLeniency = value;
            return this;
        }

        public final Builder filter(@Nullable Query value) {
            this.filter = value;
            return this;
        }

        public final Builder filter(Function<Query.Builder, ObjectBuilder<Query>> fn) {
            return this.filter(fn.apply(new Query.Builder()).build());
        }

        public final Builder format(@Nullable String value) {
            this.format = value;
            return this;
        }

        public final Builder indexUsingFrozen(@Nullable Boolean value) {
            this.indexUsingFrozen = value;
            return this;
        }

        public final Builder keepAlive(@Nullable Time value) {
            this.keepAlive = value;
            return this;
        }

        public final Builder keepAlive(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.keepAlive(fn.apply(new Time.Builder()).build());
        }

        public final Builder keepOnCompletion(@Nullable Boolean value) {
            this.keepOnCompletion = value;
            return this;
        }

        public final Builder pageTimeout(@Nullable Time value) {
            this.pageTimeout = value;
            return this;
        }

        public final Builder pageTimeout(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.pageTimeout(fn.apply(new Time.Builder()).build());
        }

        public final Builder params(Map<String, JsonData> map) {
            this.params = Builder._mapPutAll(this.params, map);
            return this;
        }

        public final Builder params(String key, JsonData value) {
            this.params = Builder._mapPut(this.params, key, value);
            return this;
        }

        public final Builder query(@Nullable String value) {
            this.query = value;
            return this;
        }

        public final Builder requestTimeout(@Nullable Time value) {
            this.requestTimeout = value;
            return this;
        }

        public final Builder requestTimeout(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.requestTimeout(fn.apply(new Time.Builder()).build());
        }

        public final Builder runtimeMappings(Map<String, RuntimeField> map) {
            this.runtimeMappings = Builder._mapPutAll(this.runtimeMappings, map);
            return this;
        }

        public final Builder runtimeMappings(String key, RuntimeField value) {
            this.runtimeMappings = Builder._mapPut(this.runtimeMappings, key, value);
            return this;
        }

        public final Builder runtimeMappings(String key, Function<RuntimeField.Builder, ObjectBuilder<RuntimeField>> fn) {
            return this.runtimeMappings(key, fn.apply(new RuntimeField.Builder()).build());
        }

        public final Builder timeZone(@Nullable String value) {
            this.timeZone = value;
            return this;
        }

        public final Builder waitForCompletionTimeout(@Nullable Time value) {
            this.waitForCompletionTimeout = value;
            return this;
        }

        public final Builder waitForCompletionTimeout(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.waitForCompletionTimeout(fn.apply(new Time.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public QueryRequest build() {
            this._checkSingleUse();
            return new QueryRequest(this);
        }
    }
}

