/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch._types.Time;
import co.elastic.clients.elasticsearch.ml.AnalysisMemoryLimit;
import co.elastic.clients.elasticsearch.ml.Detector;
import co.elastic.clients.elasticsearch.ml.ModelPlotConfig;
import co.elastic.clients.elasticsearch.ml.PerPartitionCategorization;
import co.elastic.clients.elasticsearch.ml.UpdateJobResponse;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class UpdateJobRequest
extends RequestBase
implements JsonpSerializable {
    @Nullable
    private final Boolean allowLazyOpen;
    @Nullable
    private final AnalysisMemoryLimit analysisLimits;
    @Nullable
    private final Time backgroundPersistInterval;
    private final List<String> categorizationFilters;
    private final Map<String, JsonData> customSettings;
    @Nullable
    private final Long dailyModelSnapshotRetentionAfterDays;
    @Nullable
    private final String description;
    private final List<Detector> detectors;
    private final List<String> groups;
    private final String jobId;
    @Nullable
    private final ModelPlotConfig modelPlotConfig;
    @Nullable
    private final Long modelSnapshotRetentionDays;
    @Nullable
    private final PerPartitionCategorization perPartitionCategorization;
    @Nullable
    private final Long renormalizationWindowDays;
    @Nullable
    private final Long resultsRetentionDays;
    public static final JsonpDeserializer<UpdateJobRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, UpdateJobRequest::setupUpdateJobRequestDeserializer);
    public static final Endpoint<UpdateJobRequest, UpdateJobResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<UpdateJobRequest, UpdateJobResponse>("es/ml.update_job", request -> "POST", request -> {
        boolean _jobId = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_ml");
            buf.append("/anomaly_detectors");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.jobId, buf);
            buf.append("/_update");
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> Collections.emptyMap(), SimpleEndpoint.emptyMap(), true, UpdateJobResponse._DESERIALIZER);

    private UpdateJobRequest(Builder builder) {
        this.allowLazyOpen = builder.allowLazyOpen;
        this.analysisLimits = builder.analysisLimits;
        this.backgroundPersistInterval = builder.backgroundPersistInterval;
        this.categorizationFilters = ApiTypeHelper.unmodifiable(builder.categorizationFilters);
        this.customSettings = ApiTypeHelper.unmodifiable(builder.customSettings);
        this.dailyModelSnapshotRetentionAfterDays = builder.dailyModelSnapshotRetentionAfterDays;
        this.description = builder.description;
        this.detectors = ApiTypeHelper.unmodifiable(builder.detectors);
        this.groups = ApiTypeHelper.unmodifiable(builder.groups);
        this.jobId = ApiTypeHelper.requireNonNull(builder.jobId, this, "jobId");
        this.modelPlotConfig = builder.modelPlotConfig;
        this.modelSnapshotRetentionDays = builder.modelSnapshotRetentionDays;
        this.perPartitionCategorization = builder.perPartitionCategorization;
        this.renormalizationWindowDays = builder.renormalizationWindowDays;
        this.resultsRetentionDays = builder.resultsRetentionDays;
    }

    public static UpdateJobRequest of(Function<Builder, ObjectBuilder<UpdateJobRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Boolean allowLazyOpen() {
        return this.allowLazyOpen;
    }

    @Nullable
    public final AnalysisMemoryLimit analysisLimits() {
        return this.analysisLimits;
    }

    @Nullable
    public final Time backgroundPersistInterval() {
        return this.backgroundPersistInterval;
    }

    public final List<String> categorizationFilters() {
        return this.categorizationFilters;
    }

    public final Map<String, JsonData> customSettings() {
        return this.customSettings;
    }

    @Nullable
    public final Long dailyModelSnapshotRetentionAfterDays() {
        return this.dailyModelSnapshotRetentionAfterDays;
    }

    @Nullable
    public final String description() {
        return this.description;
    }

    public final List<Detector> detectors() {
        return this.detectors;
    }

    public final List<String> groups() {
        return this.groups;
    }

    public final String jobId() {
        return this.jobId;
    }

    @Nullable
    public final ModelPlotConfig modelPlotConfig() {
        return this.modelPlotConfig;
    }

    @Nullable
    public final Long modelSnapshotRetentionDays() {
        return this.modelSnapshotRetentionDays;
    }

    @Nullable
    public final PerPartitionCategorization perPartitionCategorization() {
        return this.perPartitionCategorization;
    }

    @Nullable
    public final Long renormalizationWindowDays() {
        return this.renormalizationWindowDays;
    }

    @Nullable
    public final Long resultsRetentionDays() {
        return this.resultsRetentionDays;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.allowLazyOpen != null) {
            generator.writeKey("allow_lazy_open");
            generator.write(this.allowLazyOpen);
        }
        if (this.analysisLimits != null) {
            generator.writeKey("analysis_limits");
            this.analysisLimits.serialize(generator, mapper);
        }
        if (this.backgroundPersistInterval != null) {
            generator.writeKey("background_persist_interval");
            this.backgroundPersistInterval.serialize(generator, mapper);
        }
        if (ApiTypeHelper.isDefined(this.categorizationFilters)) {
            generator.writeKey("categorization_filters");
            generator.writeStartArray();
            for (String string : this.categorizationFilters) {
                generator.write(string);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.customSettings)) {
            generator.writeKey("custom_settings");
            generator.writeStartObject();
            for (Map.Entry entry : this.customSettings.entrySet()) {
                generator.writeKey((String)entry.getKey());
                ((JsonData)entry.getValue()).serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.dailyModelSnapshotRetentionAfterDays != null) {
            generator.writeKey("daily_model_snapshot_retention_after_days");
            generator.write(this.dailyModelSnapshotRetentionAfterDays);
        }
        if (this.description != null) {
            generator.writeKey("description");
            generator.write(this.description);
        }
        if (ApiTypeHelper.isDefined(this.detectors)) {
            generator.writeKey("detectors");
            generator.writeStartArray();
            for (Detector detector : this.detectors) {
                detector.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.groups)) {
            generator.writeKey("groups");
            generator.writeStartArray();
            for (String string : this.groups) {
                generator.write(string);
            }
            generator.writeEnd();
        }
        if (this.modelPlotConfig != null) {
            generator.writeKey("model_plot_config");
            this.modelPlotConfig.serialize(generator, mapper);
        }
        if (this.modelSnapshotRetentionDays != null) {
            generator.writeKey("model_snapshot_retention_days");
            generator.write(this.modelSnapshotRetentionDays);
        }
        if (this.perPartitionCategorization != null) {
            generator.writeKey("per_partition_categorization");
            this.perPartitionCategorization.serialize(generator, mapper);
        }
        if (this.renormalizationWindowDays != null) {
            generator.writeKey("renormalization_window_days");
            generator.write(this.renormalizationWindowDays);
        }
        if (this.resultsRetentionDays != null) {
            generator.writeKey("results_retention_days");
            generator.write(this.resultsRetentionDays);
        }
    }

    protected static void setupUpdateJobRequestDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::allowLazyOpen, JsonpDeserializer.booleanDeserializer(), "allow_lazy_open");
        op.add(Builder::analysisLimits, AnalysisMemoryLimit._DESERIALIZER, "analysis_limits");
        op.add(Builder::backgroundPersistInterval, Time._DESERIALIZER, "background_persist_interval");
        op.add(Builder::categorizationFilters, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "categorization_filters");
        op.add(Builder::customSettings, JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER), "custom_settings");
        op.add(Builder::dailyModelSnapshotRetentionAfterDays, JsonpDeserializer.longDeserializer(), "daily_model_snapshot_retention_after_days");
        op.add(Builder::description, JsonpDeserializer.stringDeserializer(), "description");
        op.add(Builder::detectors, JsonpDeserializer.arrayDeserializer(Detector._DESERIALIZER), "detectors");
        op.add(Builder::groups, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "groups");
        op.add(Builder::modelPlotConfig, ModelPlotConfig._DESERIALIZER, "model_plot_config");
        op.add(Builder::modelSnapshotRetentionDays, JsonpDeserializer.longDeserializer(), "model_snapshot_retention_days");
        op.add(Builder::perPartitionCategorization, PerPartitionCategorization._DESERIALIZER, "per_partition_categorization");
        op.add(Builder::renormalizationWindowDays, JsonpDeserializer.longDeserializer(), "renormalization_window_days");
        op.add(Builder::resultsRetentionDays, JsonpDeserializer.longDeserializer(), "results_retention_days");
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements ObjectBuilder<UpdateJobRequest> {
        @Nullable
        private Boolean allowLazyOpen;
        @Nullable
        private AnalysisMemoryLimit analysisLimits;
        @Nullable
        private Time backgroundPersistInterval;
        @Nullable
        private List<String> categorizationFilters;
        @Nullable
        private Map<String, JsonData> customSettings;
        @Nullable
        private Long dailyModelSnapshotRetentionAfterDays;
        @Nullable
        private String description;
        @Nullable
        private List<Detector> detectors;
        @Nullable
        private List<String> groups;
        private String jobId;
        @Nullable
        private ModelPlotConfig modelPlotConfig;
        @Nullable
        private Long modelSnapshotRetentionDays;
        @Nullable
        private PerPartitionCategorization perPartitionCategorization;
        @Nullable
        private Long renormalizationWindowDays;
        @Nullable
        private Long resultsRetentionDays;

        public final Builder allowLazyOpen(@Nullable Boolean value) {
            this.allowLazyOpen = value;
            return this;
        }

        public final Builder analysisLimits(@Nullable AnalysisMemoryLimit value) {
            this.analysisLimits = value;
            return this;
        }

        public final Builder analysisLimits(Function<AnalysisMemoryLimit.Builder, ObjectBuilder<AnalysisMemoryLimit>> fn) {
            return this.analysisLimits(fn.apply(new AnalysisMemoryLimit.Builder()).build());
        }

        public final Builder backgroundPersistInterval(@Nullable Time value) {
            this.backgroundPersistInterval = value;
            return this;
        }

        public final Builder backgroundPersistInterval(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.backgroundPersistInterval(fn.apply(new Time.Builder()).build());
        }

        public final Builder categorizationFilters(List<String> list) {
            this.categorizationFilters = Builder._listAddAll(this.categorizationFilters, list);
            return this;
        }

        public final Builder categorizationFilters(String value, String ... values) {
            this.categorizationFilters = Builder._listAdd(this.categorizationFilters, value, values);
            return this;
        }

        public final Builder customSettings(Map<String, JsonData> map) {
            this.customSettings = Builder._mapPutAll(this.customSettings, map);
            return this;
        }

        public final Builder customSettings(String key, JsonData value) {
            this.customSettings = Builder._mapPut(this.customSettings, key, value);
            return this;
        }

        public final Builder dailyModelSnapshotRetentionAfterDays(@Nullable Long value) {
            this.dailyModelSnapshotRetentionAfterDays = value;
            return this;
        }

        public final Builder description(@Nullable String value) {
            this.description = value;
            return this;
        }

        public final Builder detectors(List<Detector> list) {
            this.detectors = Builder._listAddAll(this.detectors, list);
            return this;
        }

        public final Builder detectors(Detector value, Detector ... values) {
            this.detectors = Builder._listAdd(this.detectors, value, values);
            return this;
        }

        public final Builder detectors(Function<Detector.Builder, ObjectBuilder<Detector>> fn) {
            return this.detectors(fn.apply(new Detector.Builder()).build(), new Detector[0]);
        }

        public final Builder groups(List<String> list) {
            this.groups = Builder._listAddAll(this.groups, list);
            return this;
        }

        public final Builder groups(String value, String ... values) {
            this.groups = Builder._listAdd(this.groups, value, values);
            return this;
        }

        public final Builder jobId(String value) {
            this.jobId = value;
            return this;
        }

        public final Builder modelPlotConfig(@Nullable ModelPlotConfig value) {
            this.modelPlotConfig = value;
            return this;
        }

        public final Builder modelPlotConfig(Function<ModelPlotConfig.Builder, ObjectBuilder<ModelPlotConfig>> fn) {
            return this.modelPlotConfig(fn.apply(new ModelPlotConfig.Builder()).build());
        }

        public final Builder modelSnapshotRetentionDays(@Nullable Long value) {
            this.modelSnapshotRetentionDays = value;
            return this;
        }

        public final Builder perPartitionCategorization(@Nullable PerPartitionCategorization value) {
            this.perPartitionCategorization = value;
            return this;
        }

        public final Builder perPartitionCategorization(Function<PerPartitionCategorization.Builder, ObjectBuilder<PerPartitionCategorization>> fn) {
            return this.perPartitionCategorization(fn.apply(new PerPartitionCategorization.Builder()).build());
        }

        public final Builder renormalizationWindowDays(@Nullable Long value) {
            this.renormalizationWindowDays = value;
            return this;
        }

        public final Builder resultsRetentionDays(@Nullable Long value) {
            this.resultsRetentionDays = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public UpdateJobRequest build() {
            this._checkSingleUse();
            return new UpdateJobRequest(this);
        }
    }
}

