/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.ml.AnalysisConfig;
import co.elastic.clients.elasticsearch.ml.EstimateModelMemoryResponse;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class EstimateModelMemoryRequest
extends RequestBase
implements JsonpSerializable {
    @Nullable
    private final AnalysisConfig analysisConfig;
    private final Map<String, Long> maxBucketCardinality;
    private final Map<String, Long> overallCardinality;
    public static final JsonpDeserializer<EstimateModelMemoryRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, EstimateModelMemoryRequest::setupEstimateModelMemoryRequestDeserializer);
    public static final Endpoint<EstimateModelMemoryRequest, EstimateModelMemoryResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<EstimateModelMemoryRequest, EstimateModelMemoryResponse>("es/ml.estimate_model_memory", request -> "POST", request -> "/_ml/anomaly_detectors/_estimate_model_memory", request -> Collections.emptyMap(), SimpleEndpoint.emptyMap(), true, EstimateModelMemoryResponse._DESERIALIZER);

    private EstimateModelMemoryRequest(Builder builder) {
        this.analysisConfig = builder.analysisConfig;
        this.maxBucketCardinality = ApiTypeHelper.unmodifiable(builder.maxBucketCardinality);
        this.overallCardinality = ApiTypeHelper.unmodifiable(builder.overallCardinality);
    }

    public static EstimateModelMemoryRequest of(Function<Builder, ObjectBuilder<EstimateModelMemoryRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final AnalysisConfig analysisConfig() {
        return this.analysisConfig;
    }

    public final Map<String, Long> maxBucketCardinality() {
        return this.maxBucketCardinality;
    }

    public final Map<String, Long> overallCardinality() {
        return this.overallCardinality;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.analysisConfig != null) {
            generator.writeKey("analysis_config");
            this.analysisConfig.serialize(generator, mapper);
        }
        if (ApiTypeHelper.isDefined(this.maxBucketCardinality)) {
            generator.writeKey("max_bucket_cardinality");
            generator.writeStartObject();
            for (Map.Entry<String, Long> item0 : this.maxBucketCardinality.entrySet()) {
                generator.writeKey(item0.getKey());
                generator.write(item0.getValue());
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.overallCardinality)) {
            generator.writeKey("overall_cardinality");
            generator.writeStartObject();
            for (Map.Entry<String, Long> item0 : this.overallCardinality.entrySet()) {
                generator.writeKey(item0.getKey());
                generator.write(item0.getValue());
            }
            generator.writeEnd();
        }
    }

    protected static void setupEstimateModelMemoryRequestDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::analysisConfig, AnalysisConfig._DESERIALIZER, "analysis_config");
        op.add(Builder::maxBucketCardinality, JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.longDeserializer()), "max_bucket_cardinality");
        op.add(Builder::overallCardinality, JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.longDeserializer()), "overall_cardinality");
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements ObjectBuilder<EstimateModelMemoryRequest> {
        @Nullable
        private AnalysisConfig analysisConfig;
        @Nullable
        private Map<String, Long> maxBucketCardinality;
        @Nullable
        private Map<String, Long> overallCardinality;

        public final Builder analysisConfig(@Nullable AnalysisConfig value) {
            this.analysisConfig = value;
            return this;
        }

        public final Builder analysisConfig(Function<AnalysisConfig.Builder, ObjectBuilder<AnalysisConfig>> fn) {
            return this.analysisConfig(fn.apply(new AnalysisConfig.Builder()).build());
        }

        public final Builder maxBucketCardinality(Map<String, Long> map) {
            this.maxBucketCardinality = Builder._mapPutAll(this.maxBucketCardinality, map);
            return this;
        }

        public final Builder maxBucketCardinality(String key, Long value) {
            this.maxBucketCardinality = Builder._mapPut(this.maxBucketCardinality, key, value);
            return this;
        }

        public final Builder overallCardinality(Map<String, Long> map) {
            this.overallCardinality = Builder._mapPutAll(this.overallCardinality, map);
            return this;
        }

        public final Builder overallCardinality(String key, Long value) {
            this.overallCardinality = Builder._mapPut(this.overallCardinality, key, value);
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public EstimateModelMemoryRequest build() {
            this._checkSingleUse();
            return new EstimateModelMemoryRequest(this);
        }
    }
}

