/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ingest;

import co.elastic.clients.elasticsearch.ingest.Processor;
import co.elastic.clients.elasticsearch.ingest.ProcessorBase;
import co.elastic.clients.elasticsearch.ingest.ProcessorVariant;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class SetProcessor
extends ProcessorBase
implements ProcessorVariant {
    @Nullable
    private final String copyFrom;
    private final String field;
    @Nullable
    private final Boolean ignoreEmptyValue;
    @Nullable
    private final String mediaType;
    @Nullable
    private final Boolean override;
    @Nullable
    private final JsonData value;
    public static final JsonpDeserializer<SetProcessor> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, SetProcessor::setupSetProcessorDeserializer);

    private SetProcessor(Builder builder) {
        super(builder);
        this.copyFrom = builder.copyFrom;
        this.field = ApiTypeHelper.requireNonNull(builder.field, this, "field");
        this.ignoreEmptyValue = builder.ignoreEmptyValue;
        this.mediaType = builder.mediaType;
        this.override = builder.override;
        this.value = builder.value;
    }

    public static SetProcessor of(Function<Builder, ObjectBuilder<SetProcessor>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Processor.Kind _processorKind() {
        return Processor.Kind.Set;
    }

    @Nullable
    public final String copyFrom() {
        return this.copyFrom;
    }

    public final String field() {
        return this.field;
    }

    @Nullable
    public final Boolean ignoreEmptyValue() {
        return this.ignoreEmptyValue;
    }

    @Nullable
    public final String mediaType() {
        return this.mediaType;
    }

    @Nullable
    public final Boolean override() {
        return this.override;
    }

    @Nullable
    public final JsonData value() {
        return this.value;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (this.copyFrom != null) {
            generator.writeKey("copy_from");
            generator.write(this.copyFrom);
        }
        generator.writeKey("field");
        generator.write(this.field);
        if (this.ignoreEmptyValue != null) {
            generator.writeKey("ignore_empty_value");
            generator.write(this.ignoreEmptyValue);
        }
        if (this.mediaType != null) {
            generator.writeKey("media_type");
            generator.write(this.mediaType);
        }
        if (this.override != null) {
            generator.writeKey("override");
            generator.write(this.override);
        }
        if (this.value != null) {
            generator.writeKey("value");
            this.value.serialize(generator, mapper);
        }
    }

    protected static void setupSetProcessorDeserializer(ObjectDeserializer<Builder> op) {
        ProcessorBase.setupProcessorBaseDeserializer(op);
        op.add(Builder::copyFrom, JsonpDeserializer.stringDeserializer(), "copy_from");
        op.add(Builder::field, JsonpDeserializer.stringDeserializer(), "field");
        op.add(Builder::ignoreEmptyValue, JsonpDeserializer.booleanDeserializer(), "ignore_empty_value");
        op.add(Builder::mediaType, JsonpDeserializer.stringDeserializer(), "media_type");
        op.add(Builder::override, JsonpDeserializer.booleanDeserializer(), "override");
        op.add(Builder::value, JsonData._DESERIALIZER, "value");
    }

    public static class Builder
    extends ProcessorBase.AbstractBuilder<Builder>
    implements ObjectBuilder<SetProcessor> {
        @Nullable
        private String copyFrom;
        private String field;
        @Nullable
        private Boolean ignoreEmptyValue;
        @Nullable
        private String mediaType;
        @Nullable
        private Boolean override;
        @Nullable
        private JsonData value;

        public final Builder copyFrom(@Nullable String value) {
            this.copyFrom = value;
            return this;
        }

        public final Builder field(String value) {
            this.field = value;
            return this;
        }

        public final Builder ignoreEmptyValue(@Nullable Boolean value) {
            this.ignoreEmptyValue = value;
            return this;
        }

        public final Builder mediaType(@Nullable String value) {
            this.mediaType = value;
            return this;
        }

        public final Builder override(@Nullable Boolean value) {
            this.override = value;
            return this;
        }

        public final Builder value(@Nullable JsonData value) {
            this.value = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public SetProcessor build() {
            this._checkSingleUse();
            return new SetProcessor(this);
        }
    }
}

