/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.indices;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.ExpandWildcard;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch._types.Time;
import co.elastic.clients.elasticsearch._types.mapping.DynamicMapping;
import co.elastic.clients.elasticsearch._types.mapping.DynamicTemplate;
import co.elastic.clients.elasticsearch._types.mapping.FieldNamesField;
import co.elastic.clients.elasticsearch._types.mapping.Property;
import co.elastic.clients.elasticsearch._types.mapping.RoutingField;
import co.elastic.clients.elasticsearch._types.mapping.RuntimeField;
import co.elastic.clients.elasticsearch._types.mapping.SourceField;
import co.elastic.clients.elasticsearch.indices.PutMappingResponse;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

@JsonpDeserializable
public class PutMappingRequest
extends RequestBase
implements JsonpSerializable {
    @Nullable
    private final FieldNamesField fieldNames;
    private final Map<String, JsonData> meta;
    @Nullable
    private final RoutingField routing;
    @Nullable
    private final SourceField source;
    @Nullable
    private final Boolean allowNoIndices;
    @Nullable
    private final Boolean dateDetection;
    @Nullable
    private final DynamicMapping dynamic;
    private final List<String> dynamicDateFormats;
    private final List<Map<String, DynamicTemplate>> dynamicTemplates;
    private final List<ExpandWildcard> expandWildcards;
    @Nullable
    private final Boolean ignoreUnavailable;
    @Nullable
    private final Boolean includeTypeName;
    private final List<String> index;
    @Nullable
    private final Time masterTimeout;
    @Nullable
    private final Boolean numericDetection;
    private final Map<String, Property> properties;
    private final Map<String, RuntimeField> runtime;
    @Nullable
    private final Time timeout;
    @Nullable
    private final String type;
    @Nullable
    private final Boolean writeIndexOnly;
    public static final JsonpDeserializer<PutMappingRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, PutMappingRequest::setupPutMappingRequestDeserializer);
    public static final Endpoint<PutMappingRequest, PutMappingResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<PutMappingRequest, PutMappingResponse>("es/indices.put_mapping", request -> "PUT", request -> {
        boolean _index = true;
        int _type = 2;
        int propsSet = 0;
        propsSet |= 1;
        if (request.type() != null) {
            propsSet |= 2;
        }
        if (propsSet == 1) {
            StringBuilder buf = new StringBuilder();
            buf.append("/");
            SimpleEndpoint.pathEncode(request.index.stream().map(v -> v).collect(Collectors.joining(",")), buf);
            buf.append("/_mapping");
            return buf.toString();
        }
        if (propsSet == 3) {
            StringBuilder buf = new StringBuilder();
            buf.append("/");
            SimpleEndpoint.pathEncode(request.index.stream().map(v -> v).collect(Collectors.joining(",")), buf);
            buf.append("/");
            SimpleEndpoint.pathEncode(request.type, buf);
            buf.append("/_mapping");
            return buf.toString();
        }
        if (propsSet == 3) {
            StringBuilder buf = new StringBuilder();
            buf.append("/");
            SimpleEndpoint.pathEncode(request.index.stream().map(v -> v).collect(Collectors.joining(",")), buf);
            buf.append("/_mapping");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.type, buf);
            return buf.toString();
        }
        if (propsSet == 3) {
            StringBuilder buf = new StringBuilder();
            buf.append("/");
            SimpleEndpoint.pathEncode(request.index.stream().map(v -> v).collect(Collectors.joining(",")), buf);
            buf.append("/");
            SimpleEndpoint.pathEncode(request.type, buf);
            buf.append("/_mappings");
            return buf.toString();
        }
        if (propsSet == 3) {
            StringBuilder buf = new StringBuilder();
            buf.append("/");
            SimpleEndpoint.pathEncode(request.index.stream().map(v -> v).collect(Collectors.joining(",")), buf);
            buf.append("/_mappings");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.type, buf);
            return buf.toString();
        }
        if (propsSet == 2) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_mappings");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.type, buf);
            return buf.toString();
        }
        if (propsSet == 1) {
            StringBuilder buf = new StringBuilder();
            buf.append("/");
            SimpleEndpoint.pathEncode(request.index.stream().map(v -> v).collect(Collectors.joining(",")), buf);
            buf.append("/_mappings");
            return buf.toString();
        }
        if (propsSet == 2) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_mapping");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.type, buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.masterTimeout != null) {
            params.put("master_timeout", request.masterTimeout._toJsonString());
        }
        if (request.includeTypeName != null) {
            params.put("include_type_name", String.valueOf(request.includeTypeName));
        }
        if (ApiTypeHelper.isDefined(request.expandWildcards)) {
            params.put("expand_wildcards", request.expandWildcards.stream().map(v -> v.jsonValue()).collect(Collectors.joining(",")));
        }
        if (request.ignoreUnavailable != null) {
            params.put("ignore_unavailable", String.valueOf(request.ignoreUnavailable));
        }
        if (request.allowNoIndices != null) {
            params.put("allow_no_indices", String.valueOf(request.allowNoIndices));
        }
        if (request.writeIndexOnly != null) {
            params.put("write_index_only", String.valueOf(request.writeIndexOnly));
        }
        if (request.timeout != null) {
            params.put("timeout", request.timeout._toJsonString());
        }
        return params;
    }, SimpleEndpoint.emptyMap(), true, PutMappingResponse._DESERIALIZER);

    private PutMappingRequest(Builder builder) {
        this.fieldNames = builder.fieldNames;
        this.meta = ApiTypeHelper.unmodifiable(builder.meta);
        this.routing = builder.routing;
        this.source = builder.source;
        this.allowNoIndices = builder.allowNoIndices;
        this.dateDetection = builder.dateDetection;
        this.dynamic = builder.dynamic;
        this.dynamicDateFormats = ApiTypeHelper.unmodifiable(builder.dynamicDateFormats);
        this.dynamicTemplates = ApiTypeHelper.unmodifiable(builder.dynamicTemplates);
        this.expandWildcards = ApiTypeHelper.unmodifiable(builder.expandWildcards);
        this.ignoreUnavailable = builder.ignoreUnavailable;
        this.includeTypeName = builder.includeTypeName;
        this.index = ApiTypeHelper.unmodifiableRequired(builder.index, (Object)this, "index");
        this.masterTimeout = builder.masterTimeout;
        this.numericDetection = builder.numericDetection;
        this.properties = ApiTypeHelper.unmodifiable(builder.properties);
        this.runtime = ApiTypeHelper.unmodifiable(builder.runtime);
        this.timeout = builder.timeout;
        this.type = builder.type;
        this.writeIndexOnly = builder.writeIndexOnly;
    }

    public static PutMappingRequest of(Function<Builder, ObjectBuilder<PutMappingRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final FieldNamesField fieldNames() {
        return this.fieldNames;
    }

    public final Map<String, JsonData> meta() {
        return this.meta;
    }

    @Nullable
    public final RoutingField routing() {
        return this.routing;
    }

    @Nullable
    public final SourceField source() {
        return this.source;
    }

    @Nullable
    public final Boolean allowNoIndices() {
        return this.allowNoIndices;
    }

    @Nullable
    public final Boolean dateDetection() {
        return this.dateDetection;
    }

    @Nullable
    public final DynamicMapping dynamic() {
        return this.dynamic;
    }

    public final List<String> dynamicDateFormats() {
        return this.dynamicDateFormats;
    }

    public final List<Map<String, DynamicTemplate>> dynamicTemplates() {
        return this.dynamicTemplates;
    }

    public final List<ExpandWildcard> expandWildcards() {
        return this.expandWildcards;
    }

    @Nullable
    public final Boolean ignoreUnavailable() {
        return this.ignoreUnavailable;
    }

    @Nullable
    public final Boolean includeTypeName() {
        return this.includeTypeName;
    }

    public final List<String> index() {
        return this.index;
    }

    @Nullable
    public final Time masterTimeout() {
        return this.masterTimeout;
    }

    @Nullable
    public final Boolean numericDetection() {
        return this.numericDetection;
    }

    public final Map<String, Property> properties() {
        return this.properties;
    }

    public final Map<String, RuntimeField> runtime() {
        return this.runtime;
    }

    @Nullable
    public final Time timeout() {
        return this.timeout;
    }

    @Nullable
    public final String type() {
        return this.type;
    }

    @Nullable
    public final Boolean writeIndexOnly() {
        return this.writeIndexOnly;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.fieldNames != null) {
            generator.writeKey("_field_names");
            this.fieldNames.serialize(generator, mapper);
        }
        if (ApiTypeHelper.isDefined(this.meta)) {
            generator.writeKey("_meta");
            generator.writeStartObject();
            for (Map.Entry<String, JsonData> entry : this.meta.entrySet()) {
                generator.writeKey(entry.getKey());
                entry.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.routing != null) {
            generator.writeKey("_routing");
            this.routing.serialize(generator, mapper);
        }
        if (this.source != null) {
            generator.writeKey("_source");
            this.source.serialize(generator, mapper);
        }
        if (this.dateDetection != null) {
            generator.writeKey("date_detection");
            generator.write(this.dateDetection);
        }
        if (this.dynamic != null) {
            generator.writeKey("dynamic");
            this.dynamic.serialize(generator, mapper);
        }
        if (ApiTypeHelper.isDefined(this.dynamicDateFormats)) {
            generator.writeKey("dynamic_date_formats");
            generator.writeStartArray();
            for (String string : this.dynamicDateFormats) {
                generator.write(string);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.dynamicTemplates)) {
            generator.writeKey("dynamic_templates");
            generator.writeStartArray();
            for (Map map : this.dynamicTemplates) {
                generator.writeStartObject();
                if (map != null) {
                    for (Map.Entry item1 : map.entrySet()) {
                        generator.writeKey((String)item1.getKey());
                        ((DynamicTemplate)item1.getValue()).serialize(generator, mapper);
                    }
                }
                generator.writeEnd();
            }
            generator.writeEnd();
        }
        if (this.numericDetection != null) {
            generator.writeKey("numeric_detection");
            generator.write(this.numericDetection);
        }
        if (ApiTypeHelper.isDefined(this.properties)) {
            generator.writeKey("properties");
            generator.writeStartObject();
            for (Map.Entry entry : this.properties.entrySet()) {
                generator.writeKey((String)entry.getKey());
                ((Property)entry.getValue()).serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.runtime)) {
            generator.writeKey("runtime");
            generator.writeStartObject();
            for (Map.Entry entry : this.runtime.entrySet()) {
                generator.writeKey((String)entry.getKey());
                ((RuntimeField)entry.getValue()).serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    protected static void setupPutMappingRequestDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::fieldNames, FieldNamesField._DESERIALIZER, "_field_names");
        op.add(Builder::meta, JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER), "_meta");
        op.add(Builder::routing, RoutingField._DESERIALIZER, "_routing");
        op.add(Builder::source, SourceField._DESERIALIZER, "_source");
        op.add(Builder::dateDetection, JsonpDeserializer.booleanDeserializer(), "date_detection");
        op.add(Builder::dynamic, DynamicMapping._DESERIALIZER, "dynamic");
        op.add(Builder::dynamicDateFormats, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "dynamic_date_formats");
        op.add(Builder::dynamicTemplates, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringMapDeserializer(DynamicTemplate._DESERIALIZER)), "dynamic_templates");
        op.add(Builder::numericDetection, JsonpDeserializer.booleanDeserializer(), "numeric_detection");
        op.add(Builder::properties, JsonpDeserializer.stringMapDeserializer(Property._DESERIALIZER), "properties");
        op.add(Builder::runtime, JsonpDeserializer.stringMapDeserializer(RuntimeField._DESERIALIZER), "runtime");
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements ObjectBuilder<PutMappingRequest> {
        @Nullable
        private FieldNamesField fieldNames;
        @Nullable
        private Map<String, JsonData> meta;
        @Nullable
        private RoutingField routing;
        @Nullable
        private SourceField source;
        @Nullable
        private Boolean allowNoIndices;
        @Nullable
        private Boolean dateDetection;
        @Nullable
        private DynamicMapping dynamic;
        @Nullable
        private List<String> dynamicDateFormats;
        @Nullable
        private List<Map<String, DynamicTemplate>> dynamicTemplates;
        @Nullable
        private List<ExpandWildcard> expandWildcards;
        @Nullable
        private Boolean ignoreUnavailable;
        @Nullable
        private Boolean includeTypeName;
        private List<String> index;
        @Nullable
        private Time masterTimeout;
        @Nullable
        private Boolean numericDetection;
        @Nullable
        private Map<String, Property> properties;
        @Nullable
        private Map<String, RuntimeField> runtime;
        @Nullable
        private Time timeout;
        @Nullable
        private String type;
        @Nullable
        private Boolean writeIndexOnly;

        public final Builder fieldNames(@Nullable FieldNamesField value) {
            this.fieldNames = value;
            return this;
        }

        public final Builder fieldNames(Function<FieldNamesField.Builder, ObjectBuilder<FieldNamesField>> fn) {
            return this.fieldNames(fn.apply(new FieldNamesField.Builder()).build());
        }

        public final Builder meta(Map<String, JsonData> map) {
            this.meta = Builder._mapPutAll(this.meta, map);
            return this;
        }

        public final Builder meta(String key, JsonData value) {
            this.meta = Builder._mapPut(this.meta, key, value);
            return this;
        }

        public final Builder routing(@Nullable RoutingField value) {
            this.routing = value;
            return this;
        }

        public final Builder routing(Function<RoutingField.Builder, ObjectBuilder<RoutingField>> fn) {
            return this.routing(fn.apply(new RoutingField.Builder()).build());
        }

        public final Builder source(@Nullable SourceField value) {
            this.source = value;
            return this;
        }

        public final Builder source(Function<SourceField.Builder, ObjectBuilder<SourceField>> fn) {
            return this.source(fn.apply(new SourceField.Builder()).build());
        }

        public final Builder allowNoIndices(@Nullable Boolean value) {
            this.allowNoIndices = value;
            return this;
        }

        public final Builder dateDetection(@Nullable Boolean value) {
            this.dateDetection = value;
            return this;
        }

        public final Builder dynamic(@Nullable DynamicMapping value) {
            this.dynamic = value;
            return this;
        }

        public final Builder dynamicDateFormats(List<String> list) {
            this.dynamicDateFormats = Builder._listAddAll(this.dynamicDateFormats, list);
            return this;
        }

        public final Builder dynamicDateFormats(String value, String ... values) {
            this.dynamicDateFormats = Builder._listAdd(this.dynamicDateFormats, value, values);
            return this;
        }

        public final Builder dynamicTemplates(List<Map<String, DynamicTemplate>> list) {
            this.dynamicTemplates = Builder._listAddAll(this.dynamicTemplates, list);
            return this;
        }

        public final Builder dynamicTemplates(Map<String, DynamicTemplate> value, Map<String, DynamicTemplate> ... values) {
            this.dynamicTemplates = Builder._listAdd(this.dynamicTemplates, value, values);
            return this;
        }

        public final Builder expandWildcards(List<ExpandWildcard> list) {
            this.expandWildcards = Builder._listAddAll(this.expandWildcards, list);
            return this;
        }

        public final Builder expandWildcards(ExpandWildcard value, ExpandWildcard ... values) {
            this.expandWildcards = Builder._listAdd(this.expandWildcards, value, values);
            return this;
        }

        public final Builder ignoreUnavailable(@Nullable Boolean value) {
            this.ignoreUnavailable = value;
            return this;
        }

        public final Builder includeTypeName(@Nullable Boolean value) {
            this.includeTypeName = value;
            return this;
        }

        public final Builder index(List<String> list) {
            this.index = Builder._listAddAll(this.index, list);
            return this;
        }

        public final Builder index(String value, String ... values) {
            this.index = Builder._listAdd(this.index, value, values);
            return this;
        }

        public final Builder masterTimeout(@Nullable Time value) {
            this.masterTimeout = value;
            return this;
        }

        public final Builder masterTimeout(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.masterTimeout(fn.apply(new Time.Builder()).build());
        }

        public final Builder numericDetection(@Nullable Boolean value) {
            this.numericDetection = value;
            return this;
        }

        public final Builder properties(Map<String, Property> map) {
            this.properties = Builder._mapPutAll(this.properties, map);
            return this;
        }

        public final Builder properties(String key, Property value) {
            this.properties = Builder._mapPut(this.properties, key, value);
            return this;
        }

        public final Builder properties(String key, Function<Property.Builder, ObjectBuilder<Property>> fn) {
            return this.properties(key, fn.apply(new Property.Builder()).build());
        }

        public final Builder runtime(Map<String, RuntimeField> map) {
            this.runtime = Builder._mapPutAll(this.runtime, map);
            return this;
        }

        public final Builder runtime(String key, RuntimeField value) {
            this.runtime = Builder._mapPut(this.runtime, key, value);
            return this;
        }

        public final Builder runtime(String key, Function<RuntimeField.Builder, ObjectBuilder<RuntimeField>> fn) {
            return this.runtime(key, fn.apply(new RuntimeField.Builder()).build());
        }

        public final Builder timeout(@Nullable Time value) {
            this.timeout = value;
            return this;
        }

        public final Builder timeout(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.timeout(fn.apply(new Time.Builder()).build());
        }

        public final Builder type(@Nullable String value) {
            this.type = value;
            return this;
        }

        public final Builder writeIndexOnly(@Nullable Boolean value) {
            this.writeIndexOnly = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public PutMappingRequest build() {
            this._checkSingleUse();
            return new PutMappingRequest(this);
        }
    }
}

