/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.core.bulk;

import co.elastic.clients.elasticsearch._types.Script;
import co.elastic.clients.elasticsearch.core.search.SourceConfig;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpSerializer;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.NamedDeserializer;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class UpdateAction<TDocument, TPartialDocument>
implements JsonpSerializable {
    @Nullable
    private final Boolean detectNoop;
    @Nullable
    private final TPartialDocument doc;
    @Nullable
    private final Boolean docAsUpsert;
    @Nullable
    private final Script script;
    @Nullable
    private final Boolean scriptedUpsert;
    @Nullable
    private final SourceConfig source;
    @Nullable
    private final TDocument upsert;
    @Nullable
    private final JsonpSerializer<TDocument> tDocumentSerializer;
    @Nullable
    private final JsonpSerializer<TPartialDocument> tPartialDocumentSerializer;
    public static final JsonpDeserializer<UpdateAction<Object, Object>> _DESERIALIZER = JsonpDeserializer.lazy(() -> UpdateAction.createUpdateActionDeserializer(new NamedDeserializer("co.elastic.clients:Deserializer:_global.bulk.TDocument"), new NamedDeserializer("co.elastic.clients:Deserializer:_global.bulk.TPartialDocument")));

    private UpdateAction(Builder<TDocument, TPartialDocument> builder) {
        this.detectNoop = ((Builder)builder).detectNoop;
        this.doc = ((Builder)builder).doc;
        this.docAsUpsert = ((Builder)builder).docAsUpsert;
        this.script = ((Builder)builder).script;
        this.scriptedUpsert = ((Builder)builder).scriptedUpsert;
        this.source = ((Builder)builder).source;
        this.upsert = ((Builder)builder).upsert;
        this.tDocumentSerializer = ((Builder)builder).tDocumentSerializer;
        this.tPartialDocumentSerializer = ((Builder)builder).tPartialDocumentSerializer;
    }

    public static <TDocument, TPartialDocument> UpdateAction<TDocument, TPartialDocument> of(Function<Builder<TDocument, TPartialDocument>, ObjectBuilder<UpdateAction<TDocument, TPartialDocument>>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Boolean detectNoop() {
        return this.detectNoop;
    }

    @Nullable
    public final TPartialDocument doc() {
        return this.doc;
    }

    @Nullable
    public final Boolean docAsUpsert() {
        return this.docAsUpsert;
    }

    @Nullable
    public final Script script() {
        return this.script;
    }

    @Nullable
    public final Boolean scriptedUpsert() {
        return this.scriptedUpsert;
    }

    @Nullable
    public final SourceConfig source() {
        return this.source;
    }

    @Nullable
    public final TDocument upsert() {
        return this.upsert;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.detectNoop != null) {
            generator.writeKey("detect_noop");
            generator.write(this.detectNoop);
        }
        if (this.doc != null) {
            generator.writeKey("doc");
            JsonpUtils.serialize(this.doc, generator, this.tPartialDocumentSerializer, mapper);
        }
        if (this.docAsUpsert != null) {
            generator.writeKey("doc_as_upsert");
            generator.write(this.docAsUpsert);
        }
        if (this.script != null) {
            generator.writeKey("script");
            this.script.serialize(generator, mapper);
        }
        if (this.scriptedUpsert != null) {
            generator.writeKey("scripted_upsert");
            generator.write(this.scriptedUpsert);
        }
        if (this.source != null) {
            generator.writeKey("_source");
            this.source.serialize(generator, mapper);
        }
        if (this.upsert != null) {
            generator.writeKey("upsert");
            JsonpUtils.serialize(this.upsert, generator, this.tDocumentSerializer, mapper);
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    public static <TDocument, TPartialDocument> JsonpDeserializer<UpdateAction<TDocument, TPartialDocument>> createUpdateActionDeserializer(JsonpDeserializer<TDocument> tDocumentDeserializer, JsonpDeserializer<TPartialDocument> tPartialDocumentDeserializer) {
        return ObjectBuilderDeserializer.createForObject(Builder::new, op -> UpdateAction.setupUpdateActionDeserializer(op, tDocumentDeserializer, tPartialDocumentDeserializer));
    }

    protected static <TDocument, TPartialDocument> void setupUpdateActionDeserializer(ObjectDeserializer<Builder<TDocument, TPartialDocument>> op, JsonpDeserializer<TDocument> tDocumentDeserializer, JsonpDeserializer<TPartialDocument> tPartialDocumentDeserializer) {
        op.add(Builder::detectNoop, JsonpDeserializer.booleanDeserializer(), "detect_noop");
        op.add(Builder::doc, tPartialDocumentDeserializer, "doc");
        op.add(Builder::docAsUpsert, JsonpDeserializer.booleanDeserializer(), "doc_as_upsert");
        op.add(Builder::script, Script._DESERIALIZER, "script");
        op.add(Builder::scriptedUpsert, JsonpDeserializer.booleanDeserializer(), "scripted_upsert");
        op.add(Builder::source, SourceConfig._DESERIALIZER, "_source");
        op.add(Builder::upsert, tDocumentDeserializer, "upsert");
    }

    public static class Builder<TDocument, TPartialDocument>
    extends WithJsonObjectBuilderBase<Builder<TDocument, TPartialDocument>>
    implements ObjectBuilder<UpdateAction<TDocument, TPartialDocument>> {
        @Nullable
        private Boolean detectNoop;
        @Nullable
        private TPartialDocument doc;
        @Nullable
        private Boolean docAsUpsert;
        @Nullable
        private Script script;
        @Nullable
        private Boolean scriptedUpsert;
        @Nullable
        private SourceConfig source;
        @Nullable
        private TDocument upsert;
        @Nullable
        private JsonpSerializer<TDocument> tDocumentSerializer;
        @Nullable
        private JsonpSerializer<TPartialDocument> tPartialDocumentSerializer;

        public final Builder<TDocument, TPartialDocument> detectNoop(@Nullable Boolean value) {
            this.detectNoop = value;
            return this;
        }

        public final Builder<TDocument, TPartialDocument> doc(@Nullable TPartialDocument value) {
            this.doc = value;
            return this;
        }

        public final Builder<TDocument, TPartialDocument> docAsUpsert(@Nullable Boolean value) {
            this.docAsUpsert = value;
            return this;
        }

        public final Builder<TDocument, TPartialDocument> script(@Nullable Script value) {
            this.script = value;
            return this;
        }

        public final Builder<TDocument, TPartialDocument> script(Function<Script.Builder, ObjectBuilder<Script>> fn) {
            return this.script(fn.apply(new Script.Builder()).build());
        }

        public final Builder<TDocument, TPartialDocument> scriptedUpsert(@Nullable Boolean value) {
            this.scriptedUpsert = value;
            return this;
        }

        public final Builder<TDocument, TPartialDocument> source(@Nullable SourceConfig value) {
            this.source = value;
            return this;
        }

        public final Builder<TDocument, TPartialDocument> source(Function<SourceConfig.Builder, ObjectBuilder<SourceConfig>> fn) {
            return this.source(fn.apply(new SourceConfig.Builder()).build());
        }

        public final Builder<TDocument, TPartialDocument> upsert(@Nullable TDocument value) {
            this.upsert = value;
            return this;
        }

        public final Builder<TDocument, TPartialDocument> tDocumentSerializer(@Nullable JsonpSerializer<TDocument> value) {
            this.tDocumentSerializer = value;
            return this;
        }

        public final Builder<TDocument, TPartialDocument> tPartialDocumentSerializer(@Nullable JsonpSerializer<TPartialDocument> value) {
            this.tPartialDocumentSerializer = value;
            return this;
        }

        @Override
        protected Builder<TDocument, TPartialDocument> self() {
            return this;
        }

        @Override
        public UpdateAction<TDocument, TPartialDocument> build() {
            this._checkSingleUse();
            return new UpdateAction(this);
        }
    }
}

