/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.mapping;

import co.elastic.clients.elasticsearch._types.mapping.AggregateMetricDoubleProperty;
import co.elastic.clients.elasticsearch._types.mapping.BinaryProperty;
import co.elastic.clients.elasticsearch._types.mapping.BooleanProperty;
import co.elastic.clients.elasticsearch._types.mapping.ByteNumberProperty;
import co.elastic.clients.elasticsearch._types.mapping.CompletionProperty;
import co.elastic.clients.elasticsearch._types.mapping.ConstantKeywordProperty;
import co.elastic.clients.elasticsearch._types.mapping.DateNanosProperty;
import co.elastic.clients.elasticsearch._types.mapping.DateProperty;
import co.elastic.clients.elasticsearch._types.mapping.DateRangeProperty;
import co.elastic.clients.elasticsearch._types.mapping.DenseVectorProperty;
import co.elastic.clients.elasticsearch._types.mapping.DoubleNumberProperty;
import co.elastic.clients.elasticsearch._types.mapping.DoubleRangeProperty;
import co.elastic.clients.elasticsearch._types.mapping.DynamicProperty;
import co.elastic.clients.elasticsearch._types.mapping.FieldAliasProperty;
import co.elastic.clients.elasticsearch._types.mapping.FlattenedProperty;
import co.elastic.clients.elasticsearch._types.mapping.FloatNumberProperty;
import co.elastic.clients.elasticsearch._types.mapping.FloatRangeProperty;
import co.elastic.clients.elasticsearch._types.mapping.GeoPointProperty;
import co.elastic.clients.elasticsearch._types.mapping.GeoShapeProperty;
import co.elastic.clients.elasticsearch._types.mapping.HalfFloatNumberProperty;
import co.elastic.clients.elasticsearch._types.mapping.HistogramProperty;
import co.elastic.clients.elasticsearch._types.mapping.IntegerNumberProperty;
import co.elastic.clients.elasticsearch._types.mapping.IntegerRangeProperty;
import co.elastic.clients.elasticsearch._types.mapping.IpProperty;
import co.elastic.clients.elasticsearch._types.mapping.IpRangeProperty;
import co.elastic.clients.elasticsearch._types.mapping.JoinProperty;
import co.elastic.clients.elasticsearch._types.mapping.KeywordProperty;
import co.elastic.clients.elasticsearch._types.mapping.LongNumberProperty;
import co.elastic.clients.elasticsearch._types.mapping.LongRangeProperty;
import co.elastic.clients.elasticsearch._types.mapping.MatchOnlyTextProperty;
import co.elastic.clients.elasticsearch._types.mapping.Murmur3HashProperty;
import co.elastic.clients.elasticsearch._types.mapping.NestedProperty;
import co.elastic.clients.elasticsearch._types.mapping.ObjectProperty;
import co.elastic.clients.elasticsearch._types.mapping.PercolatorProperty;
import co.elastic.clients.elasticsearch._types.mapping.PointProperty;
import co.elastic.clients.elasticsearch._types.mapping.PropertyVariant;
import co.elastic.clients.elasticsearch._types.mapping.RankFeatureProperty;
import co.elastic.clients.elasticsearch._types.mapping.RankFeaturesProperty;
import co.elastic.clients.elasticsearch._types.mapping.ScaledFloatNumberProperty;
import co.elastic.clients.elasticsearch._types.mapping.SearchAsYouTypeProperty;
import co.elastic.clients.elasticsearch._types.mapping.ShapeProperty;
import co.elastic.clients.elasticsearch._types.mapping.ShortNumberProperty;
import co.elastic.clients.elasticsearch._types.mapping.TextProperty;
import co.elastic.clients.elasticsearch._types.mapping.TokenCountProperty;
import co.elastic.clients.elasticsearch._types.mapping.UnsignedLongNumberProperty;
import co.elastic.clients.elasticsearch._types.mapping.VersionProperty;
import co.elastic.clients.elasticsearch._types.mapping.WildcardProperty;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonEnum;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.OpenTaggedUnion;
import co.elastic.clients.util.TaggedUnionUtils;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import jakarta.json.stream.JsonParser;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class Property
implements OpenTaggedUnion<Kind, Object>,
JsonpSerializable {
    private final Kind _kind;
    private final Object _value;
    @Nullable
    private final String _customKind;
    public static final JsonpDeserializer<Property> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, Property::setupPropertyDeserializer, Builder::build);

    @Override
    public final Kind _kind() {
        return this._kind;
    }

    @Override
    public final Object _get() {
        return this._value;
    }

    public Property(PropertyVariant value) {
        this._kind = ApiTypeHelper.requireNonNull(value._propertyKind(), this, "<variant kind>");
        this._value = ApiTypeHelper.requireNonNull(value, this, "<variant value>");
        this._customKind = null;
    }

    private Property(Builder builder) {
        this._kind = ApiTypeHelper.requireNonNull(builder._kind, builder, "<variant kind>");
        this._value = ApiTypeHelper.requireNonNull(builder._value, builder, "<variant value>");
        this._customKind = builder._customKind;
    }

    public static Property of(Function<Builder, ObjectBuilder<Property>> fn) {
        return fn.apply(new Builder()).build();
    }

    public Property(String kind, JsonData value) {
        this._kind = Kind._Custom;
        this._value = value;
        this._customKind = kind;
    }

    public boolean isAggregateMetricDouble() {
        return this._kind == Kind.AggregateMetricDouble;
    }

    public AggregateMetricDoubleProperty aggregateMetricDouble() {
        return (AggregateMetricDoubleProperty)TaggedUnionUtils.get(this, Kind.AggregateMetricDouble);
    }

    public boolean isBinary() {
        return this._kind == Kind.Binary;
    }

    public BinaryProperty binary() {
        return (BinaryProperty)TaggedUnionUtils.get(this, Kind.Binary);
    }

    public boolean isBoolean() {
        return this._kind == Kind.Boolean;
    }

    public BooleanProperty boolean_() {
        return (BooleanProperty)TaggedUnionUtils.get(this, Kind.Boolean);
    }

    public boolean isByte() {
        return this._kind == Kind.Byte;
    }

    public ByteNumberProperty byte_() {
        return (ByteNumberProperty)TaggedUnionUtils.get(this, Kind.Byte);
    }

    public boolean isCompletion() {
        return this._kind == Kind.Completion;
    }

    public CompletionProperty completion() {
        return (CompletionProperty)TaggedUnionUtils.get(this, Kind.Completion);
    }

    public boolean isConstantKeyword() {
        return this._kind == Kind.ConstantKeyword;
    }

    public ConstantKeywordProperty constantKeyword() {
        return (ConstantKeywordProperty)TaggedUnionUtils.get(this, Kind.ConstantKeyword);
    }

    public boolean isDateNanos() {
        return this._kind == Kind.DateNanos;
    }

    public DateNanosProperty dateNanos() {
        return (DateNanosProperty)TaggedUnionUtils.get(this, Kind.DateNanos);
    }

    public boolean isDate() {
        return this._kind == Kind.Date;
    }

    public DateProperty date() {
        return (DateProperty)TaggedUnionUtils.get(this, Kind.Date);
    }

    public boolean isDateRange() {
        return this._kind == Kind.DateRange;
    }

    public DateRangeProperty dateRange() {
        return (DateRangeProperty)TaggedUnionUtils.get(this, Kind.DateRange);
    }

    public boolean isDenseVector() {
        return this._kind == Kind.DenseVector;
    }

    public DenseVectorProperty denseVector() {
        return (DenseVectorProperty)TaggedUnionUtils.get(this, Kind.DenseVector);
    }

    public boolean isDouble() {
        return this._kind == Kind.Double;
    }

    public DoubleNumberProperty double_() {
        return (DoubleNumberProperty)TaggedUnionUtils.get(this, Kind.Double);
    }

    public boolean isDoubleRange() {
        return this._kind == Kind.DoubleRange;
    }

    public DoubleRangeProperty doubleRange() {
        return (DoubleRangeProperty)TaggedUnionUtils.get(this, Kind.DoubleRange);
    }

    public boolean isDynamicType() {
        return this._kind == Kind.DynamicType;
    }

    public DynamicProperty dynamicType() {
        return (DynamicProperty)TaggedUnionUtils.get(this, Kind.DynamicType);
    }

    public boolean isAlias() {
        return this._kind == Kind.Alias;
    }

    public FieldAliasProperty alias() {
        return (FieldAliasProperty)TaggedUnionUtils.get(this, Kind.Alias);
    }

    public boolean isFlattened() {
        return this._kind == Kind.Flattened;
    }

    public FlattenedProperty flattened() {
        return (FlattenedProperty)TaggedUnionUtils.get(this, Kind.Flattened);
    }

    public boolean isFloat() {
        return this._kind == Kind.Float;
    }

    public FloatNumberProperty float_() {
        return (FloatNumberProperty)TaggedUnionUtils.get(this, Kind.Float);
    }

    public boolean isFloatRange() {
        return this._kind == Kind.FloatRange;
    }

    public FloatRangeProperty floatRange() {
        return (FloatRangeProperty)TaggedUnionUtils.get(this, Kind.FloatRange);
    }

    public boolean isGeoPoint() {
        return this._kind == Kind.GeoPoint;
    }

    public GeoPointProperty geoPoint() {
        return (GeoPointProperty)TaggedUnionUtils.get(this, Kind.GeoPoint);
    }

    public boolean isGeoShape() {
        return this._kind == Kind.GeoShape;
    }

    public GeoShapeProperty geoShape() {
        return (GeoShapeProperty)TaggedUnionUtils.get(this, Kind.GeoShape);
    }

    public boolean isHalfFloat() {
        return this._kind == Kind.HalfFloat;
    }

    public HalfFloatNumberProperty halfFloat() {
        return (HalfFloatNumberProperty)TaggedUnionUtils.get(this, Kind.HalfFloat);
    }

    public boolean isHistogram() {
        return this._kind == Kind.Histogram;
    }

    public HistogramProperty histogram() {
        return (HistogramProperty)TaggedUnionUtils.get(this, Kind.Histogram);
    }

    public boolean isInteger() {
        return this._kind == Kind.Integer;
    }

    public IntegerNumberProperty integer() {
        return (IntegerNumberProperty)TaggedUnionUtils.get(this, Kind.Integer);
    }

    public boolean isIntegerRange() {
        return this._kind == Kind.IntegerRange;
    }

    public IntegerRangeProperty integerRange() {
        return (IntegerRangeProperty)TaggedUnionUtils.get(this, Kind.IntegerRange);
    }

    public boolean isIp() {
        return this._kind == Kind.Ip;
    }

    public IpProperty ip() {
        return (IpProperty)TaggedUnionUtils.get(this, Kind.Ip);
    }

    public boolean isIpRange() {
        return this._kind == Kind.IpRange;
    }

    public IpRangeProperty ipRange() {
        return (IpRangeProperty)TaggedUnionUtils.get(this, Kind.IpRange);
    }

    public boolean isJoin() {
        return this._kind == Kind.Join;
    }

    public JoinProperty join() {
        return (JoinProperty)TaggedUnionUtils.get(this, Kind.Join);
    }

    public boolean isKeyword() {
        return this._kind == Kind.Keyword;
    }

    public KeywordProperty keyword() {
        return (KeywordProperty)TaggedUnionUtils.get(this, Kind.Keyword);
    }

    public boolean isLong() {
        return this._kind == Kind.Long;
    }

    public LongNumberProperty long_() {
        return (LongNumberProperty)TaggedUnionUtils.get(this, Kind.Long);
    }

    public boolean isLongRange() {
        return this._kind == Kind.LongRange;
    }

    public LongRangeProperty longRange() {
        return (LongRangeProperty)TaggedUnionUtils.get(this, Kind.LongRange);
    }

    public boolean isMatchOnlyText() {
        return this._kind == Kind.MatchOnlyText;
    }

    public MatchOnlyTextProperty matchOnlyText() {
        return (MatchOnlyTextProperty)TaggedUnionUtils.get(this, Kind.MatchOnlyText);
    }

    public boolean isMurmur3() {
        return this._kind == Kind.Murmur3;
    }

    public Murmur3HashProperty murmur3() {
        return (Murmur3HashProperty)TaggedUnionUtils.get(this, Kind.Murmur3);
    }

    public boolean isNested() {
        return this._kind == Kind.Nested;
    }

    public NestedProperty nested() {
        return (NestedProperty)TaggedUnionUtils.get(this, Kind.Nested);
    }

    public boolean isObject() {
        return this._kind == Kind.Object;
    }

    public ObjectProperty object() {
        return (ObjectProperty)TaggedUnionUtils.get(this, Kind.Object);
    }

    public boolean isPercolator() {
        return this._kind == Kind.Percolator;
    }

    public PercolatorProperty percolator() {
        return (PercolatorProperty)TaggedUnionUtils.get(this, Kind.Percolator);
    }

    public boolean isPoint() {
        return this._kind == Kind.Point;
    }

    public PointProperty point() {
        return (PointProperty)TaggedUnionUtils.get(this, Kind.Point);
    }

    public boolean isRankFeature() {
        return this._kind == Kind.RankFeature;
    }

    public RankFeatureProperty rankFeature() {
        return (RankFeatureProperty)TaggedUnionUtils.get(this, Kind.RankFeature);
    }

    public boolean isRankFeatures() {
        return this._kind == Kind.RankFeatures;
    }

    public RankFeaturesProperty rankFeatures() {
        return (RankFeaturesProperty)TaggedUnionUtils.get(this, Kind.RankFeatures);
    }

    public boolean isScaledFloat() {
        return this._kind == Kind.ScaledFloat;
    }

    public ScaledFloatNumberProperty scaledFloat() {
        return (ScaledFloatNumberProperty)TaggedUnionUtils.get(this, Kind.ScaledFloat);
    }

    public boolean isSearchAsYouType() {
        return this._kind == Kind.SearchAsYouType;
    }

    public SearchAsYouTypeProperty searchAsYouType() {
        return (SearchAsYouTypeProperty)TaggedUnionUtils.get(this, Kind.SearchAsYouType);
    }

    public boolean isShape() {
        return this._kind == Kind.Shape;
    }

    public ShapeProperty shape() {
        return (ShapeProperty)TaggedUnionUtils.get(this, Kind.Shape);
    }

    public boolean isShort() {
        return this._kind == Kind.Short;
    }

    public ShortNumberProperty short_() {
        return (ShortNumberProperty)TaggedUnionUtils.get(this, Kind.Short);
    }

    public boolean isText() {
        return this._kind == Kind.Text;
    }

    public TextProperty text() {
        return (TextProperty)TaggedUnionUtils.get(this, Kind.Text);
    }

    public boolean isTokenCount() {
        return this._kind == Kind.TokenCount;
    }

    public TokenCountProperty tokenCount() {
        return (TokenCountProperty)TaggedUnionUtils.get(this, Kind.TokenCount);
    }

    public boolean isUnsignedLong() {
        return this._kind == Kind.UnsignedLong;
    }

    public UnsignedLongNumberProperty unsignedLong() {
        return (UnsignedLongNumberProperty)TaggedUnionUtils.get(this, Kind.UnsignedLong);
    }

    public boolean isVersion() {
        return this._kind == Kind.Version;
    }

    public VersionProperty version() {
        return (VersionProperty)TaggedUnionUtils.get(this, Kind.Version);
    }

    public boolean isWildcard() {
        return this._kind == Kind.Wildcard;
    }

    public WildcardProperty wildcard() {
        return (WildcardProperty)TaggedUnionUtils.get(this, Kind.Wildcard);
    }

    public boolean _isCustom() {
        return this._kind == Kind._Custom;
    }

    @Override
    @Nullable
    public final String _customKind() {
        return this._customKind;
    }

    public JsonData _custom() {
        return (JsonData)TaggedUnionUtils.get(this, Kind._Custom);
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        mapper.serialize(this._value, generator);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupPropertyDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::aggregateMetricDouble, AggregateMetricDoubleProperty._DESERIALIZER, "aggregate_metric_double");
        op.add(Builder::binary, BinaryProperty._DESERIALIZER, "binary");
        op.add(Builder::boolean_, BooleanProperty._DESERIALIZER, "boolean");
        op.add(Builder::byte_, ByteNumberProperty._DESERIALIZER, "byte");
        op.add(Builder::completion, CompletionProperty._DESERIALIZER, "completion");
        op.add(Builder::constantKeyword, ConstantKeywordProperty._DESERIALIZER, "constant_keyword");
        op.add(Builder::dateNanos, DateNanosProperty._DESERIALIZER, "date_nanos");
        op.add(Builder::date, DateProperty._DESERIALIZER, "date");
        op.add(Builder::dateRange, DateRangeProperty._DESERIALIZER, "date_range");
        op.add(Builder::denseVector, DenseVectorProperty._DESERIALIZER, "dense_vector");
        op.add(Builder::double_, DoubleNumberProperty._DESERIALIZER, "double");
        op.add(Builder::doubleRange, DoubleRangeProperty._DESERIALIZER, "double_range");
        op.add(Builder::dynamicType, DynamicProperty._DESERIALIZER, "{dynamic_type}");
        op.add(Builder::alias, FieldAliasProperty._DESERIALIZER, "alias");
        op.add(Builder::flattened, FlattenedProperty._DESERIALIZER, "flattened");
        op.add(Builder::float_, FloatNumberProperty._DESERIALIZER, "float");
        op.add(Builder::floatRange, FloatRangeProperty._DESERIALIZER, "float_range");
        op.add(Builder::geoPoint, GeoPointProperty._DESERIALIZER, "geo_point");
        op.add(Builder::geoShape, GeoShapeProperty._DESERIALIZER, "geo_shape");
        op.add(Builder::halfFloat, HalfFloatNumberProperty._DESERIALIZER, "half_float");
        op.add(Builder::histogram, HistogramProperty._DESERIALIZER, "histogram");
        op.add(Builder::integer, IntegerNumberProperty._DESERIALIZER, "integer");
        op.add(Builder::integerRange, IntegerRangeProperty._DESERIALIZER, "integer_range");
        op.add(Builder::ip, IpProperty._DESERIALIZER, "ip");
        op.add(Builder::ipRange, IpRangeProperty._DESERIALIZER, "ip_range");
        op.add(Builder::join, JoinProperty._DESERIALIZER, "join");
        op.add(Builder::keyword, KeywordProperty._DESERIALIZER, "keyword");
        op.add(Builder::long_, LongNumberProperty._DESERIALIZER, "long");
        op.add(Builder::longRange, LongRangeProperty._DESERIALIZER, "long_range");
        op.add(Builder::matchOnlyText, MatchOnlyTextProperty._DESERIALIZER, "match_only_text");
        op.add(Builder::murmur3, Murmur3HashProperty._DESERIALIZER, "murmur3");
        op.add(Builder::nested, NestedProperty._DESERIALIZER, "nested");
        op.add(Builder::object, ObjectProperty._DESERIALIZER, "object");
        op.add(Builder::percolator, PercolatorProperty._DESERIALIZER, "percolator");
        op.add(Builder::point, PointProperty._DESERIALIZER, "point");
        op.add(Builder::rankFeature, RankFeatureProperty._DESERIALIZER, "rank_feature");
        op.add(Builder::rankFeatures, RankFeaturesProperty._DESERIALIZER, "rank_features");
        op.add(Builder::scaledFloat, ScaledFloatNumberProperty._DESERIALIZER, "scaled_float");
        op.add(Builder::searchAsYouType, SearchAsYouTypeProperty._DESERIALIZER, "search_as_you_type");
        op.add(Builder::shape, ShapeProperty._DESERIALIZER, "shape");
        op.add(Builder::short_, ShortNumberProperty._DESERIALIZER, "short");
        op.add(Builder::text, TextProperty._DESERIALIZER, "text");
        op.add(Builder::tokenCount, TokenCountProperty._DESERIALIZER, "token_count");
        op.add(Builder::unsignedLong, UnsignedLongNumberProperty._DESERIALIZER, "unsigned_long");
        op.add(Builder::version, VersionProperty._DESERIALIZER, "version");
        op.add(Builder::wildcard, WildcardProperty._DESERIALIZER, "wildcard");
        op.setUnknownFieldHandler((builder, name, parser, mapper) -> {
            JsonpUtils.ensureCustomVariantsAllowed(parser, mapper);
            builder._custom((String)name, JsonData._DESERIALIZER.deserialize((JsonParser)parser, (JsonpMapper)mapper));
        });
        op.setTypeProperty("type", "object");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<Property> {
        private Kind _kind;
        private Object _value;
        private String _customKind;

        @Override
        protected Builder self() {
            return this;
        }

        public ObjectBuilder<Property> aggregateMetricDouble(AggregateMetricDoubleProperty v) {
            this._kind = Kind.AggregateMetricDouble;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Property> aggregateMetricDouble(Function<AggregateMetricDoubleProperty.Builder, ObjectBuilder<AggregateMetricDoubleProperty>> fn) {
            return this.aggregateMetricDouble(fn.apply(new AggregateMetricDoubleProperty.Builder()).build());
        }

        public ObjectBuilder<Property> binary(BinaryProperty v) {
            this._kind = Kind.Binary;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Property> binary(Function<BinaryProperty.Builder, ObjectBuilder<BinaryProperty>> fn) {
            return this.binary(fn.apply(new BinaryProperty.Builder()).build());
        }

        public ObjectBuilder<Property> boolean_(BooleanProperty v) {
            this._kind = Kind.Boolean;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Property> boolean_(Function<BooleanProperty.Builder, ObjectBuilder<BooleanProperty>> fn) {
            return this.boolean_(fn.apply(new BooleanProperty.Builder()).build());
        }

        public ObjectBuilder<Property> byte_(ByteNumberProperty v) {
            this._kind = Kind.Byte;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Property> byte_(Function<ByteNumberProperty.Builder, ObjectBuilder<ByteNumberProperty>> fn) {
            return this.byte_(fn.apply(new ByteNumberProperty.Builder()).build());
        }

        public ObjectBuilder<Property> completion(CompletionProperty v) {
            this._kind = Kind.Completion;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Property> completion(Function<CompletionProperty.Builder, ObjectBuilder<CompletionProperty>> fn) {
            return this.completion(fn.apply(new CompletionProperty.Builder()).build());
        }

        public ObjectBuilder<Property> constantKeyword(ConstantKeywordProperty v) {
            this._kind = Kind.ConstantKeyword;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Property> constantKeyword(Function<ConstantKeywordProperty.Builder, ObjectBuilder<ConstantKeywordProperty>> fn) {
            return this.constantKeyword(fn.apply(new ConstantKeywordProperty.Builder()).build());
        }

        public ObjectBuilder<Property> dateNanos(DateNanosProperty v) {
            this._kind = Kind.DateNanos;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Property> dateNanos(Function<DateNanosProperty.Builder, ObjectBuilder<DateNanosProperty>> fn) {
            return this.dateNanos(fn.apply(new DateNanosProperty.Builder()).build());
        }

        public ObjectBuilder<Property> date(DateProperty v) {
            this._kind = Kind.Date;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Property> date(Function<DateProperty.Builder, ObjectBuilder<DateProperty>> fn) {
            return this.date(fn.apply(new DateProperty.Builder()).build());
        }

        public ObjectBuilder<Property> dateRange(DateRangeProperty v) {
            this._kind = Kind.DateRange;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Property> dateRange(Function<DateRangeProperty.Builder, ObjectBuilder<DateRangeProperty>> fn) {
            return this.dateRange(fn.apply(new DateRangeProperty.Builder()).build());
        }

        public ObjectBuilder<Property> denseVector(DenseVectorProperty v) {
            this._kind = Kind.DenseVector;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Property> denseVector(Function<DenseVectorProperty.Builder, ObjectBuilder<DenseVectorProperty>> fn) {
            return this.denseVector(fn.apply(new DenseVectorProperty.Builder()).build());
        }

        public ObjectBuilder<Property> double_(DoubleNumberProperty v) {
            this._kind = Kind.Double;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Property> double_(Function<DoubleNumberProperty.Builder, ObjectBuilder<DoubleNumberProperty>> fn) {
            return this.double_(fn.apply(new DoubleNumberProperty.Builder()).build());
        }

        public ObjectBuilder<Property> doubleRange(DoubleRangeProperty v) {
            this._kind = Kind.DoubleRange;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Property> doubleRange(Function<DoubleRangeProperty.Builder, ObjectBuilder<DoubleRangeProperty>> fn) {
            return this.doubleRange(fn.apply(new DoubleRangeProperty.Builder()).build());
        }

        public ObjectBuilder<Property> dynamicType(DynamicProperty v) {
            this._kind = Kind.DynamicType;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Property> dynamicType(Function<DynamicProperty.Builder, ObjectBuilder<DynamicProperty>> fn) {
            return this.dynamicType(fn.apply(new DynamicProperty.Builder()).build());
        }

        public ObjectBuilder<Property> alias(FieldAliasProperty v) {
            this._kind = Kind.Alias;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Property> alias(Function<FieldAliasProperty.Builder, ObjectBuilder<FieldAliasProperty>> fn) {
            return this.alias(fn.apply(new FieldAliasProperty.Builder()).build());
        }

        public ObjectBuilder<Property> flattened(FlattenedProperty v) {
            this._kind = Kind.Flattened;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Property> flattened(Function<FlattenedProperty.Builder, ObjectBuilder<FlattenedProperty>> fn) {
            return this.flattened(fn.apply(new FlattenedProperty.Builder()).build());
        }

        public ObjectBuilder<Property> float_(FloatNumberProperty v) {
            this._kind = Kind.Float;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Property> float_(Function<FloatNumberProperty.Builder, ObjectBuilder<FloatNumberProperty>> fn) {
            return this.float_(fn.apply(new FloatNumberProperty.Builder()).build());
        }

        public ObjectBuilder<Property> floatRange(FloatRangeProperty v) {
            this._kind = Kind.FloatRange;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Property> floatRange(Function<FloatRangeProperty.Builder, ObjectBuilder<FloatRangeProperty>> fn) {
            return this.floatRange(fn.apply(new FloatRangeProperty.Builder()).build());
        }

        public ObjectBuilder<Property> geoPoint(GeoPointProperty v) {
            this._kind = Kind.GeoPoint;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Property> geoPoint(Function<GeoPointProperty.Builder, ObjectBuilder<GeoPointProperty>> fn) {
            return this.geoPoint(fn.apply(new GeoPointProperty.Builder()).build());
        }

        public ObjectBuilder<Property> geoShape(GeoShapeProperty v) {
            this._kind = Kind.GeoShape;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Property> geoShape(Function<GeoShapeProperty.Builder, ObjectBuilder<GeoShapeProperty>> fn) {
            return this.geoShape(fn.apply(new GeoShapeProperty.Builder()).build());
        }

        public ObjectBuilder<Property> halfFloat(HalfFloatNumberProperty v) {
            this._kind = Kind.HalfFloat;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Property> halfFloat(Function<HalfFloatNumberProperty.Builder, ObjectBuilder<HalfFloatNumberProperty>> fn) {
            return this.halfFloat(fn.apply(new HalfFloatNumberProperty.Builder()).build());
        }

        public ObjectBuilder<Property> histogram(HistogramProperty v) {
            this._kind = Kind.Histogram;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Property> histogram(Function<HistogramProperty.Builder, ObjectBuilder<HistogramProperty>> fn) {
            return this.histogram(fn.apply(new HistogramProperty.Builder()).build());
        }

        public ObjectBuilder<Property> integer(IntegerNumberProperty v) {
            this._kind = Kind.Integer;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Property> integer(Function<IntegerNumberProperty.Builder, ObjectBuilder<IntegerNumberProperty>> fn) {
            return this.integer(fn.apply(new IntegerNumberProperty.Builder()).build());
        }

        public ObjectBuilder<Property> integerRange(IntegerRangeProperty v) {
            this._kind = Kind.IntegerRange;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Property> integerRange(Function<IntegerRangeProperty.Builder, ObjectBuilder<IntegerRangeProperty>> fn) {
            return this.integerRange(fn.apply(new IntegerRangeProperty.Builder()).build());
        }

        public ObjectBuilder<Property> ip(IpProperty v) {
            this._kind = Kind.Ip;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Property> ip(Function<IpProperty.Builder, ObjectBuilder<IpProperty>> fn) {
            return this.ip(fn.apply(new IpProperty.Builder()).build());
        }

        public ObjectBuilder<Property> ipRange(IpRangeProperty v) {
            this._kind = Kind.IpRange;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Property> ipRange(Function<IpRangeProperty.Builder, ObjectBuilder<IpRangeProperty>> fn) {
            return this.ipRange(fn.apply(new IpRangeProperty.Builder()).build());
        }

        public ObjectBuilder<Property> join(JoinProperty v) {
            this._kind = Kind.Join;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Property> join(Function<JoinProperty.Builder, ObjectBuilder<JoinProperty>> fn) {
            return this.join(fn.apply(new JoinProperty.Builder()).build());
        }

        public ObjectBuilder<Property> keyword(KeywordProperty v) {
            this._kind = Kind.Keyword;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Property> keyword(Function<KeywordProperty.Builder, ObjectBuilder<KeywordProperty>> fn) {
            return this.keyword(fn.apply(new KeywordProperty.Builder()).build());
        }

        public ObjectBuilder<Property> long_(LongNumberProperty v) {
            this._kind = Kind.Long;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Property> long_(Function<LongNumberProperty.Builder, ObjectBuilder<LongNumberProperty>> fn) {
            return this.long_(fn.apply(new LongNumberProperty.Builder()).build());
        }

        public ObjectBuilder<Property> longRange(LongRangeProperty v) {
            this._kind = Kind.LongRange;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Property> longRange(Function<LongRangeProperty.Builder, ObjectBuilder<LongRangeProperty>> fn) {
            return this.longRange(fn.apply(new LongRangeProperty.Builder()).build());
        }

        public ObjectBuilder<Property> matchOnlyText(MatchOnlyTextProperty v) {
            this._kind = Kind.MatchOnlyText;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Property> matchOnlyText(Function<MatchOnlyTextProperty.Builder, ObjectBuilder<MatchOnlyTextProperty>> fn) {
            return this.matchOnlyText(fn.apply(new MatchOnlyTextProperty.Builder()).build());
        }

        public ObjectBuilder<Property> murmur3(Murmur3HashProperty v) {
            this._kind = Kind.Murmur3;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Property> murmur3(Function<Murmur3HashProperty.Builder, ObjectBuilder<Murmur3HashProperty>> fn) {
            return this.murmur3(fn.apply(new Murmur3HashProperty.Builder()).build());
        }

        public ObjectBuilder<Property> nested(NestedProperty v) {
            this._kind = Kind.Nested;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Property> nested(Function<NestedProperty.Builder, ObjectBuilder<NestedProperty>> fn) {
            return this.nested(fn.apply(new NestedProperty.Builder()).build());
        }

        public ObjectBuilder<Property> object(ObjectProperty v) {
            this._kind = Kind.Object;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Property> object(Function<ObjectProperty.Builder, ObjectBuilder<ObjectProperty>> fn) {
            return this.object(fn.apply(new ObjectProperty.Builder()).build());
        }

        public ObjectBuilder<Property> percolator(PercolatorProperty v) {
            this._kind = Kind.Percolator;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Property> percolator(Function<PercolatorProperty.Builder, ObjectBuilder<PercolatorProperty>> fn) {
            return this.percolator(fn.apply(new PercolatorProperty.Builder()).build());
        }

        public ObjectBuilder<Property> point(PointProperty v) {
            this._kind = Kind.Point;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Property> point(Function<PointProperty.Builder, ObjectBuilder<PointProperty>> fn) {
            return this.point(fn.apply(new PointProperty.Builder()).build());
        }

        public ObjectBuilder<Property> rankFeature(RankFeatureProperty v) {
            this._kind = Kind.RankFeature;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Property> rankFeature(Function<RankFeatureProperty.Builder, ObjectBuilder<RankFeatureProperty>> fn) {
            return this.rankFeature(fn.apply(new RankFeatureProperty.Builder()).build());
        }

        public ObjectBuilder<Property> rankFeatures(RankFeaturesProperty v) {
            this._kind = Kind.RankFeatures;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Property> rankFeatures(Function<RankFeaturesProperty.Builder, ObjectBuilder<RankFeaturesProperty>> fn) {
            return this.rankFeatures(fn.apply(new RankFeaturesProperty.Builder()).build());
        }

        public ObjectBuilder<Property> scaledFloat(ScaledFloatNumberProperty v) {
            this._kind = Kind.ScaledFloat;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Property> scaledFloat(Function<ScaledFloatNumberProperty.Builder, ObjectBuilder<ScaledFloatNumberProperty>> fn) {
            return this.scaledFloat(fn.apply(new ScaledFloatNumberProperty.Builder()).build());
        }

        public ObjectBuilder<Property> searchAsYouType(SearchAsYouTypeProperty v) {
            this._kind = Kind.SearchAsYouType;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Property> searchAsYouType(Function<SearchAsYouTypeProperty.Builder, ObjectBuilder<SearchAsYouTypeProperty>> fn) {
            return this.searchAsYouType(fn.apply(new SearchAsYouTypeProperty.Builder()).build());
        }

        public ObjectBuilder<Property> shape(ShapeProperty v) {
            this._kind = Kind.Shape;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Property> shape(Function<ShapeProperty.Builder, ObjectBuilder<ShapeProperty>> fn) {
            return this.shape(fn.apply(new ShapeProperty.Builder()).build());
        }

        public ObjectBuilder<Property> short_(ShortNumberProperty v) {
            this._kind = Kind.Short;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Property> short_(Function<ShortNumberProperty.Builder, ObjectBuilder<ShortNumberProperty>> fn) {
            return this.short_(fn.apply(new ShortNumberProperty.Builder()).build());
        }

        public ObjectBuilder<Property> text(TextProperty v) {
            this._kind = Kind.Text;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Property> text(Function<TextProperty.Builder, ObjectBuilder<TextProperty>> fn) {
            return this.text(fn.apply(new TextProperty.Builder()).build());
        }

        public ObjectBuilder<Property> tokenCount(TokenCountProperty v) {
            this._kind = Kind.TokenCount;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Property> tokenCount(Function<TokenCountProperty.Builder, ObjectBuilder<TokenCountProperty>> fn) {
            return this.tokenCount(fn.apply(new TokenCountProperty.Builder()).build());
        }

        public ObjectBuilder<Property> unsignedLong(UnsignedLongNumberProperty v) {
            this._kind = Kind.UnsignedLong;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Property> unsignedLong(Function<UnsignedLongNumberProperty.Builder, ObjectBuilder<UnsignedLongNumberProperty>> fn) {
            return this.unsignedLong(fn.apply(new UnsignedLongNumberProperty.Builder()).build());
        }

        public ObjectBuilder<Property> version(VersionProperty v) {
            this._kind = Kind.Version;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Property> version(Function<VersionProperty.Builder, ObjectBuilder<VersionProperty>> fn) {
            return this.version(fn.apply(new VersionProperty.Builder()).build());
        }

        public ObjectBuilder<Property> wildcard(WildcardProperty v) {
            this._kind = Kind.Wildcard;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Property> wildcard(Function<WildcardProperty.Builder, ObjectBuilder<WildcardProperty>> fn) {
            return this.wildcard(fn.apply(new WildcardProperty.Builder()).build());
        }

        public ObjectBuilder<Property> _custom(String name, Object data) {
            this._kind = Kind._Custom;
            this._customKind = name;
            this._value = JsonData.of(data);
            return this;
        }

        @Override
        public Property build() {
            this._checkSingleUse();
            return new Property(this);
        }
    }

    public static enum Kind implements JsonEnum
    {
        AggregateMetricDouble("aggregate_metric_double"),
        Binary("binary"),
        Boolean("boolean"),
        Byte("byte"),
        Completion("completion"),
        ConstantKeyword("constant_keyword"),
        DateNanos("date_nanos"),
        Date("date"),
        DateRange("date_range"),
        DenseVector("dense_vector"),
        Double("double"),
        DoubleRange("double_range"),
        DynamicType("{dynamic_type}"),
        Alias("alias"),
        Flattened("flattened"),
        Float("float"),
        FloatRange("float_range"),
        GeoPoint("geo_point"),
        GeoShape("geo_shape"),
        HalfFloat("half_float"),
        Histogram("histogram"),
        Integer("integer"),
        IntegerRange("integer_range"),
        Ip("ip"),
        IpRange("ip_range"),
        Join("join"),
        Keyword("keyword"),
        Long("long"),
        LongRange("long_range"),
        MatchOnlyText("match_only_text"),
        Murmur3("murmur3"),
        Nested("nested"),
        Object("object"),
        Percolator("percolator"),
        Point("point"),
        RankFeature("rank_feature"),
        RankFeatures("rank_features"),
        ScaledFloat("scaled_float"),
        SearchAsYouType("search_as_you_type"),
        Shape("shape"),
        Short("short"),
        Text("text"),
        TokenCount("token_count"),
        UnsignedLong("unsigned_long"),
        Version("version"),
        Wildcard("wildcard"),
        _Custom(null);

        private final String jsonValue;

        private Kind(String jsonValue) {
            this.jsonValue = jsonValue;
        }

        @Override
        public String jsonValue() {
            return this.jsonValue;
        }
    }
}

