/*
 * Decompiled with CFR 0.152.
 */
package com.beetstra.jutf7;

import com.beetstra.jutf7.Base64Util;
import com.beetstra.jutf7.UTF7StyleCharset;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;

class UTF7StyleCharsetEncoder
extends CharsetEncoder {
    private static final float AVG_BYTES_PER_CHAR = 1.5f;
    private static final float MAX_BYTES_PER_CHAR = 5.0f;
    private final UTF7StyleCharset cs;
    private final Base64Util base64;
    private final byte shift;
    private final byte unshift;
    private final boolean strict;
    private boolean base64mode;
    private int bitsToOutput;
    private int sextet;
    static boolean useUglyHackToForceCallToFlushInJava5;

    UTF7StyleCharsetEncoder(UTF7StyleCharset uTF7StyleCharset, Base64Util base64Util, boolean bl) {
        super(uTF7StyleCharset, 1.5f, 5.0f);
        this.cs = uTF7StyleCharset;
        this.base64 = base64Util;
        this.strict = bl;
        this.shift = uTF7StyleCharset.shift();
        this.unshift = uTF7StyleCharset.unshift();
    }

    protected void implReset() {
        this.base64mode = false;
        this.sextet = 0;
        this.bitsToOutput = 0;
    }

    protected CoderResult implFlush(ByteBuffer byteBuffer) {
        if (this.base64mode) {
            if (byteBuffer.remaining() < 2) {
                return CoderResult.OVERFLOW;
            }
            if (this.bitsToOutput != 0) {
                byteBuffer.put(this.base64.getChar(this.sextet));
            }
            byteBuffer.put(this.unshift);
        }
        return CoderResult.UNDERFLOW;
    }

    protected CoderResult encodeLoop(CharBuffer charBuffer, ByteBuffer byteBuffer) {
        while (charBuffer.hasRemaining()) {
            if (byteBuffer.remaining() < 4) {
                return CoderResult.OVERFLOW;
            }
            char c = charBuffer.get();
            if (this.cs.canEncodeDirectly(c)) {
                this.unshift(byteBuffer, c);
                byteBuffer.put((byte)c);
                continue;
            }
            if (this.strict && this.base64mode && c == this.shift) {
                this.unshift(byteBuffer, c);
                byteBuffer.put(this.shift);
                byteBuffer.put(this.unshift);
                continue;
            }
            if (!this.base64mode && c == this.shift) {
                byteBuffer.put(this.shift);
                byteBuffer.put(this.unshift);
                continue;
            }
            this.encodeBase64(c, byteBuffer);
        }
        if (this.base64mode && useUglyHackToForceCallToFlushInJava5 && (float)byteBuffer.limit() != 5.0f * (float)charBuffer.limit()) {
            return CoderResult.OVERFLOW;
        }
        return CoderResult.UNDERFLOW;
    }

    private void unshift(ByteBuffer byteBuffer, char c) {
        if (!this.base64mode) {
            return;
        }
        if (this.bitsToOutput != 0) {
            byteBuffer.put(this.base64.getChar(this.sextet));
        }
        if (this.base64.contains(c) || c == this.unshift || this.strict) {
            byteBuffer.put(this.unshift);
        }
        this.base64mode = false;
        this.sextet = 0;
        this.bitsToOutput = 0;
    }

    private void encodeBase64(char c, ByteBuffer byteBuffer) {
        if (!this.base64mode) {
            byteBuffer.put(this.shift);
        }
        this.base64mode = true;
        this.bitsToOutput += 16;
        while (this.bitsToOutput >= 6) {
            this.bitsToOutput -= 6;
            this.sextet += c >> this.bitsToOutput;
            this.sextet &= 0x3F;
            byteBuffer.put(this.base64.getChar(this.sextet));
            this.sextet = 0;
        }
        this.sextet = c << 6 - this.bitsToOutput & 0x3F;
    }

    static {
        String string = System.getProperty("java.specification.version");
        String string2 = System.getProperty("java.vm.vendor");
        useUglyHackToForceCallToFlushInJava5 = "1.4".equals(string) || "1.5".equals(string);
        useUglyHackToForceCallToFlushInJava5 &= "Sun Microsystems Inc.".equals(string2);
    }
}

