/*
 * Decompiled with CFR 0.152.
 */
package com.beetstra.jutf7;

import com.beetstra.jutf7.Base64Util;
import com.beetstra.jutf7.UTF7StyleCharset;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;

class UTF7StyleCharsetDecoder
extends CharsetDecoder {
    private final Base64Util base64;
    private final byte shift;
    private final byte unshift;
    private final boolean strict;
    private boolean base64mode;
    private int bitsRead;
    private int tempChar;
    private boolean justShifted;
    private boolean justUnshifted;

    UTF7StyleCharsetDecoder(UTF7StyleCharset uTF7StyleCharset, Base64Util base64Util, boolean bl) {
        super(uTF7StyleCharset, 0.6f, 1.0f);
        this.base64 = base64Util;
        this.strict = bl;
        this.shift = uTF7StyleCharset.shift();
        this.unshift = uTF7StyleCharset.unshift();
    }

    protected CoderResult decodeLoop(ByteBuffer byteBuffer, CharBuffer charBuffer) {
        while (byteBuffer.hasRemaining()) {
            byte by = byteBuffer.get();
            if (this.base64mode) {
                if (by == this.unshift) {
                    if (this.base64bitsWaiting()) {
                        return this.malformed(byteBuffer);
                    }
                    if (this.justShifted) {
                        if (!charBuffer.hasRemaining()) {
                            return this.overflow(byteBuffer);
                        }
                        charBuffer.put((char)this.shift);
                    } else {
                        this.justUnshifted = true;
                    }
                    this.setUnshifted();
                } else {
                    if (!charBuffer.hasRemaining()) {
                        return this.overflow(byteBuffer);
                    }
                    CoderResult coderResult = this.handleBase64(byteBuffer, charBuffer, by);
                    if (coderResult != null) {
                        return coderResult;
                    }
                }
                this.justShifted = false;
                continue;
            }
            if (by == this.shift) {
                this.base64mode = true;
                this.justShifted = true;
                continue;
            }
            if (!charBuffer.hasRemaining()) {
                return this.overflow(byteBuffer);
            }
            charBuffer.put((char)by);
            this.justUnshifted = false;
        }
        return CoderResult.UNDERFLOW;
    }

    private CoderResult overflow(ByteBuffer byteBuffer) {
        byteBuffer.position(byteBuffer.position() - 1);
        return CoderResult.OVERFLOW;
    }

    private CoderResult handleBase64(ByteBuffer byteBuffer, CharBuffer charBuffer, byte by) {
        CoderResult coderResult = null;
        int n = this.base64.getSextet(by);
        if (n >= 0) {
            this.bitsRead += 6;
            if (this.bitsRead < 16) {
                this.tempChar += n << 16 - this.bitsRead;
            } else {
                this.bitsRead -= 16;
                this.tempChar += n >> this.bitsRead;
                charBuffer.put((char)this.tempChar);
                this.tempChar = n << 16 - this.bitsRead & 0xFFFF;
            }
        } else {
            if (this.strict) {
                return this.malformed(byteBuffer);
            }
            charBuffer.put((char)by);
            if (this.base64bitsWaiting()) {
                coderResult = this.malformed(byteBuffer);
            }
            this.setUnshifted();
        }
        return coderResult;
    }

    protected CoderResult implFlush(CharBuffer charBuffer) {
        if (this.base64mode && this.strict || this.base64bitsWaiting()) {
            return CoderResult.malformedForLength(1);
        }
        return CoderResult.UNDERFLOW;
    }

    protected void implReset() {
        this.setUnshifted();
        this.justUnshifted = false;
    }

    private CoderResult malformed(ByteBuffer byteBuffer) {
        byteBuffer.position(byteBuffer.position() - 1);
        return CoderResult.malformedForLength(1);
    }

    private boolean base64bitsWaiting() {
        return this.tempChar != 0 || this.bitsRead >= 6;
    }

    private void setUnshifted() {
        this.base64mode = false;
        this.bitsRead = 0;
        this.tempChar = 0;
    }
}

