/*
 * Decompiled with CFR 0.152.
 */
package com.beetstra.jutf7;

import java.util.Arrays;

class Base64Util {
    private static final int ALPHABET_LENGTH = 64;
    private final char[] alphabet;
    private final int[] inverseAlphabet;

    Base64Util(String string) {
        this.alphabet = string.toCharArray();
        if (string.length() != 64) {
            throw new IllegalArgumentException("alphabet has incorrect length (should be 64, not " + string.length() + ")");
        }
        this.inverseAlphabet = new int[128];
        Arrays.fill(this.inverseAlphabet, -1);
        int n = 0;
        while (n < this.alphabet.length) {
            char c = this.alphabet[n];
            if (c >= '\u0080') {
                throw new IllegalArgumentException("invalid character in alphabet: " + c);
            }
            this.inverseAlphabet[c] = n++;
        }
    }

    int getSextet(byte by) {
        if (by >= 128) {
            return -1;
        }
        return this.inverseAlphabet[by];
    }

    boolean contains(char c) {
        if (c >= '\u0080') {
            return false;
        }
        return this.inverseAlphabet[c] >= 0;
    }

    byte getChar(int n) {
        return (byte)this.alphabet[n];
    }
}

