/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.core.metrics;

import io.github.resilience4j.core.metrics.CumulativeMeasurement;
import io.github.resilience4j.core.metrics.Metrics;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;

public class PackedAggregation
implements CumulativeMeasurement {
    private long[] durations = new long[2];
    private int[] counts = new int[8];
    private static final int TOTAL_DURATION_INDEX = 0;
    private static final int DURATION_INDEX = 1;
    private static final int TOTAL_SLOW_CALLS_INDEX = 0;
    private static final int TOTAL_FAILED_SLOW_CALLS_INDEX = 1;
    private static final int TOTAL_FAILED_CALLS_INDEX = 2;
    private static final int TOTAL_CALLS_INDEX = 3;
    private static final int SLOW_CALLS_INDEX = 4;
    private static final int FAILED_SLOW_CALLS_INDEX = 5;
    private static final int FAILED_CALLS_INDEX = 6;
    private static final int CALLS_INDEX = 7;

    public PackedAggregation() {
    }

    public PackedAggregation(long[] durations, int[] counts) {
        this.durations = durations;
        this.counts = counts;
    }

    PackedAggregation copy() {
        return new PackedAggregation((long[])this.durations.clone(), (int[])this.counts.clone());
    }

    void discard(PackedAggregation discarded) {
        this.durations[0] = this.durations[0] - discarded.durations[1];
        this.durations[1] = 0L;
        this.counts[0] = this.counts[0] - discarded.counts[4];
        this.counts[1] = this.counts[1] - discarded.counts[5];
        this.counts[2] = this.counts[2] - discarded.counts[6];
        this.counts[3] = this.counts[3] - discarded.counts[7];
        this.counts[4] = 0;
        this.counts[5] = 0;
        this.counts[6] = 0;
        this.counts[7] = 0;
    }

    @Override
    public void record(long duration, TimeUnit durationUnit, Metrics.Outcome outcome) {
        long durationInMillis = durationUnit.toMillis(duration);
        this.durations[0] = this.durations[0] + durationInMillis;
        this.durations[1] = this.durations[1] + durationInMillis;
        this.counts[3] = this.counts[3] + 1;
        this.counts[7] = this.counts[7] + 1;
        switch (outcome) {
            case SLOW_SUCCESS: {
                this.counts[0] = this.counts[0] + 1;
                this.counts[4] = this.counts[4] + 1;
                break;
            }
            case SLOW_ERROR: {
                this.counts[0] = this.counts[0] + 1;
                this.counts[4] = this.counts[4] + 1;
                this.counts[1] = this.counts[1] + 1;
                this.counts[5] = this.counts[5] + 1;
                this.counts[2] = this.counts[2] + 1;
                this.counts[6] = this.counts[6] + 1;
                break;
            }
            case ERROR: {
                this.counts[2] = this.counts[2] + 1;
                this.counts[6] = this.counts[6] + 1;
                break;
            }
        }
    }

    @Override
    public long getTotalDurationInMillis() {
        return this.durations[0];
    }

    @Override
    public int getNumberOfSlowCalls() {
        return this.counts[0];
    }

    @Override
    public int getNumberOfSlowFailedCalls() {
        return this.counts[1];
    }

    @Override
    public int getNumberOfFailedCalls() {
        return this.counts[2];
    }

    @Override
    public int getNumberOfCalls() {
        return this.counts[3];
    }

    public String toString() {
        return "PackedAggregation{durations=" + Arrays.toString(this.durations) + ", counts=" + Arrays.toString(this.counts) + "}";
    }
}

