/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.core.metrics;

import io.github.resilience4j.core.metrics.Measurement;
import io.github.resilience4j.core.metrics.Metrics;
import io.github.resilience4j.core.metrics.Snapshot;
import io.github.resilience4j.core.metrics.SnapshotImpl;
import io.github.resilience4j.core.metrics.TotalAggregation;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;

public class FixedSizeSlidingWindowMetrics
implements Metrics {
    private final int windowSize;
    private final TotalAggregation totalAggregation;
    private final Measurement[] measurements;
    int headIndex;
    private final ReentrantLock lock = new ReentrantLock();

    public FixedSizeSlidingWindowMetrics(int windowSize) {
        this.windowSize = windowSize;
        this.measurements = new Measurement[this.windowSize];
        this.headIndex = 0;
        for (int i = 0; i < this.windowSize; ++i) {
            this.measurements[i] = new Measurement();
        }
        this.totalAggregation = new TotalAggregation();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Snapshot record(long duration, TimeUnit durationUnit, Metrics.Outcome outcome) {
        this.lock.lock();
        try {
            this.totalAggregation.record(duration, durationUnit, outcome);
            this.moveWindowByOne().record(duration, durationUnit, outcome);
            SnapshotImpl snapshotImpl = new SnapshotImpl(this.totalAggregation);
            return snapshotImpl;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public Snapshot getSnapshot() {
        this.lock.lock();
        try {
            SnapshotImpl snapshotImpl = new SnapshotImpl(this.totalAggregation);
            return snapshotImpl;
        }
        finally {
            this.lock.unlock();
        }
    }

    private Measurement moveWindowByOne() {
        this.moveHeadIndexByOne();
        Measurement latestMeasurement = this.getLatestMeasurement();
        this.totalAggregation.removeBucket(latestMeasurement);
        latestMeasurement.reset();
        return latestMeasurement;
    }

    private Measurement getLatestMeasurement() {
        return this.measurements[this.headIndex];
    }

    void moveHeadIndexByOne() {
        this.headIndex = (this.headIndex + 1) % this.windowSize;
    }
}

