/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spectator.api;

import com.netflix.spectator.api.Tag;
import com.netflix.spectator.impl.Preconditions;

public final class BasicTag
implements Tag {
    private final String key;
    private final String value;
    private int hc;

    static BasicTag convert(Tag t) {
        return t instanceof BasicTag ? (BasicTag)t : new BasicTag(t.key(), t.value());
    }

    public BasicTag(String key, String value) {
        this.key = Preconditions.checkNotNull(key, "key");
        this.value = value;
        if (value == null) {
            String msg = String.format("parameter 'value' cannot be null (key=%s)", key);
            throw new NullPointerException(msg);
        }
    }

    @Override
    public String key() {
        return this.key;
    }

    @Override
    public String value() {
        return this.value;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof BasicTag)) {
            return false;
        }
        BasicTag other = (BasicTag)obj;
        return this.key.equals(other.key) && this.value.equals(other.value);
    }

    public int hashCode() {
        int h = this.hc;
        if (h == 0) {
            this.hc = h = 31 * this.key.hashCode() + this.value.hashCode();
        }
        return h;
    }

    public String toString() {
        return this.key + '=' + this.value;
    }
}

