/*
 * Decompiled with CFR 0.152.
 */
package net.bluemind.webmodules.webapp.webfilters.legacy;

import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class LegacyAppRedirectionLoader {
    private static final Logger logger = LoggerFactory.getLogger(LegacyAppRedirectionLoader.class);
    private Map<String, String> webmoduleIndexes;

    LegacyAppRedirectionLoader() {
    }

    public Map<String, String> load() {
        this.loadWebmodulesIndexes();
        return this.forEachExtensions("net.bluemind.webapp", "application").filter(iConfigurationElement -> this.isOldApplication((IConfigurationElement)iConfigurationElement)).collect(Collectors.toMap(iConfigurationElement -> this.getOldApplicationIndex((IConfigurationElement)iConfigurationElement), iConfigurationElement -> iConfigurationElement.getAttribute("href")));
    }

    private boolean isOldApplication(IConfigurationElement iConfigurationElement) {
        IConfigurationElement[] iConfigurationElementArray = iConfigurationElement.getChildren("embed");
        if (iConfigurationElementArray.length > 0) {
            String string = iConfigurationElementArray[0].getAttribute("src");
            String string2 = string.substring(0, string.lastIndexOf("/"));
            if (this.webmoduleIndexes.containsKey(string2)) {
                logger.info("External app {} with base {} is {}\u00a0legacy app", new Object[]{string, string2, string2 + "/" + this.webmoduleIndexes.get(string2)});
                return !string.equals(string2 + "/" + this.webmoduleIndexes.get(string2));
            }
            logger.info("External app {} is not a legacy App");
        }
        return false;
    }

    private String getOldApplicationIndex(IConfigurationElement iConfigurationElement) {
        String string = iConfigurationElement.getChildren("embed")[0].getAttribute("src");
        String string2 = string.substring(0, string.lastIndexOf("/"));
        return string2 + "/" + this.webmoduleIndexes.get(string2);
    }

    private void loadWebmodulesIndexes() {
        this.webmoduleIndexes = this.forEachExtensions("net.bluemind.webmodule", "web-module").collect(Collectors.toMap(iConfigurationElement -> iConfigurationElement.getAttribute("root"), iConfigurationElement -> Optional.ofNullable(iConfigurationElement.getAttribute("index")).orElse("index.html")));
    }

    private Stream<IConfigurationElement> forEachExtensions(String string, String string2) {
        IExtensionPoint iExtensionPoint = Platform.getExtensionRegistry().getExtensionPoint(string);
        if (iExtensionPoint == null) {
            logger.error("point {} not found.", (Object)string);
            return Stream.empty();
        }
        return Arrays.stream(iExtensionPoint.getExtensions()).flatMap(iExtension -> Arrays.stream(iExtension.getConfigurationElements())).filter(iConfigurationElement -> iConfigurationElement.getName().equals(string2));
    }
}

