/*
 * Decompiled with CFR 0.152.
 */
package net.bluemind.webmodules.webapp.webfilters.legacy;

import io.vertx.core.http.HttpServerRequest;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.bluemind.webmodules.webapp.webfilters.legacy.AbstractFilterChainLink;

class FilterOnRole
extends AbstractFilterChainLink {
    private final Set<String> roles;
    private static final String ROLE_MAIL_WEBAPP = "hasMailWebapp";
    private static final String ROLE_WEBMAIL = "hasWebmail";

    public FilterOnRole(String string, HttpServerRequest httpServerRequest) {
        super(string);
        this.roles = httpServerRequest.headers().get("BMRoles") != null ? new HashSet<String>(Arrays.asList(httpServerRequest.headers().get("BMRoles").split(","))) : Collections.emptySet();
    }

    @Override
    public boolean isResponsible(HttpServerRequest httpServerRequest) {
        return !this.roles.contains(ROLE_MAIL_WEBAPP) || !this.roles.contains(ROLE_WEBMAIL);
    }

    @Override
    protected void redirect(HttpServerRequest httpServerRequest, CompletableFuture<HttpServerRequest> completableFuture) {
        if (this.roles.contains(ROLE_WEBMAIL)) {
            this.goToApp(httpServerRequest, completableFuture);
        } else {
            this.goToWebApp(httpServerRequest, completableFuture);
        }
    }
}

