/*
 * Decompiled with CFR 0.152.
 */
package net.bluemind.webmodules.webapp.handlers;

import io.netty.util.AsciiString;
import io.vertx.core.Handler;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Stream;
import net.bluemind.webmodule.server.PreEncodedObject;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;

public class ServiceWorkerExtensions
implements Handler<HttpServerRequest> {
    private static final PreEncodedObject extensions = new PreEncodedObject(ServiceWorkerExtensions.loadExtensions());
    public static final AsciiString TEXT_JAVASCRIPT = AsciiString.cached((String)"text/javascript");

    public void handle(HttpServerRequest httpServerRequest) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("self.WebApp.$extensions.load(");
        stringBuffer.append(extensions.json());
        stringBuffer.append(");");
        httpServerRequest.response().putHeader((CharSequence)"Content-Type", (CharSequence)TEXT_JAVASCRIPT).setStatusCode(200).end(stringBuffer.toString());
    }

    private static JsonObject loadExtensions() {
        IExtensionPoint iExtensionPoint2 = Platform.getExtensionRegistry().getExtensionPoint("serviceworker.extension");
        if (iExtensionPoint2 == null) {
            return new JsonObject();
        }
        return Arrays.asList(iExtensionPoint2.getExtensions()).stream().flatMap(iExtension -> Stream.of(iExtension.getConfigurationElements())).map(iConfigurationElement -> Platform.getExtensionRegistry().getExtensionPoint(iConfigurationElement.getAttribute("id"))).filter(Objects::nonNull).reduce(new JsonObject(), (jsonObject, iExtensionPoint) -> jsonObject.put(iExtensionPoint.getUniqueIdentifier(), (Object)ServiceWorkerExtensions.toJson(iExtensionPoint)), (jsonObject, jsonObject2) -> new JsonObject());
    }

    private static JsonArray toJson(IExtensionPoint iExtensionPoint) {
        return Arrays.asList(iExtensionPoint.getExtensions()).stream().map(ServiceWorkerExtensions::toJson).reduce(new JsonArray(), (jsonArray, jsonObject) -> jsonArray.add(jsonObject), (jsonArray, jsonArray2) -> new JsonArray());
    }

    private static JsonObject toJson(IExtension iExtension) {
        return ServiceWorkerExtensions.toJson(iExtension.getConfigurationElements()).put("bundle", (Object)iExtension.getContributor().getName());
    }

    private static JsonObject toJson(IConfigurationElement[] iConfigurationElementArray) {
        JsonObject jsonObject = new JsonObject();
        IConfigurationElement[] iConfigurationElementArray2 = iConfigurationElementArray;
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement iConfigurationElement = iConfigurationElementArray2[n2];
            jsonObject.put(iConfigurationElement.getName(), (Object)ServiceWorkerExtensions.toJson(iConfigurationElement));
            ++n2;
        }
        return jsonObject;
    }

    private static JsonObject toJson(IConfigurationElement iConfigurationElement) {
        JsonObject jsonObject = new JsonObject();
        String[] stringArray = iConfigurationElement.getAttributeNames();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            jsonObject.put(string, (Object)iConfigurationElement.getAttribute(string));
            ++n2;
        }
        if (iConfigurationElement.getValue() != null) {
            jsonObject.put("body", (Object)iConfigurationElement.getValue());
        }
        if (iConfigurationElement.getChildren() != null) {
            jsonObject.put("children", (Object)ServiceWorkerExtensions.toJson(iConfigurationElement.getChildren()));
        }
        return jsonObject;
    }
}

