/*
 * Decompiled with CFR 0.152.
 */
package org.shredzone.acme4j.toolbox;

import edu.umd.cs.findbugs.annotations.Nullable;
import java.security.PublicKey;
import java.time.Duration;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.jose4j.json.JsonUtil;
import org.shredzone.acme4j.toolbox.AcmeUtils;
import org.shredzone.acme4j.toolbox.JSON;
import org.shredzone.acme4j.toolbox.JoseUtils;

public class JSONBuilder {
    private final Map<String, Object> data = new LinkedHashMap<String, Object>();

    public JSONBuilder put(String key, @Nullable Object value) {
        this.data.put(Objects.requireNonNull(key, "key"), value);
        return this;
    }

    public JSONBuilder put(String key, @Nullable Instant value) {
        if (value == null) {
            this.put(key, (Object)null);
            return this;
        }
        this.put(key, DateTimeFormatter.ISO_INSTANT.format(value));
        return this;
    }

    public JSONBuilder put(String key, @Nullable Duration value) {
        if (value == null) {
            this.put(key, (Object)null);
            return this;
        }
        this.put(key, value.getSeconds());
        return this;
    }

    public JSONBuilder putBase64(String key, byte[] data) {
        return this.put(key, AcmeUtils.base64UrlEncode(data));
    }

    public JSONBuilder putKey(String key, PublicKey publickey) {
        Objects.requireNonNull(publickey, "publickey");
        this.data.put(key, JoseUtils.publicKeyToJWK(publickey));
        return this;
    }

    public JSONBuilder object(String key) {
        JSONBuilder subBuilder = new JSONBuilder();
        this.data.put(key, subBuilder.data);
        return subBuilder;
    }

    public JSONBuilder array(String key, Collection<?> values) {
        this.data.put(key, values);
        return this;
    }

    public Map<String, Object> toMap() {
        return Collections.unmodifiableMap(this.data);
    }

    public JSON toJSON() {
        return JSON.parse(this.toString());
    }

    public String toString() {
        return JsonUtil.toJson(this.data);
    }
}

