/*
 * Decompiled with CFR 0.152.
 */
package org.shredzone.acme4j.connector;

import edu.umd.cs.findbugs.annotations.Nullable;
import java.net.Authenticator;
import java.net.ProxySelector;
import java.net.http.HttpClient;
import java.time.Duration;
import java.util.Optional;
import org.slf4j.LoggerFactory;

public class NetworkSettings {
    public static final String GZIP_PROPERTY_NAME = "org.shredzone.acme4j.gzip_compression";
    private ProxySelector proxySelector = HttpClient.Builder.NO_PROXY;
    private Duration timeout = Duration.ofSeconds(10L);
    @Nullable
    private Authenticator authenticator = null;
    private boolean compression = true;

    public NetworkSettings() {
        try {
            Optional.ofNullable(System.getProperty(GZIP_PROPERTY_NAME)).map(Boolean::parseBoolean).ifPresent(val -> {
                this.compression = val;
            });
        }
        catch (Exception ex) {
            LoggerFactory.getLogger(NetworkSettings.class).warn("Could not read system property: {}", (Object)GZIP_PROPERTY_NAME, (Object)ex);
        }
    }

    public ProxySelector getProxySelector() {
        return this.proxySelector;
    }

    public void setProxySelector(@Nullable ProxySelector proxySelector) {
        this.proxySelector = proxySelector != null ? proxySelector : HttpClient.Builder.NO_PROXY;
    }

    @Nullable
    public Authenticator getAuthenticator() {
        return this.authenticator;
    }

    public void setAuthenticator(@Nullable Authenticator authenticator) {
        this.authenticator = authenticator;
    }

    public Duration getTimeout() {
        return this.timeout;
    }

    public void setTimeout(Duration timeout) {
        if (timeout == null || timeout.isNegative() || timeout.isZero()) {
            throw new IllegalArgumentException("Timeout must be positive");
        }
        this.timeout = timeout;
    }

    public boolean isCompressionEnabled() {
        return this.compression;
    }

    public void setCompressionEnabled(boolean compression) {
        this.compression = compression;
    }
}

