/*
 * Decompiled with CFR 0.152.
 */
package stormpot.internal;

import java.util.concurrent.TimeUnit;
import stormpot.MetricsRecorder;
import stormpot.Poolable;
import stormpot.Reallocator;
import stormpot.Slot;
import stormpot.internal.TimingReallocatingAdaptor;

final class TimingReallocatorAdaptor<T extends Poolable>
extends TimingReallocatingAdaptor<T>
implements Reallocator<T> {
    TimingReallocatorAdaptor(Reallocator<T> allocator, MetricsRecorder metricsRecorder) {
        super(allocator, metricsRecorder);
    }

    @Override
    public T reallocate(Slot slot, T poolable) throws Exception {
        long start = System.nanoTime();
        try {
            T obj = ((Reallocator)this.allocator).reallocate(slot, poolable);
            long elapsedNanos = System.nanoTime() - start;
            long milliseconds = TimeUnit.NANOSECONDS.toMillis(elapsedNanos);
            this.metricsRecorder.recordReallocationLatencySampleMillis(milliseconds);
            return obj;
        }
        catch (Exception e) {
            long elapsedNanos = System.nanoTime() - start;
            long milliseconds = TimeUnit.NANOSECONDS.toMillis(elapsedNanos);
            this.metricsRecorder.recordReallocationFailureLatencySampleMillis(milliseconds);
            throw e;
        }
    }
}

