/*
 * Decompiled with CFR 0.152.
 */
package stormpot.internal;

import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.ArrayList;
import java.util.concurrent.LinkedTransferQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import stormpot.Allocator;
import stormpot.Completion;
import stormpot.MetricsRecorder;
import stormpot.Poolable;
import stormpot.Reallocator;
import stormpot.Timeout;
import stormpot.internal.AllocationController;
import stormpot.internal.AllocatorSwitch;
import stormpot.internal.BSlot;
import stormpot.internal.BSlotPadded;
import stormpot.internal.BaseSubscriber;
import stormpot.internal.BlazePool;
import stormpot.internal.NanoClock;
import stormpot.internal.PoolBuilderImpl;
import stormpot.internal.PreciseLeakDetector;
import stormpot.internal.ReallocatingAdaptor;
import stormpot.internal.RefillPile;
import stormpot.internal.StackCompletion;

public final class InlineAllocationController<T extends Poolable>
extends AllocationController<T> {
    private static final VarHandle SIZE;
    private static final VarHandle ALLOC_COUNT;
    private static final VarHandle FAILED_ALLOC_COUNT;
    private final LinkedTransferQueue<BSlot<T>> live;
    private final RefillPile<T> disregardPile;
    private final RefillPile<T> newAllocations;
    private final BSlot<T> poisonPill;
    private final MetricsRecorder metricsRecorder;
    private final AtomicLong poisonedSlots;
    private final PreciseLeakDetector leakDetector;
    private final boolean optimizeForMemory;
    private final StackCompletion shutdownCompletion;
    private final LinkedTransferQueue<AllocatorSwitch<T>> switchRequests;
    private volatile long targetSize;
    private volatile long size;
    private volatile boolean shutdown;
    private volatile long allocationCount;
    private volatile long failedAllocationCount;
    private Reallocator<T> allocator;
    private AllocatorSwitch<T> nextAllocator;
    private long priorGenerationObjectsToReplace;

    InlineAllocationController(LinkedTransferQueue<BSlot<T>> live, RefillPile<T> disregardPile, RefillPile<T> newAllocations, PoolBuilderImpl<T> builder, BSlot<T> poisonPill) {
        this.live = live;
        this.disregardPile = disregardPile;
        this.newAllocations = newAllocations;
        this.poisonPill = poisonPill;
        this.metricsRecorder = builder.getMetricsRecorder();
        this.poisonedSlots = new AtomicLong();
        this.allocator = builder.getAdaptedReallocator();
        this.optimizeForMemory = builder.isOptimizeForReducedMemoryUsage();
        this.leakDetector = builder.isPreciseLeakDetectionEnabled() ? new PreciseLeakDetector() : null;
        this.switchRequests = new LinkedTransferQueue();
        this.setTargetSize(builder.getSize());
        this.shutdownCompletion = new StackCompletion(this::shutdownCompletion);
    }

    @Override
    void offerDeadSlot(BSlot<T> slot) {
        if (this.shutdown) {
            this.dealloc(slot);
        } else {
            long s = this.size;
            while (s > this.targetSize) {
                if (!SIZE.compareAndSet(this, s, s - 1L)) continue;
                this.deallocSlot(slot);
                return;
            }
            this.realloc(slot);
        }
    }

    @Override
    synchronized Completion shutdown() {
        if (!this.shutdown) {
            BSlot<T> slot;
            this.shutdown = true;
            this.disregardPile.refill();
            this.newAllocations.refill();
            ArrayList<BSlot<T>> deferredSlots = new ArrayList<BSlot<T>>();
            while ((slot = this.live.poll()) != null) {
                if (slot.isDead() || slot.live2dead()) {
                    this.dealloc(slot);
                    this.unregisterWithLeakDetector(slot);
                    this.disregardPile.refill();
                    continue;
                }
                deferredSlots.add(slot);
            }
            for (BSlot bSlot : deferredSlots) {
                this.live.offer(bSlot);
            }
            this.poisonPill.dead2live();
            this.live.offer(this.poisonPill);
        }
        return this.shutdownCompletion;
    }

    private boolean shutdownCompletion(Timeout timeout) throws InterruptedException {
        long timeoutNanos;
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        if (this.size == 0L) {
            return true;
        }
        long startNanos = NanoClock.nanoTime();
        TimeUnit baseUnit = timeout == null ? null : timeout.getBaseUnit();
        long timeoutLeft = timeoutNanos = timeout == null ? 0L : timeout.getTimeoutInBaseUnit();
        long maxWaitQuantum = baseUnit == null ? 0L : baseUnit.convert(100L, TimeUnit.MILLISECONDS);
        this.disregardPile.refill();
        while (this.size > 0L) {
            BSlot<T> slot;
            if (timeoutLeft <= 0L && baseUnit != null) {
                return false;
            }
            long pollWait = Math.min(timeoutLeft, maxWaitQuantum);
            BSlot<T> bSlot = slot = baseUnit == null ? this.live.take() : this.live.poll(pollWait, baseUnit);
            if (slot == this.poisonPill) {
                slot = baseUnit == null ? this.live.take() : this.live.poll(pollWait, baseUnit);
                this.live.offer(this.poisonPill);
            }
            timeoutLeft = NanoClock.timeoutLeft(startNanos, timeoutNanos);
            if (slot == null) {
                this.disregardPile.refill();
                continue;
            }
            if (slot.isDead() || slot.live2dead()) {
                this.dealloc(slot);
                this.unregisterWithLeakDetector(slot);
                continue;
            }
            this.live.offer(slot);
        }
        return true;
    }

    @Override
    Completion switchAllocator(Allocator<T> replacementAllocator) {
        StackCompletion completion = new StackCompletion(this::reallocateForAllocatorSwitch);
        Reallocator<T> reallocator = ReallocatingAdaptor.adapt(replacementAllocator, this.metricsRecorder);
        AllocatorSwitch<T> switchRequest = new AllocatorSwitch<T>(completion, reallocator);
        this.switchRequests.offer(switchRequest);
        if (this.shutdown) {
            AllocatorSwitch<T> entry;
            while ((entry = this.switchRequests.poll()) != null) {
                entry.completion().complete();
            }
        } else {
            this.shutdownCompletion.propagateTo(completion);
        }
        return completion;
    }

    private synchronized boolean reallocateForAllocatorSwitch(Timeout timeout) {
        BSlot<T> slot;
        this.checkForAllocatorSwitch();
        this.newAllocations.refill();
        this.disregardPile.refill();
        while ((slot = this.live.poll()) != null) {
            if (slot.allocator != this.allocator && slot.live2dead()) {
                this.dealloc(slot);
                if (this.size >= this.targetSize) continue;
                this.alloc(slot);
                continue;
            }
            this.disregardPile.push(slot);
        }
        return this.priorGenerationObjectsToReplace == 0L;
    }

    private void checkForAllocatorSwitch() {
        if (!this.switchRequests.isEmpty()) {
            this.switchToLatestAllocator();
        }
    }

    private synchronized void switchToLatestAllocator() {
        AllocatorSwitch<T> newSwitch;
        ArrayList<StackCompletion> skippedCompletions = null;
        AllocatorSwitch<T> previous = this.nextAllocator;
        while ((newSwitch = this.switchRequests.poll()) != null) {
            if (previous != null) {
                if (skippedCompletions == null) {
                    skippedCompletions = new ArrayList<StackCompletion>();
                }
                skippedCompletions.add(previous.completion());
            }
            previous = newSwitch;
        }
        if (previous != null && skippedCompletions != null) {
            final ArrayList<StackCompletion> skipped = skippedCompletions;
            previous.completion().subscribe(new BaseSubscriber(this){

                @Override
                public void onComplete() {
                    for (StackCompletion completion : skipped) {
                        completion.complete();
                    }
                }
            });
        }
        if (previous != this.nextAllocator) {
            this.priorGenerationObjectsToReplace = this.size;
            this.allocator = previous.allocator();
            this.nextAllocator = previous;
        }
    }

    @Override
    synchronized void setTargetSize(long targetSize) {
        if (this.shutdown) {
            return;
        }
        this.targetSize = targetSize;
        this.changePoolSize(targetSize);
    }

    @Override
    long getTargetSize() {
        return this.targetSize;
    }

    @Override
    long getAllocationCount() {
        return this.allocationCount;
    }

    @Override
    long getFailedAllocationCount() {
        return this.failedAllocationCount;
    }

    @Override
    long countLeakedObjects() {
        if (this.leakDetector != null) {
            return this.leakDetector.countLeakedObjects();
        }
        return -1L;
    }

    private void registerWithLeakDetector(BSlot<T> slot) {
        if (this.leakDetector != null) {
            this.leakDetector.register(slot);
        }
    }

    private void unregisterWithLeakDetector(BSlot<T> slot) {
        if (this.leakDetector != null) {
            this.leakDetector.unregister(slot);
        }
    }

    private void changePoolSize(long targetSize) {
        while (this.size != targetSize) {
            if (this.size < targetSize) {
                this.allocate();
                continue;
            }
            if (this.tryDeallocate()) continue;
            return;
        }
    }

    private void allocate() {
        BSlot<T> slot = this.optimizeForMemory ? new BSlot<T>(this.live, this.poisonedSlots) : new BSlotPadded<T>(this.live, this.poisonedSlots);
        this.alloc(slot);
        this.registerWithLeakDetector(slot);
    }

    private void alloc(BSlot<T> slot) {
        this.checkForAllocatorSwitch();
        boolean success = false;
        try {
            slot.obj = this.allocator.allocate(slot);
            if (slot.obj == null) {
                this.poisonedSlots.getAndIncrement();
                slot.poison = new NullPointerException("Allocation returned null.");
            } else {
                slot.allocator = this.allocator;
                success = true;
            }
        }
        catch (Exception e) {
            this.poisonedSlots.getAndIncrement();
            slot.poison = e;
        }
        long ignore = SIZE.getAndAdd(this, 1L);
        this.publishSlot(slot, success, NanoClock.nanoTime());
    }

    private void publishSlot(BSlot<T> slot, boolean success, long now) {
        this.resetSlot(slot, now);
        if (success && !this.live.hasWaitingConsumer()) {
            this.newAllocations.push(slot);
        } else {
            this.live.offer(slot);
        }
        this.incrementAllocationCounts(success);
    }

    private void incrementAllocationCounts(boolean success) {
        if (success) {
            long l = ALLOC_COUNT.getAndAdd(this, 1L);
        } else {
            long l = FAILED_ALLOC_COUNT.getAndAdd(this, 1L);
        }
    }

    private void resetSlot(BSlot<T> slot, long now) {
        slot.createdNanos = now;
        slot.stamp = 0L;
        slot.dead2live();
    }

    private boolean tryDeallocate() {
        BSlot<T> slot = this.live.poll();
        if (slot == null) {
            if (!this.disregardPile.refill()) {
                this.newAllocations.refill();
            }
            slot = this.live.poll();
        }
        boolean firstIteration = true;
        while (slot != null) {
            if (slot.isDead() || slot.live2dead()) {
                this.dealloc(slot);
                this.unregisterWithLeakDetector(slot);
                return true;
            }
            if (firstIteration) {
                this.disregardPile.refill();
                this.newAllocations.refill();
                firstIteration = false;
            }
            this.disregardPile.push(slot);
            slot = this.live.poll();
        }
        return false;
    }

    private void dealloc(BSlot<T> slot) {
        long ignore = SIZE.getAndAdd(this, -1L);
        this.deallocSlot(slot);
    }

    private void deallocSlot(BSlot<T> slot) {
        this.checkForAllocatorSwitch();
        try {
            if (slot.poison == BlazePool.EXPLICIT_EXPIRE_POISON) {
                slot.poison = null;
                this.poisonedSlots.getAndDecrement();
            }
            if (slot.poison == null) {
                this.recordObjectLifetimeSample(NanoClock.elapsed(slot.createdNanos));
                slot.allocator.deallocate(slot.obj);
            } else {
                this.poisonedSlots.getAndDecrement();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        slot.poison = null;
        slot.obj = null;
        if (slot.allocator != this.allocator) {
            this.replacedPriorGenerationSlot();
        }
    }

    private void realloc(BSlot<T> slot) {
        this.checkForAllocatorSwitch();
        if (slot.poison == BlazePool.EXPLICIT_EXPIRE_POISON) {
            slot.poison = null;
            this.poisonedSlots.getAndDecrement();
        }
        if (slot.poison == null && this.nextAllocator == null) {
            boolean success = false;
            try {
                slot.obj = this.allocator.reallocate(slot, slot.obj);
                if (slot.obj == null) {
                    this.poisonedSlots.getAndIncrement();
                    slot.poison = new NullPointerException("Reallocation returned null.");
                } else {
                    success = true;
                }
            }
            catch (Exception e) {
                this.poisonedSlots.getAndIncrement();
                slot.poison = e;
            }
            long now = NanoClock.nanoTime();
            this.recordObjectLifetimeSample(now - slot.createdNanos);
            this.publishSlot(slot, success, now);
        } else {
            this.dealloc(slot);
            this.alloc(slot);
        }
    }

    private void recordObjectLifetimeSample(long nanoseconds) {
        if (this.metricsRecorder != null) {
            long milliseconds = TimeUnit.NANOSECONDS.toMillis(nanoseconds);
            this.metricsRecorder.recordObjectLifetimeSampleMillis(milliseconds);
        }
    }

    private void replacedPriorGenerationSlot() {
        if (--this.priorGenerationObjectsToReplace == 0L) {
            this.nextAllocator.completion().complete();
            this.nextAllocator = null;
        }
    }

    @Override
    public long allocatedSize() {
        return (long)this.live.size() - this.poisonedSlots.get();
    }

    @Override
    long inUse() {
        long inUse = 0L;
        long liveSize = 0L;
        for (BSlot<T> slot : this.live) {
            ++liveSize;
            if (!slot.isClaimedOrThreadLocal()) continue;
            ++inUse;
        }
        return this.size - liveSize + inUse;
    }

    static {
        try {
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            Class<InlineAllocationController> receiver = InlineAllocationController.class;
            SIZE = lookup.findVarHandle(receiver, "size", Long.TYPE).withInvokeExactBehavior();
            ALLOC_COUNT = lookup.findVarHandle(receiver, "allocationCount", Long.TYPE).withInvokeExactBehavior();
            FAILED_ALLOC_COUNT = lookup.findVarHandle(receiver, "failedAllocationCount", Long.TYPE).withInvokeExactBehavior();
        }
        catch (Exception e) {
            throw new LinkageError("Failed to create VarHandle.", e);
        }
    }
}

