/*
 * Decompiled with CFR 0.152.
 */
package stormpot.internal;

import java.util.ArrayList;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedTransferQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.LockSupport;
import stormpot.Allocator;
import stormpot.Completion;
import stormpot.Expiration;
import stormpot.MetricsRecorder;
import stormpot.Poolable;
import stormpot.Reallocator;
import stormpot.internal.AllocatorSwitch;
import stormpot.internal.BSlot;
import stormpot.internal.BSlotPadded;
import stormpot.internal.BaseSubscriber;
import stormpot.internal.BlazePool;
import stormpot.internal.NanoClock;
import stormpot.internal.PoolBuilderImpl;
import stormpot.internal.PreciseLeakDetector;
import stormpot.internal.ReallocatingAdaptor;
import stormpot.internal.RefillPile;
import stormpot.internal.StackCompletion;

public final class BAllocThread<T extends Poolable>
implements Runnable {
    private static final long shutdownPauseNanos = TimeUnit.MILLISECONDS.toNanos(10L);
    private final LinkedTransferQueue<BSlot<T>> live;
    private final RefillPile<T> disregardPile;
    private final RefillPile<T> newAllocations;
    private final BSlot<T> poisonPill;
    private final MetricsRecorder metricsRecorder;
    private final Expiration<? super T> expiration;
    private final boolean backgroundExpirationEnabled;
    private final PreciseLeakDetector leakDetector;
    private final StackCompletion shutdownCompletion;
    private final BlockingQueue<BSlot<T>> dead;
    private final AtomicLong poisonedSlots;
    private final long defaultDeadPollTimeout;
    private final boolean optimizeForMemory;
    private final LinkedTransferQueue<AllocatorSwitch<T>> switchRequests;
    private volatile long targetSize;
    private volatile boolean shutdown;
    private volatile long allocationCount;
    private volatile long failedAllocationCount;
    private Reallocator<T> allocator;
    private long size;
    private boolean didAnythingLastIteration;
    private long consecutiveAllocationFailures;
    private AllocatorSwitch<T> nextAllocator;
    private long priorGenerationObjectsToReplace;

    BAllocThread(LinkedTransferQueue<BSlot<T>> live, RefillPile<T> disregardPile, RefillPile<T> newAllocations, PoolBuilderImpl<T> builder, BSlot<T> poisonPill) {
        this.live = live;
        this.disregardPile = disregardPile;
        this.newAllocations = newAllocations;
        this.allocator = builder.getAdaptedReallocator();
        this.targetSize = builder.getSize();
        this.metricsRecorder = builder.getMetricsRecorder();
        this.poisonPill = poisonPill;
        this.expiration = builder.getExpiration();
        this.backgroundExpirationEnabled = builder.isBackgroundExpirationEnabled();
        this.leakDetector = builder.isPreciseLeakDetectionEnabled() ? new PreciseLeakDetector() : null;
        this.shutdownCompletion = new StackCompletion();
        this.dead = new LinkedTransferQueue<BSlot<T>>();
        this.poisonedSlots = new AtomicLong();
        this.defaultDeadPollTimeout = builder.getBackgroundExpirationCheckDelay();
        this.optimizeForMemory = builder.isOptimizeForReducedMemoryUsage();
        this.switchRequests = new LinkedTransferQueue();
        this.size = 0L;
        this.didAnythingLastIteration = true;
    }

    @Override
    public void run() {
        this.continuouslyReplenishPool();
        this.shutPoolDown();
        this.shutdownCompletion.complete();
    }

    private void continuouslyReplenishPool() {
        try {
            while (!this.shutdown) {
                this.replenishPool();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.poisonPill.dead2live();
        this.live.offer(this.poisonPill);
    }

    private void replenishPool() throws InterruptedException {
        long deadPollTimeout = this.computeDeadPollTimeout();
        BSlot<T> slot = deadPollTimeout == 0L ? (BSlot<T>)this.dead.poll() : this.dead.poll(deadPollTimeout, TimeUnit.MILLISECONDS);
        this.checkForAllocatorSwitch();
        if (this.size < this.targetSize) {
            this.increaseSizeByAllocating();
        }
        if (this.size > this.targetSize) {
            this.reduceSizeByDeallocating(slot);
        } else if (slot != null) {
            this.reallocateDeadSlot(slot);
        }
        if (this.leakDetector != null) {
            this.leakDetector.countLeakedObjects();
        }
        if (this.shutdown) {
            return;
        }
        if (this.poisonedSlots.get() > 0L) {
            this.proactivelyHealPoison();
        } else if (this.priorGenerationObjectsToReplace > 0L || this.backgroundExpirationEnabled && this.size == this.targetSize) {
            this.backgroundCheck();
        }
    }

    private void checkForAllocatorSwitch() {
        AllocatorSwitch<T> newSwitch;
        ArrayList<StackCompletion> skippedCompletions = null;
        AllocatorSwitch<T> previous = this.nextAllocator;
        while ((newSwitch = this.switchRequests.poll()) != null) {
            if (previous != null) {
                if (skippedCompletions == null) {
                    skippedCompletions = new ArrayList<StackCompletion>();
                }
                skippedCompletions.add(previous.completion());
            }
            previous = newSwitch;
        }
        if (previous != null && skippedCompletions != null) {
            final ArrayList<StackCompletion> skipped = skippedCompletions;
            previous.completion().subscribe(new BaseSubscriber(this){

                @Override
                public void onComplete() {
                    for (StackCompletion completion : skipped) {
                        completion.complete();
                    }
                }
            });
        }
        if (previous != this.nextAllocator) {
            this.priorGenerationObjectsToReplace = this.size;
            this.allocator = previous.allocator();
            this.nextAllocator = previous;
        }
    }

    private long computeDeadPollTimeout() {
        long deadPollTimeout = this.defaultDeadPollTimeout;
        if (this.size != this.targetSize || this.poisonedSlots.get() > 0L) {
            deadPollTimeout = this.didAnythingLastIteration ? 0 : 10;
            deadPollTimeout += Math.min(this.consecutiveAllocationFailures, this.defaultDeadPollTimeout - deadPollTimeout);
        }
        this.didAnythingLastIteration = false;
        return deadPollTimeout;
    }

    private void increaseSizeByAllocating() {
        BSlot<T> slot = this.optimizeForMemory ? new BSlot<T>(this.live, this.poisonedSlots) : new BSlotPadded<T>(this.live, this.poisonedSlots);
        this.alloc(slot);
        this.registerWithLeakDetector(slot);
    }

    private void reduceSizeByDeallocating(BSlot<T> slot) {
        if (slot == null || !this.didAnythingLastIteration) {
            this.disregardPile.refill();
            this.newAllocations.refill();
        }
        BSlot<T> bSlot = slot = slot == null ? this.live.poll() : slot;
        if (slot != null) {
            if (slot.isDead() || slot.live2dead()) {
                this.dealloc(slot);
                this.unregisterWithLeakDetector(slot);
            } else {
                this.live.offer(slot);
            }
        }
    }

    private void registerWithLeakDetector(BSlot<T> slot) {
        if (this.leakDetector != null) {
            this.leakDetector.register(slot);
        }
    }

    private void unregisterWithLeakDetector(BSlot<T> slot) {
        if (this.leakDetector != null) {
            this.leakDetector.unregister(slot);
        }
    }

    private void reallocateDeadSlot(BSlot<T> slot) {
        this.realloc(slot);
    }

    private void proactivelyHealPoison() {
        BSlot<T> slot = this.live.poll();
        if (slot != null) {
            if (slot.poison != null && (slot.isDead() || slot.live2dead())) {
                this.realloc(slot);
            } else {
                this.live.offer(slot);
            }
        }
    }

    private void backgroundCheck() {
        BSlot<T> slot;
        this.disregardPile.refill();
        if (!this.didAnythingLastIteration) {
            this.newAllocations.refill();
        }
        if ((slot = this.live.poll()) == null) {
            this.newAllocations.refill();
            slot = this.live.poll();
        }
        if (slot != null) {
            if (slot.isLive() && slot.live2claim()) {
                boolean expired;
                try {
                    expired = slot.poison != null || this.expiration.hasExpired(slot) || slot.allocator != this.allocator;
                }
                catch (Exception ignore) {
                    expired = true;
                }
                if (expired) {
                    slot.claim2dead();
                    this.dead.offer(slot);
                    this.didAnythingLastIteration = true;
                } else {
                    slot.claim2live();
                    this.live.offer(slot);
                }
            } else {
                this.live.offer(slot);
            }
        }
    }

    private void shutPoolDown() {
        while (this.size > 0L) {
            BSlot<T> slot = (BSlot<T>)this.dead.poll();
            if (slot == null) {
                slot = this.live.poll();
            }
            if (slot == this.poisonPill) {
                this.live.offer(this.poisonPill);
                slot = null;
            }
            if (slot == null) {
                if (this.disregardPile.refill() || this.newAllocations.refill()) continue;
                LockSupport.parkNanos(shutdownPauseNanos);
                continue;
            }
            if (slot.isDead() || slot.live2dead()) {
                this.dealloc(slot);
                this.unregisterWithLeakDetector(slot);
                continue;
            }
            this.live.offer(slot);
        }
    }

    private void alloc(BSlot<T> slot) {
        boolean success = false;
        try {
            slot.obj = this.allocator.allocate(slot);
            if (slot.obj == null) {
                this.poisonedSlots.getAndIncrement();
                slot.poison = new NullPointerException("Allocation returned null.");
            } else {
                success = true;
            }
        }
        catch (Exception e) {
            this.poisonedSlots.getAndIncrement();
            slot.poison = e;
        }
        ++this.size;
        this.publishSlot(slot, success, NanoClock.nanoTime());
        this.didAnythingLastIteration = true;
    }

    private void publishSlot(BSlot<T> slot, boolean success, long now) {
        this.resetSlot(slot, now);
        if (success && !this.live.hasWaitingConsumer()) {
            this.newAllocations.push(slot);
        } else {
            this.live.offer(slot);
        }
        this.incrementAllocationCounts(success);
    }

    private void incrementAllocationCounts(boolean success) {
        if (success) {
            ++this.allocationCount;
            this.consecutiveAllocationFailures = 0L;
        } else {
            ++this.failedAllocationCount;
            ++this.consecutiveAllocationFailures;
        }
    }

    private void resetSlot(BSlot<T> slot, long now) {
        slot.createdNanos = now;
        slot.stamp = 0L;
        slot.allocator = this.allocator;
        slot.dead2live();
    }

    private void dealloc(BSlot<T> slot) {
        --this.size;
        try {
            if (slot.poison == BlazePool.EXPLICIT_EXPIRE_POISON) {
                slot.poison = null;
                this.poisonedSlots.getAndDecrement();
            }
            if (slot.poison == null) {
                this.recordObjectLifetimeSample(NanoClock.elapsed(slot.createdNanos));
                slot.allocator.deallocate(slot.obj);
            } else {
                this.poisonedSlots.getAndDecrement();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        slot.poison = null;
        slot.obj = null;
        this.didAnythingLastIteration = true;
        if (slot.allocator != this.allocator) {
            this.replacedPriorGenerationSlot();
        }
    }

    private void realloc(BSlot<T> slot) {
        if (slot.poison == BlazePool.EXPLICIT_EXPIRE_POISON) {
            slot.poison = null;
            this.poisonedSlots.getAndDecrement();
        }
        if (slot.poison == null && this.nextAllocator == null) {
            boolean success = false;
            try {
                slot.obj = this.allocator.reallocate(slot, slot.obj);
                if (slot.obj == null) {
                    this.poisonedSlots.getAndIncrement();
                    slot.poison = new NullPointerException("Reallocation returned null.");
                } else {
                    success = true;
                }
            }
            catch (Exception e) {
                this.poisonedSlots.getAndIncrement();
                slot.poison = e;
            }
            long now = NanoClock.nanoTime();
            this.recordObjectLifetimeSample(now - slot.createdNanos);
            this.publishSlot(slot, success, now);
        } else {
            this.dealloc(slot);
            this.alloc(slot);
        }
        this.didAnythingLastIteration = true;
    }

    private void replacedPriorGenerationSlot() {
        if (--this.priorGenerationObjectsToReplace == 0L) {
            this.nextAllocator.completion().complete();
            this.nextAllocator = null;
        }
    }

    private void recordObjectLifetimeSample(long nanoseconds) {
        if (this.metricsRecorder != null) {
            long milliseconds = TimeUnit.NANOSECONDS.toMillis(nanoseconds);
            this.metricsRecorder.recordObjectLifetimeSampleMillis(milliseconds);
        }
    }

    void setTargetSize(long size) {
        this.targetSize = size;
    }

    long getTargetSize() {
        return this.targetSize;
    }

    Completion shutdown(Thread allocatorThread) {
        this.shutdown = true;
        allocatorThread.interrupt();
        return this.shutdownCompletion;
    }

    Completion switchAllocator(Allocator<T> replacementAllocator) {
        StackCompletion completion = new StackCompletion();
        Reallocator<T> reallocator = ReallocatingAdaptor.adapt(replacementAllocator, this.metricsRecorder);
        AllocatorSwitch<T> switchRequest = new AllocatorSwitch<T>(completion, reallocator);
        if (this.shutdown) {
            AllocatorSwitch<T> entry;
            while ((entry = this.switchRequests.poll()) != null) {
                entry.completion().complete();
            }
        } else {
            this.shutdownCompletion.propagateTo(completion);
            this.switchRequests.offer(switchRequest);
        }
        return completion;
    }

    long getAllocationCount() {
        return this.allocationCount;
    }

    long getFailedAllocationCount() {
        return this.failedAllocationCount;
    }

    long countLeakedObjects() {
        if (this.leakDetector != null) {
            return this.leakDetector.countLeakedObjects();
        }
        return -1L;
    }

    void offerDeadSlot(BSlot<T> slot) {
        this.dead.offer(slot);
    }

    long allocatedSize() {
        return this.size;
    }

    long inUse() {
        long inUse = 0L;
        long liveSize = 0L;
        for (BSlot<T> slot : this.live) {
            ++liveSize;
            if (!slot.isClaimedOrThreadLocal()) continue;
            ++inUse;
        }
        return this.size - liveSize + inUse;
    }
}

