/*
 * Decompiled with CFR 0.152.
 */
package stormpot.internal;

import java.util.concurrent.LinkedTransferQueue;
import stormpot.Poolable;
import stormpot.internal.AllocationController;
import stormpot.internal.AllocationProcessMode;
import stormpot.internal.BSlot;
import stormpot.internal.DirectAllocationController;
import stormpot.internal.InlineAllocationController;
import stormpot.internal.PoolBuilderImpl;
import stormpot.internal.RefillPile;
import stormpot.internal.ThreadedAllocationController;

public abstract class AllocationProcess {
    private final AllocationProcessMode mode;

    public static AllocationProcess threaded() {
        return new AllocationProcess(AllocationProcessMode.THREADED){

            @Override
            <T extends Poolable> AllocationController<T> buildAllocationController(LinkedTransferQueue<BSlot<T>> live, RefillPile<T> disregardPile, RefillPile<T> newAllocations, PoolBuilderImpl<T> builder, BSlot<T> poisonPill) {
                return new ThreadedAllocationController<T>(live, disregardPile, newAllocations, builder, poisonPill);
            }
        };
    }

    public static AllocationProcess inline() {
        return new AllocationProcess(AllocationProcessMode.INLINE){

            @Override
            <T extends Poolable> AllocationController<T> buildAllocationController(LinkedTransferQueue<BSlot<T>> live, RefillPile<T> disregardPile, RefillPile<T> newAllocations, PoolBuilderImpl<T> builder, BSlot<T> poisonPill) {
                return new InlineAllocationController<T>(live, disregardPile, newAllocations, builder, poisonPill);
            }
        };
    }

    public static AllocationProcess direct() {
        return new AllocationProcess(AllocationProcessMode.DIRECT){

            @Override
            <T extends Poolable> AllocationController<T> buildAllocationController(LinkedTransferQueue<BSlot<T>> live, RefillPile<T> disregardPile, RefillPile<T> newAllocations, PoolBuilderImpl<T> builder, BSlot<T> poisonPill) {
                return new DirectAllocationController<T>(live, disregardPile, builder, poisonPill);
            }
        };
    }

    protected AllocationProcess(AllocationProcessMode mode) {
        this.mode = mode;
    }

    public AllocationProcessMode getMode() {
        return this.mode;
    }

    abstract <T extends Poolable> AllocationController<T> buildAllocationController(LinkedTransferQueue<BSlot<T>> var1, RefillPile<T> var2, RefillPile<T> var3, PoolBuilderImpl<T> var4, BSlot<T> var5);
}

