/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.tools.stringifier;

import com.netflix.hollow.api.objects.HollowRecord;
import com.netflix.hollow.api.objects.generic.GenericHollowObject;
import com.netflix.hollow.core.read.dataaccess.HollowDataAccess;
import com.netflix.hollow.core.read.dataaccess.HollowListTypeDataAccess;
import com.netflix.hollow.core.read.dataaccess.HollowMapTypeDataAccess;
import com.netflix.hollow.core.read.dataaccess.HollowObjectTypeDataAccess;
import com.netflix.hollow.core.read.dataaccess.HollowSetTypeDataAccess;
import com.netflix.hollow.core.read.dataaccess.HollowTypeDataAccess;
import com.netflix.hollow.core.read.iterator.HollowMapEntryOrdinalIterator;
import com.netflix.hollow.core.read.iterator.HollowOrdinalIterator;
import com.netflix.hollow.core.schema.HollowListSchema;
import com.netflix.hollow.core.schema.HollowMapSchema;
import com.netflix.hollow.core.schema.HollowObjectSchema;
import com.netflix.hollow.core.schema.HollowSetSchema;
import com.netflix.hollow.tools.stringifier.HollowStringifier;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class HollowRecordStringifier
implements HollowStringifier<HollowRecordStringifier> {
    private final Set<String> excludeObjectTypes = new HashSet<String>();
    private final boolean showOrdinals;
    private final boolean showTypes;
    private final boolean collapseSingleFieldObjects;

    public HollowRecordStringifier() {
        this(false, false, true);
    }

    public HollowRecordStringifier(boolean showOrdinals, boolean showTypes, boolean collapseSingleFieldObjects) {
        this.showOrdinals = showOrdinals;
        this.showTypes = showTypes;
        this.collapseSingleFieldObjects = collapseSingleFieldObjects;
    }

    @Override
    public HollowRecordStringifier addExcludeObjectTypes(String ... types) {
        for (String type : types) {
            this.excludeObjectTypes.add(type);
        }
        return this;
    }

    @Override
    public String stringify(HollowRecord record) {
        return this.stringify(record.getTypeDataAccess().getDataAccess(), record.getSchema().getName(), record.getOrdinal());
    }

    @Override
    public void stringify(Writer writer, HollowRecord record) throws IOException {
        this.stringify(writer, record.getTypeDataAccess().getDataAccess(), record.getSchema().getName(), record.getOrdinal());
    }

    @Override
    public void stringify(Writer writer, Iterable<HollowRecord> records) throws IOException {
        writer.write("[");
        Iterator<HollowRecord> iterator = records.iterator();
        while (iterator.hasNext()) {
            this.stringify(writer, iterator.next());
            if (!iterator.hasNext()) continue;
            writer.write(",");
        }
        writer.write("\n]");
    }

    @Override
    public String stringify(HollowDataAccess dataAccess, String type, int ordinal) {
        try {
            StringWriter writer = new StringWriter();
            this.stringify(writer, dataAccess, type, ordinal);
            return writer.toString();
        }
        catch (IOException e) {
            throw new RuntimeException("Unexpected exception using StringWriter", e);
        }
    }

    @Override
    public void stringify(Writer writer, HollowDataAccess dataAccess, String type, int ordinal) throws IOException {
        this.appendStringify(writer, dataAccess, type, ordinal, 0);
    }

    private void appendStringify(Writer writer, HollowDataAccess dataAccess, String type, int ordinal, int indentation) throws IOException {
        if (this.excludeObjectTypes.contains(type)) {
            writer.append("null");
            return;
        }
        HollowTypeDataAccess typeDataAccess = dataAccess.getTypeDataAccess(type);
        if (typeDataAccess == null) {
            writer.append("[missing type " + type + "]");
        } else if (ordinal == -1) {
            writer.append("null");
        } else if (typeDataAccess instanceof HollowObjectTypeDataAccess) {
            this.appendObjectStringify(writer, dataAccess, (HollowObjectTypeDataAccess)typeDataAccess, ordinal, indentation);
        } else if (typeDataAccess instanceof HollowListTypeDataAccess) {
            this.appendListStringify(writer, dataAccess, (HollowListTypeDataAccess)typeDataAccess, ordinal, indentation);
        } else if (typeDataAccess instanceof HollowSetTypeDataAccess) {
            this.appendSetStringify(writer, dataAccess, (HollowSetTypeDataAccess)typeDataAccess, ordinal, indentation);
        } else if (typeDataAccess instanceof HollowMapTypeDataAccess) {
            this.appendMapStringify(writer, dataAccess, (HollowMapTypeDataAccess)typeDataAccess, ordinal, indentation);
        }
    }

    private void appendMapStringify(Writer writer, HollowDataAccess dataAccess, HollowMapTypeDataAccess typeDataAccess, int ordinal, int indentation) throws IOException {
        HollowMapSchema schema = typeDataAccess.getSchema();
        if (this.showTypes) {
            writer.append("(").append(schema.getName()).append(")");
        }
        if (this.showOrdinals) {
            writer.append(" (ordinal ").append(Integer.toString(ordinal)).append(")");
        }
        ++indentation;
        String keyType = schema.getKeyType();
        String valueType = schema.getValueType();
        HollowMapEntryOrdinalIterator iter = typeDataAccess.ordinalIterator(ordinal);
        while (iter.next()) {
            writer.append("\n");
            this.appendIndentation(writer, indentation);
            writer.append("k: ");
            this.appendStringify(writer, dataAccess, keyType, iter.getKey(), indentation);
            writer.append("\n");
            this.appendIndentation(writer, indentation);
            writer.append("v: ");
            this.appendStringify(writer, dataAccess, valueType, iter.getValue(), indentation);
        }
    }

    private void appendSetStringify(Writer writer, HollowDataAccess dataAccess, HollowSetTypeDataAccess typeDataAccess, int ordinal, int indentation) throws IOException {
        HollowSetSchema schema = typeDataAccess.getSchema();
        if (this.showTypes) {
            writer.append("(").append(schema.getName()).append(")");
        }
        if (this.showOrdinals) {
            writer.append(" (ordinal ").append(Integer.toString(ordinal)).append(")");
        }
        ++indentation;
        String elementType = schema.getElementType();
        HollowOrdinalIterator iter = typeDataAccess.ordinalIterator(ordinal);
        int elementOrdinal = iter.next();
        while (elementOrdinal != Integer.MAX_VALUE) {
            writer.append("\n");
            this.appendIndentation(writer, indentation);
            writer.append("e: ");
            this.appendStringify(writer, dataAccess, elementType, elementOrdinal, indentation);
            elementOrdinal = iter.next();
        }
    }

    private void appendListStringify(Writer writer, HollowDataAccess dataAccess, HollowListTypeDataAccess typeDataAccess, int ordinal, int indentation) throws IOException {
        HollowListSchema schema = typeDataAccess.getSchema();
        if (this.showTypes) {
            writer.append("(").append(schema.getName()).append(")");
        }
        if (this.showOrdinals) {
            writer.append(" (ordinal ").append(Integer.toString(ordinal)).append(")");
        }
        ++indentation;
        int size = typeDataAccess.size(ordinal);
        String elementType = schema.getElementType();
        for (int i = 0; i < size; ++i) {
            writer.append("\n");
            int elementOrdinal = typeDataAccess.getElementOrdinal(ordinal, i);
            this.appendIndentation(writer, indentation);
            writer.append("e" + i + ": ");
            this.appendStringify(writer, dataAccess, elementType, elementOrdinal, indentation);
        }
    }

    private void appendObjectStringify(Writer writer, HollowDataAccess dataAccess, HollowObjectTypeDataAccess typeDataAccess, int ordinal, int indentation) throws IOException {
        HollowObjectSchema schema = typeDataAccess.getSchema();
        GenericHollowObject obj = new GenericHollowObject(typeDataAccess, ordinal);
        if (this.collapseSingleFieldObjects && typeDataAccess.getSchema().numFields() == 1) {
            this.appendFieldStringify(writer, dataAccess, indentation, schema, obj, 0, schema.getFieldName(0));
        } else {
            if (this.showTypes) {
                writer.append("(").append(schema.getName()).append(")");
            }
            if (this.showOrdinals) {
                writer.append(" (ordinal ").append(Integer.toString(ordinal)).append(")");
            }
            ++indentation;
            for (int i = 0; i < schema.numFields(); ++i) {
                writer.append("\n");
                String fieldName = schema.getFieldName(i);
                this.appendIndentation(writer, indentation);
                writer.append(fieldName).append(": ");
                this.appendFieldStringify(writer, dataAccess, indentation, schema, obj, i, fieldName);
            }
        }
    }

    private void appendFieldStringify(Writer writer, HollowDataAccess dataAccess, int indentation, HollowObjectSchema schema, GenericHollowObject obj, int i, String fieldName) throws IOException {
        if (obj.isNull(fieldName)) {
            writer.append("null");
        } else {
            switch (schema.getFieldType(i)) {
                case BOOLEAN: {
                    writer.append(Boolean.toString(obj.getBoolean(fieldName)));
                    break;
                }
                case BYTES: {
                    writer.append(Arrays.toString(obj.getBytes(fieldName)));
                    break;
                }
                case DOUBLE: {
                    writer.append(Double.toString(obj.getDouble(fieldName)));
                    break;
                }
                case FLOAT: {
                    writer.append(Float.toString(obj.getFloat(fieldName)));
                    break;
                }
                case INT: {
                    writer.append(Integer.toString(obj.getInt(fieldName)));
                    break;
                }
                case LONG: {
                    writer.append(Long.toString(obj.getLong(fieldName)));
                    break;
                }
                case STRING: {
                    writer.append(obj.getString(fieldName));
                    break;
                }
                case REFERENCE: {
                    int refOrdinal = obj.getOrdinal(fieldName);
                    this.appendStringify(writer, dataAccess, schema.getReferencedType(i), refOrdinal, indentation);
                }
            }
        }
    }

    private void appendIndentation(Writer writer, int indentation) throws IOException {
        for (int i = 0; i < indentation; ++i) {
            writer.append("  ");
        }
    }
}

