/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.tools.stringifier;

import com.netflix.hollow.api.objects.HollowRecord;
import com.netflix.hollow.core.read.dataaccess.HollowDataAccess;
import com.netflix.hollow.core.read.dataaccess.HollowListTypeDataAccess;
import com.netflix.hollow.core.read.dataaccess.HollowMapTypeDataAccess;
import com.netflix.hollow.core.read.dataaccess.HollowObjectTypeDataAccess;
import com.netflix.hollow.core.read.dataaccess.HollowSetTypeDataAccess;
import com.netflix.hollow.core.read.dataaccess.HollowTypeDataAccess;
import com.netflix.hollow.core.read.iterator.HollowMapEntryOrdinalIterator;
import com.netflix.hollow.core.read.iterator.HollowOrdinalIterator;
import com.netflix.hollow.core.schema.HollowListSchema;
import com.netflix.hollow.core.schema.HollowMapSchema;
import com.netflix.hollow.core.schema.HollowObjectSchema;
import com.netflix.hollow.core.schema.HollowSetSchema;
import com.netflix.hollow.tools.stringifier.HollowStringifier;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class HollowRecordJsonStringifier
implements HollowStringifier<HollowRecordJsonStringifier> {
    private final Set<String> collapseObjectTypes;
    private final Set<String> excludeObjectTypes = new HashSet<String>();
    private final boolean collapseAllSingleFieldObjects;
    private final boolean prettyPrint;

    public HollowRecordJsonStringifier() {
        this(true, true);
    }

    public HollowRecordJsonStringifier(boolean prettyPrint, boolean collapseAllSingleFieldObjects) {
        this.prettyPrint = prettyPrint;
        this.collapseAllSingleFieldObjects = collapseAllSingleFieldObjects;
        this.collapseObjectTypes = Collections.emptySet();
    }

    public HollowRecordJsonStringifier(boolean indent, String ... collapseObjectTypes) {
        this.prettyPrint = indent;
        this.collapseAllSingleFieldObjects = false;
        this.collapseObjectTypes = new HashSet<String>();
        for (String collapseObjectType : collapseObjectTypes) {
            this.collapseObjectTypes.add(collapseObjectType);
        }
    }

    @Override
    public HollowRecordJsonStringifier addExcludeObjectTypes(String ... types) {
        for (String type : types) {
            this.excludeObjectTypes.add(type);
        }
        return this;
    }

    @Override
    public String stringify(HollowRecord record) {
        return this.stringify(record.getTypeDataAccess().getDataAccess(), record.getSchema().getName(), record.getOrdinal());
    }

    @Override
    public void stringify(Writer writer, HollowRecord record) throws IOException {
        this.stringify(writer, record.getTypeDataAccess().getDataAccess(), record.getSchema().getName(), record.getOrdinal());
    }

    @Override
    public void stringify(Writer writer, Iterable<HollowRecord> records) throws IOException {
        writer.write("[");
        Iterator<HollowRecord> iterator = records.iterator();
        while (iterator.hasNext()) {
            this.stringify(writer, iterator.next());
            if (!iterator.hasNext()) continue;
            writer.write(",");
        }
        writer.write("]");
    }

    @Override
    public String stringify(HollowDataAccess dataAccess, String type, int ordinal) {
        try {
            StringWriter writer = new StringWriter();
            this.appendStringify(writer, dataAccess, type, ordinal, 0);
            return writer.toString();
        }
        catch (IOException e) {
            throw new RuntimeException("Error using StringWriter", e);
        }
    }

    @Override
    public void stringify(Writer writer, HollowDataAccess dataAccess, String type, int ordinal) throws IOException {
        this.appendStringify(writer, dataAccess, type, ordinal, 0);
    }

    private void appendStringify(Writer writer, HollowDataAccess dataAccess, String type, int ordinal, int indentation) throws IOException {
        if (this.excludeObjectTypes.contains(type)) {
            writer.append("null");
            return;
        }
        HollowTypeDataAccess typeDataAccess = dataAccess.getTypeDataAccess(type);
        if (typeDataAccess == null) {
            writer.append("{ }");
        } else if (ordinal == -1) {
            writer.append("null");
        } else if (typeDataAccess instanceof HollowObjectTypeDataAccess) {
            this.appendObjectStringify(writer, dataAccess, (HollowObjectTypeDataAccess)typeDataAccess, ordinal, indentation);
        } else if (typeDataAccess instanceof HollowListTypeDataAccess) {
            this.appendListStringify(writer, dataAccess, (HollowListTypeDataAccess)typeDataAccess, ordinal, indentation);
        } else if (typeDataAccess instanceof HollowSetTypeDataAccess) {
            this.appendSetStringify(writer, dataAccess, (HollowSetTypeDataAccess)typeDataAccess, ordinal, indentation);
        } else if (typeDataAccess instanceof HollowMapTypeDataAccess) {
            this.appendMapStringify(writer, dataAccess, (HollowMapTypeDataAccess)typeDataAccess, ordinal, indentation);
        }
    }

    private void appendMapStringify(Writer writer, HollowDataAccess dataAccess, HollowMapTypeDataAccess typeDataAccess, int ordinal, int indentation) throws IOException {
        HollowMapSchema schema = typeDataAccess.getSchema();
        ++indentation;
        int size = typeDataAccess.size(ordinal);
        if (size == 0) {
            writer.append("{ }");
        } else {
            String keyType = schema.getKeyType();
            String valueType = schema.getValueType();
            HollowObjectTypeDataAccess keyTypeDataAccess = (HollowObjectTypeDataAccess)dataAccess.getTypeDataAccess(keyType);
            HollowObjectSchema keySchema = keyTypeDataAccess.getSchema();
            HollowMapEntryOrdinalIterator ordinalIterator = typeDataAccess.ordinalIterator(ordinal);
            if (keySchema.numFields() == 1) {
                writer.append("{");
                if (this.prettyPrint) {
                    writer.append("\n");
                }
                boolean firstEntry = true;
                while (ordinalIterator.next()) {
                    boolean needToQuoteKey;
                    if (firstEntry) {
                        firstEntry = false;
                    } else {
                        writer.append(",");
                        if (this.prettyPrint) {
                            writer.append("\n");
                        }
                    }
                    if (this.prettyPrint) {
                        this.appendIndentation(writer, indentation);
                    }
                    boolean bl = needToQuoteKey = keySchema.getFieldType(0) != HollowObjectSchema.FieldType.STRING;
                    if (needToQuoteKey) {
                        writer.append("\"");
                    }
                    int keyOrdinal = ordinalIterator.getKey();
                    this.appendFieldStringify(writer, dataAccess, indentation, keySchema, keyTypeDataAccess, keyOrdinal, 0);
                    if (needToQuoteKey) {
                        writer.append("\"");
                    }
                    writer.append(": ");
                    this.appendStringify(writer, dataAccess, valueType, ordinalIterator.getValue(), indentation);
                }
                if (this.prettyPrint && !firstEntry) {
                    writer.append("\n");
                    this.appendIndentation(writer, indentation - 1);
                }
                writer.append("}");
            } else {
                writer.append("[");
                if (this.prettyPrint) {
                    writer.append("\n");
                }
                boolean firstEntry = true;
                while (ordinalIterator.next()) {
                    if (firstEntry) {
                        firstEntry = false;
                    } else {
                        writer.append(",");
                        if (this.prettyPrint) {
                            writer.append("\n");
                        }
                    }
                    if (this.prettyPrint) {
                        this.appendIndentation(writer, indentation - 1);
                    }
                    writer.append("{");
                    if (this.prettyPrint) {
                        writer.append("\n");
                        this.appendIndentation(writer, indentation);
                    }
                    writer.append("\"key\":");
                    this.appendStringify(writer, dataAccess, keyType, ordinalIterator.getKey(), indentation + 1);
                    writer.append(",");
                    if (this.prettyPrint) {
                        writer.append("\n");
                        this.appendIndentation(writer, indentation);
                    }
                    writer.append("\"value\":");
                    this.appendStringify(writer, dataAccess, valueType, ordinalIterator.getValue(), indentation + 1);
                    if (this.prettyPrint) {
                        writer.append("\n");
                        this.appendIndentation(writer, indentation - 1);
                    }
                    writer.append("}");
                }
                writer.append("]");
            }
        }
    }

    private void appendSetStringify(Writer writer, HollowDataAccess dataAccess, HollowSetTypeDataAccess typeDataAccess, int ordinal, int indentation) throws IOException {
        HollowSetSchema schema = typeDataAccess.getSchema();
        ++indentation;
        String elementType = schema.getElementType();
        HollowOrdinalIterator iter = typeDataAccess.ordinalIterator(ordinal);
        int elementOrdinal = iter.next();
        if (elementOrdinal == Integer.MAX_VALUE) {
            writer.append("[]");
        } else {
            boolean firstElement = true;
            writer.append("[");
            if (this.prettyPrint) {
                writer.append("\n");
            }
            while (elementOrdinal != Integer.MAX_VALUE) {
                if (firstElement) {
                    firstElement = false;
                } else {
                    writer.append(",");
                }
                if (this.prettyPrint) {
                    this.appendIndentation(writer, indentation);
                }
                this.appendStringify(writer, dataAccess, elementType, elementOrdinal, indentation);
                elementOrdinal = iter.next();
            }
            if (this.prettyPrint) {
                writer.append("\n");
                this.appendIndentation(writer, indentation - 1);
            }
            writer.append("]");
        }
    }

    private void appendListStringify(Writer writer, HollowDataAccess dataAccess, HollowListTypeDataAccess typeDataAccess, int ordinal, int indentation) throws IOException {
        HollowListSchema schema = typeDataAccess.getSchema();
        ++indentation;
        int size = typeDataAccess.size(ordinal);
        if (size == 0) {
            writer.append("[]");
        } else {
            writer.append("[");
            if (this.prettyPrint) {
                writer.append("\n");
            }
            String elementType = schema.getElementType();
            for (int i = 0; i < size; ++i) {
                int elementOrdinal = typeDataAccess.getElementOrdinal(ordinal, i);
                if (this.prettyPrint) {
                    this.appendIndentation(writer, indentation);
                }
                this.appendStringify(writer, dataAccess, elementType, elementOrdinal, indentation);
                if (i >= size - 1) continue;
                writer.append(",");
                if (!this.prettyPrint) continue;
                writer.append("\n");
            }
            if (this.prettyPrint) {
                writer.append("\n");
                this.appendIndentation(writer, indentation - 1);
            }
            writer.append("]");
        }
    }

    private void appendObjectStringify(Writer writer, HollowDataAccess dataAccess, HollowObjectTypeDataAccess typeDataAccess, int ordinal, int indentation) throws IOException {
        HollowObjectSchema schema = typeDataAccess.getSchema();
        if (schema.numFields() == 1 && (this.collapseAllSingleFieldObjects || this.collapseObjectTypes.contains(schema.getName()))) {
            this.appendFieldStringify(writer, dataAccess, indentation, schema, typeDataAccess, ordinal, 0);
        } else {
            writer.append("{");
            boolean firstField = true;
            ++indentation;
            for (int i = 0; i < schema.numFields(); ++i) {
                String fieldName = schema.getFieldName(i);
                if (typeDataAccess.isNull(ordinal, i)) continue;
                if (firstField) {
                    firstField = false;
                } else {
                    writer.append(",");
                }
                if (this.prettyPrint) {
                    writer.append("\n");
                    this.appendIndentation(writer, indentation);
                }
                writer.append("\"").append(fieldName).append("\": ");
                this.appendFieldStringify(writer, dataAccess, indentation, schema, typeDataAccess, ordinal, i);
            }
            if (this.prettyPrint && !firstField) {
                writer.append("\n");
                this.appendIndentation(writer, indentation - 1);
            }
            writer.append("}");
        }
    }

    private void appendFieldStringify(Writer writer, HollowDataAccess dataAccess, int indentation, HollowObjectSchema schema, HollowObjectTypeDataAccess typeDataAccess, int ordinal, int fieldIdx) throws IOException {
        switch (schema.getFieldType(fieldIdx)) {
            case BOOLEAN: {
                writer.append(typeDataAccess.readBoolean(ordinal, fieldIdx) != false ? "true" : "false");
                return;
            }
            case BYTES: {
                writer.append(Arrays.toString(typeDataAccess.readBytes(ordinal, fieldIdx)));
                return;
            }
            case DOUBLE: {
                writer.append(String.valueOf(typeDataAccess.readDouble(ordinal, fieldIdx)));
                return;
            }
            case FLOAT: {
                writer.append(String.valueOf(typeDataAccess.readFloat(ordinal, fieldIdx)));
                return;
            }
            case INT: {
                writer.append(String.valueOf(typeDataAccess.readInt(ordinal, fieldIdx)));
                return;
            }
            case LONG: {
                writer.append(String.valueOf(typeDataAccess.readLong(ordinal, fieldIdx)));
                return;
            }
            case STRING: {
                writer.append("\"").append(this.escapeString(typeDataAccess.readString(ordinal, fieldIdx))).append("\"");
                return;
            }
            case REFERENCE: {
                int refOrdinal = typeDataAccess.readOrdinal(ordinal, fieldIdx);
                this.appendStringify(writer, dataAccess, schema.getReferencedType(fieldIdx), refOrdinal, indentation);
                return;
            }
        }
    }

    private String escapeString(String str) {
        if (str.indexOf(92) == -1 && str.indexOf(34) == -1) {
            return str;
        }
        return str.replace("\\", "\\\\").replace("\"", "\\\"");
    }

    private void appendIndentation(Writer writer, int indentation) throws IOException {
        switch (indentation) {
            case 0: {
                return;
            }
            case 1: {
                writer.append("  ");
                return;
            }
            case 2: {
                writer.append("    ");
                return;
            }
            case 3: {
                writer.append("      ");
                return;
            }
            case 4: {
                writer.append("        ");
                return;
            }
            case 5: {
                writer.append("          ");
                return;
            }
            case 6: {
                writer.append("            ");
                return;
            }
            case 7: {
                writer.append("              ");
                return;
            }
            case 8: {
                writer.append("                ");
                return;
            }
            case 9: {
                writer.append("                  ");
                return;
            }
        }
        for (int i = 0; i < indentation; ++i) {
            writer.append("  ");
        }
    }
}

