/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.tools.split;

import com.netflix.hollow.core.read.engine.HollowReadStateEngine;
import com.netflix.hollow.core.read.engine.HollowTypeReadState;
import com.netflix.hollow.core.read.engine.PopulatedOrdinalListener;
import com.netflix.hollow.core.read.engine.map.HollowMapTypeReadState;
import com.netflix.hollow.core.read.engine.set.HollowSetTypeReadState;
import com.netflix.hollow.core.schema.HollowMapSchema;
import com.netflix.hollow.core.schema.HollowSetSchema;
import com.netflix.hollow.core.write.HollowWriteRecord;
import com.netflix.hollow.core.write.HollowWriteStateEngine;
import com.netflix.hollow.core.write.copy.HollowRecordCopier;
import com.netflix.hollow.tools.combine.OrdinalRemapper;
import com.netflix.hollow.tools.split.HollowSplitterCopyDirector;
import com.netflix.hollow.tools.split.HollowSplitterOrdinalRemapper;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;

public class HollowSplitterShardCopier {
    private final Logger log = Logger.getLogger(HollowSplitterShardCopier.class.getName());
    private final HollowReadStateEngine input;
    private final HollowWriteStateEngine output;
    private final OrdinalRemapper ordinalRemapper;
    private final HollowSplitterCopyDirector director;
    private final int shardNumber;
    private final Map<String, HollowRecordCopier> copiersPerType;

    public HollowSplitterShardCopier(HollowReadStateEngine input, HollowWriteStateEngine shardOutput, HollowSplitterCopyDirector director, int shardNumber) {
        this.input = input;
        this.output = shardOutput;
        this.director = director;
        this.shardNumber = shardNumber;
        this.ordinalRemapper = new HollowSplitterOrdinalRemapper(input, this);
        this.copiersPerType = new HashMap<String, HollowRecordCopier>();
    }

    public void copy() {
        for (String topLevelType : this.director.getTopLevelTypes()) {
            HollowTypeReadState inputTypeState = this.input.getTypeState(topLevelType);
            if (inputTypeState == null) {
                this.log.warning("Could not find input type state for " + topLevelType);
                continue;
            }
            PopulatedOrdinalListener listener = inputTypeState.getListener(PopulatedOrdinalListener.class);
            BitSet ordinals = listener.getPopulatedOrdinals();
            int ordinal = ordinals.nextSetBit(0);
            while (ordinal != -1) {
                int directedShard = this.director.getShard(inputTypeState, ordinal);
                if (directedShard == this.shardNumber || directedShard < 0) {
                    this.copyRecord(topLevelType, ordinal);
                }
                ordinal = ordinals.nextSetBit(ordinal + 1);
            }
        }
    }

    int copyRecord(String typeName, int ordinal) {
        HollowTypeReadState typeState = this.input.getTypeState(typeName);
        HollowRecordCopier copier = this.copiersPerType.get(typeName);
        if (copier == null) {
            copier = HollowRecordCopier.createCopier(typeState, this.ordinalRemapper, this.isDefinedHashCode(typeState));
            this.copiersPerType.put(typeName, copier);
        }
        HollowWriteRecord rec = copier.copy(ordinal);
        return this.output.add(typeName, rec);
    }

    private boolean isDefinedHashCode(HollowTypeReadState typeState) {
        if (typeState instanceof HollowSetTypeReadState) {
            return this.input.getTypesWithDefinedHashCodes().contains(((HollowSetSchema)typeState.getSchema()).getElementType());
        }
        if (typeState instanceof HollowMapTypeReadState) {
            return this.input.getTypesWithDefinedHashCodes().contains(((HollowMapSchema)typeState.getSchema()).getKeyType());
        }
        return false;
    }
}

