/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.tools.history.keyindex;

import com.netflix.hollow.core.HollowDataset;
import com.netflix.hollow.core.index.key.PrimaryKey;
import com.netflix.hollow.core.read.engine.HollowReadStateEngine;
import com.netflix.hollow.core.read.engine.object.HollowObjectTypeReadState;
import com.netflix.hollow.core.util.SimultaneousExecutor;
import com.netflix.hollow.tools.history.HollowHistory;
import com.netflix.hollow.tools.history.keyindex.HollowHistoryTypeKeyIndex;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;

public class HollowHistoryKeyIndex {
    private final HollowHistory history;
    private final Map<String, HollowHistoryTypeKeyIndex> typeKeyIndexes;
    private boolean isInitialized;

    public HollowHistoryKeyIndex(HollowHistory history) {
        this.history = history;
        this.typeKeyIndexes = new HashMap<String, HollowHistoryTypeKeyIndex>();
    }

    public int numUniqueKeys(String type) {
        return this.typeKeyIndexes.get(type).getMaxIndexedOrdinal();
    }

    public String getKeyDisplayString(String type, int keyOrdinal) {
        return this.typeKeyIndexes.get(type).getKeyDisplayString(keyOrdinal);
    }

    public int getRecordKeyOrdinal(HollowObjectTypeReadState typeState, int ordinal) {
        return this.typeKeyIndexes.get(typeState.getSchema().getName()).findKeyIndexOrdinal(typeState, ordinal);
    }

    public void addTypeIndex(String type, String ... keyFieldPaths) {
        this.addTypeIndex(new PrimaryKey(type, keyFieldPaths));
    }

    public void addTypeIndex(PrimaryKey primaryKey) {
        this.addTypeIndex(primaryKey, this.history.getLatestState());
    }

    public HollowHistoryTypeKeyIndex addTypeIndex(PrimaryKey primaryKey, HollowDataset dataModel) {
        HollowHistoryTypeKeyIndex prevKeyIdx = this.typeKeyIndexes.get(primaryKey.getType());
        HollowHistoryTypeKeyIndex keyIdx = new HollowHistoryTypeKeyIndex(primaryKey, dataModel);
        if (prevKeyIdx != null) {
            for (int i = 0; i < prevKeyIdx.getKeyFields().length; ++i) {
                if (!prevKeyIdx.getKeyFieldIsIndexed()[i]) continue;
                keyIdx.addFieldIndex(prevKeyIdx.getKeyFields()[i], dataModel);
            }
        }
        this.typeKeyIndexes.put(primaryKey.getType(), keyIdx);
        return keyIdx;
    }

    public void indexTypeField(String type, String keyFieldPath) {
        this.typeKeyIndexes.get(type).addFieldIndex(keyFieldPath, this.history.getLatestState());
    }

    public void indexTypeField(PrimaryKey primaryKey) {
        this.indexTypeField(primaryKey, this.history.getLatestState());
    }

    public void indexTypeField(PrimaryKey primaryKey, HollowDataset dataModel) {
        String type = primaryKey.getType();
        HollowHistoryTypeKeyIndex typeIndex = this.typeKeyIndexes.get(type);
        if (typeIndex == null) {
            typeIndex = this.addTypeIndex(primaryKey, dataModel);
        }
        for (String fieldPath : primaryKey.getFieldPaths()) {
            typeIndex.addFieldIndex(fieldPath, dataModel);
        }
    }

    public Map<String, HollowHistoryTypeKeyIndex> getTypeKeyIndexes() {
        return this.typeKeyIndexes;
    }

    public void update(HollowReadStateEngine latestStateEngine, boolean isDelta) {
        boolean isInitialUpdate = !this.isInitialized();
        this.initializeTypeIndexes(latestStateEngine);
        this.updateTypeIndexes(latestStateEngine, isDelta && !isInitialUpdate);
        this.isInitialized = true;
    }

    public boolean isInitialized() {
        return this.isInitialized;
    }

    private void initializeTypeIndexes(HollowReadStateEngine latestStateEngine) {
        for (Map.Entry<String, HollowHistoryTypeKeyIndex> entry : this.typeKeyIndexes.entrySet()) {
            HollowObjectTypeReadState typeState;
            String type = entry.getKey();
            HollowHistoryTypeKeyIndex index = entry.getValue();
            if (index.isInitialized() || (typeState = (HollowObjectTypeReadState)latestStateEngine.getTypeState(type)) == null) continue;
            index.initializeKeySchema(typeState);
        }
    }

    private void updateTypeIndexes(HollowReadStateEngine latestStateEngine, boolean isDelta) {
        SimultaneousExecutor executor = new SimultaneousExecutor(this.getClass(), "update-type-indexes");
        for (Map.Entry<String, HollowHistoryTypeKeyIndex> entry : this.typeKeyIndexes.entrySet()) {
            executor.execute(() -> {
                HollowObjectTypeReadState typeState = (HollowObjectTypeReadState)latestStateEngine.getTypeState((String)entry.getKey());
                ((HollowHistoryTypeKeyIndex)entry.getValue()).update(typeState, isDelta);
            });
        }
        try {
            executor.awaitSuccessfulCompletion();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
    }
}

