/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.tools.history.keyindex;

import com.netflix.hollow.core.read.engine.HollowTypeReadState;
import com.netflix.hollow.core.read.engine.object.HollowObjectTypeReadState;
import com.netflix.hollow.core.util.IntMap;
import com.netflix.hollow.tools.combine.OrdinalRemapper;
import com.netflix.hollow.tools.history.keyindex.HollowHistoryTypeKeyIndex;

public class HollowHistoricalStateTypeKeyOrdinalMapping {
    private final String typeName;
    private final HollowHistoryTypeKeyIndex keyIndex;
    private IntMap addedOrdinalMap;
    private IntMap removedOrdinalMap;
    private int numberOfNewRecords;
    private int numberOfRemovedRecords;
    private int numberOfModifiedRecords;

    public HollowHistoricalStateTypeKeyOrdinalMapping(String typeName, HollowHistoryTypeKeyIndex keyIndex) {
        this.typeName = typeName;
        this.keyIndex = keyIndex;
    }

    private HollowHistoricalStateTypeKeyOrdinalMapping(String typeName, HollowHistoryTypeKeyIndex keyIndex, IntMap addedOrdinalMap, IntMap removedOrdinalMap) {
        this.typeName = typeName;
        this.keyIndex = keyIndex;
        this.addedOrdinalMap = addedOrdinalMap;
        this.removedOrdinalMap = removedOrdinalMap;
        this.finish();
    }

    public void prepare(int numAdditions, int numRemovals) {
        this.addedOrdinalMap = new IntMap(numAdditions);
        this.removedOrdinalMap = new IntMap(numRemovals);
    }

    public void added(HollowTypeReadState typeState, int ordinal) {
        int recordKeyOrdinal = this.keyIndex.findKeyIndexOrdinal((HollowObjectTypeReadState)typeState, ordinal);
        this.addedOrdinalMap.put(recordKeyOrdinal, ordinal);
    }

    public void removed(HollowTypeReadState typeState, int ordinal) {
        this.removed(typeState, ordinal, ordinal);
    }

    public void removed(HollowTypeReadState typeState, int stateEngineOrdinal, int mappedOrdinal) {
        int recordKeyOrdinal = this.keyIndex.findKeyIndexOrdinal((HollowObjectTypeReadState)typeState, stateEngineOrdinal);
        this.removedOrdinalMap.put(recordKeyOrdinal, mappedOrdinal);
    }

    public HollowHistoricalStateTypeKeyOrdinalMapping remap(OrdinalRemapper remapper) {
        IntMap newAddedOrdinalMap = new IntMap(this.addedOrdinalMap.size());
        IntMap.IntMapEntryIterator addedIter = this.addedOrdinalMap.iterator();
        while (addedIter.next()) {
            newAddedOrdinalMap.put(addedIter.getKey(), remapper.getMappedOrdinal(this.typeName, addedIter.getValue()));
        }
        IntMap newRemovedOrdinalMap = new IntMap(this.removedOrdinalMap.size());
        IntMap.IntMapEntryIterator removedIter = this.removedOrdinalMap.iterator();
        while (removedIter.next()) {
            newRemovedOrdinalMap.put(removedIter.getKey(), remapper.getMappedOrdinal(this.typeName, removedIter.getValue()));
        }
        return new HollowHistoricalStateTypeKeyOrdinalMapping(this.typeName, this.keyIndex, newAddedOrdinalMap, newRemovedOrdinalMap);
    }

    public void finish() {
        IntMap.IntMapEntryIterator iter = this.addedOrdinalMap.iterator();
        while (iter.next()) {
            if (this.removedOrdinalMap.get(iter.getKey()) == -1) continue;
            ++this.numberOfModifiedRecords;
        }
        this.numberOfNewRecords = this.addedOrdinalMap.size() - this.numberOfModifiedRecords;
        this.numberOfRemovedRecords = this.removedOrdinalMap.size() - this.numberOfModifiedRecords;
    }

    public IntMap.IntMapEntryIterator removedOrdinalMappingIterator() {
        return this.removedOrdinalMap.iterator();
    }

    public IntMap.IntMapEntryIterator addedOrdinalMappingIterator() {
        return this.addedOrdinalMap.iterator();
    }

    public int findRemovedOrdinal(int keyOrdinal) {
        return this.removedOrdinalMap.get(keyOrdinal);
    }

    public int findAddedOrdinal(int keyOrdinal) {
        return this.addedOrdinalMap.get(keyOrdinal);
    }

    public HollowHistoryTypeKeyIndex getKeyIndex() {
        return this.keyIndex;
    }

    public int getNumberOfNewRecords() {
        return this.numberOfNewRecords;
    }

    public int getNumberOfRemovedRecords() {
        return this.numberOfRemovedRecords;
    }

    public int getNumberOfModifiedRecords() {
        return this.numberOfModifiedRecords;
    }
}

