/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.tools.history;

import com.netflix.hollow.core.util.IntMap;
import com.netflix.hollow.tools.combine.OrdinalRemapper;
import com.netflix.hollow.tools.diff.exact.DiffEqualityMapping;
import java.util.HashMap;

public class DiffEqualityMappingOrdinalRemapper
implements OrdinalRemapper {
    private final HashMap<String, IntMap> unmatchedOrdinalRemapping;
    private final DiffEqualityMapping equalityMapping;

    DiffEqualityMappingOrdinalRemapper(DiffEqualityMapping mapping) {
        this.equalityMapping = mapping;
        this.unmatchedOrdinalRemapping = new HashMap();
    }

    @Override
    public int getMappedOrdinal(String type, int originalOrdinal) {
        int remappedOrdinal;
        IntMap remapping = this.unmatchedOrdinalRemapping.get(type);
        if (remapping != null && (remappedOrdinal = remapping.get(originalOrdinal)) != -1) {
            return remappedOrdinal;
        }
        int matchedOrdinal = this.equalityMapping.getEqualOrdinalMap(type).getIdentityFromOrdinal(originalOrdinal);
        return matchedOrdinal == -1 ? originalOrdinal : matchedOrdinal;
    }

    public void hintUnmatchedOrdinalCount(String type, int numOrdinals) {
        this.unmatchedOrdinalRemapping.put(type, new IntMap(numOrdinals));
    }

    @Override
    public void remapOrdinal(String type, int originalOrdinal, int mappedOrdinal) {
        IntMap remap = this.unmatchedOrdinalRemapping.get(type);
        if (remap == null) {
            throw new IllegalStateException("Must call hintUnmatchedOrdinalCount for type " + type + " before attempting to remap unmatched ordinals");
        }
        remap.put(originalOrdinal, mappedOrdinal);
    }

    @Override
    public boolean ordinalIsMapped(String type, int originalOrdinal) {
        throw new UnsupportedOperationException();
    }

    public DiffEqualityMapping getDiffEqualityMapping() {
        return this.equalityMapping;
    }

    public IntMap getUnmatchedOrdinalMapping(String type) {
        return this.unmatchedOrdinalRemapping.get(type);
    }
}

