/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.tools.diff.exact.mapper;

import com.netflix.hollow.core.memory.encoding.HashCodes;
import com.netflix.hollow.core.read.HollowReadFieldUtils;
import com.netflix.hollow.core.read.engine.object.HollowObjectTypeReadState;
import com.netflix.hollow.core.schema.HollowObjectSchema;
import com.netflix.hollow.tools.diff.exact.DiffEqualOrdinalMap;
import com.netflix.hollow.tools.diff.exact.DiffEqualityMapping;
import com.netflix.hollow.tools.diff.exact.mapper.DiffEqualityTypeMapper;

public class DiffEqualityObjectMapper
extends DiffEqualityTypeMapper {
    private final HollowObjectSchema commonSchema;
    private final int[] toSchemaCommonFieldMapping;
    private final int[] fromSchemaCommonFieldMapping;
    private final boolean requiresTraversalForMissingFields;
    private final DiffEqualOrdinalMap[] commonReferenceFieldEqualOrdinalMaps;

    public DiffEqualityObjectMapper(DiffEqualityMapping mapping, HollowObjectTypeReadState fromState, HollowObjectTypeReadState toState, boolean oneToOne) {
        super(fromState, toState, oneToOne);
        this.commonSchema = fromState.getSchema().findCommonSchema(toState.getSchema());
        this.commonReferenceFieldEqualOrdinalMaps = new DiffEqualOrdinalMap[this.commonSchema.numFields()];
        for (int i = 0; i < this.commonReferenceFieldEqualOrdinalMaps.length; ++i) {
            if (this.commonSchema.getFieldType(i) != HollowObjectSchema.FieldType.REFERENCE) continue;
            this.commonReferenceFieldEqualOrdinalMaps[i] = mapping.getEqualOrdinalMap(this.commonSchema.getReferencedType(i));
        }
        this.fromSchemaCommonFieldMapping = this.buildCommonSchemaFieldMapping(fromState);
        this.toSchemaCommonFieldMapping = this.buildCommonSchemaFieldMapping(toState);
        boolean requiresTraversalForMissingFields = this.fromState().getSchema().numFields() != this.commonSchema.numFields() || this.toState().getSchema().numFields() != this.commonSchema.numFields();
        for (int i = 0; i < this.commonSchema.numFields(); ++i) {
            if (this.commonSchema.getFieldType(i) != HollowObjectSchema.FieldType.REFERENCE || !mapping.requiresMissingFieldTraversal(this.commonSchema.getReferencedType(i))) continue;
            requiresTraversalForMissingFields = true;
            break;
        }
        this.requiresTraversalForMissingFields = requiresTraversalForMissingFields;
    }

    private int[] buildCommonSchemaFieldMapping(HollowObjectTypeReadState state) {
        int[] commonFieldMapping = new int[this.commonSchema.numFields()];
        for (int i = 0; i < commonFieldMapping.length; ++i) {
            String fieldName = this.commonSchema.getFieldName(i);
            commonFieldMapping[i] = state.getSchema().getPosition(fieldName);
        }
        return commonFieldMapping;
    }

    @Override
    public boolean requiresTraversalForMissingFields() {
        return this.requiresTraversalForMissingFields;
    }

    @Override
    protected int fromRecordHashCode(int ordinal) {
        return this.recordHashCode(this.fromState(), ordinal, this.fromSchemaCommonFieldMapping, true);
    }

    @Override
    protected int toRecordHashCode(int ordinal) {
        return this.recordHashCode(this.toState(), ordinal, this.toSchemaCommonFieldMapping, false);
    }

    private int recordHashCode(HollowObjectTypeReadState typeState, int ordinal, int[] commonSchemaFieldMapping, boolean fromState) {
        int hashCode = 0;
        for (int i = 0; i < commonSchemaFieldMapping.length; ++i) {
            int typeStateFieldIndex = commonSchemaFieldMapping[i];
            if (this.commonSchema.getFieldType(i) == HollowObjectSchema.FieldType.REFERENCE) {
                int ordinalIdentity;
                int referencedOrdinal = typeState.readOrdinal(ordinal, typeStateFieldIndex);
                int n = ordinalIdentity = fromState ? this.commonReferenceFieldEqualOrdinalMaps[i].getIdentityFromOrdinal(referencedOrdinal) : this.commonReferenceFieldEqualOrdinalMaps[i].getIdentityToOrdinal(referencedOrdinal);
                if (ordinalIdentity == -1 && referencedOrdinal != -1) {
                    return -1;
                }
                hashCode = hashCode * 31 ^ HashCodes.hashInt(ordinalIdentity);
                continue;
            }
            hashCode = hashCode * 31 ^ HashCodes.hashInt(HollowReadFieldUtils.fieldHashCode(typeState, ordinal, typeStateFieldIndex));
        }
        return hashCode;
    }

    @Override
    public DiffEqualityTypeMapper.EqualityDeterminer getEqualityDeterminer() {
        return new DiffEqualityTypeMapper.EqualityDeterminer(){

            @Override
            public boolean recordsAreEqual(int fromOrdinal, int toOrdinal) {
                for (int i = 0; i < DiffEqualityObjectMapper.this.fromSchemaCommonFieldMapping.length; ++i) {
                    if (DiffEqualityObjectMapper.this.commonSchema.getFieldType(i) == HollowObjectSchema.FieldType.REFERENCE) {
                        int fromReferenceOrdinal = DiffEqualityObjectMapper.this.fromState().readOrdinal(fromOrdinal, DiffEqualityObjectMapper.this.fromSchemaCommonFieldMapping[i]);
                        int toReferenceOrdinal = DiffEqualityObjectMapper.this.toState().readOrdinal(toOrdinal, DiffEqualityObjectMapper.this.toSchemaCommonFieldMapping[i]);
                        int fromIdentityOrdinal = DiffEqualityObjectMapper.this.commonReferenceFieldEqualOrdinalMaps[i].getIdentityFromOrdinal(fromReferenceOrdinal);
                        int toIdentityOrdinal = DiffEqualityObjectMapper.this.commonReferenceFieldEqualOrdinalMaps[i].getIdentityToOrdinal(toReferenceOrdinal);
                        if (!(fromIdentityOrdinal == -1 && fromReferenceOrdinal != -1 || toIdentityOrdinal == -1 && toReferenceOrdinal != -1) && fromIdentityOrdinal == toIdentityOrdinal) continue;
                        return false;
                    }
                    if (HollowReadFieldUtils.fieldsAreEqual(DiffEqualityObjectMapper.this.fromState(), fromOrdinal, DiffEqualityObjectMapper.this.fromSchemaCommonFieldMapping[i], DiffEqualityObjectMapper.this.toState(), toOrdinal, DiffEqualityObjectMapper.this.toSchemaCommonFieldMapping[i])) continue;
                    return false;
                }
                return true;
            }
        };
    }

    private HollowObjectTypeReadState fromState() {
        return (HollowObjectTypeReadState)this.fromState;
    }

    private HollowObjectTypeReadState toState() {
        return (HollowObjectTypeReadState)this.toState;
    }
}

