/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.tools.diff.exact.mapper;

import com.netflix.hollow.core.memory.encoding.HashCodes;
import com.netflix.hollow.core.read.engine.HollowCollectionTypeReadState;
import com.netflix.hollow.core.read.iterator.HollowOrdinalIterator;
import com.netflix.hollow.core.schema.HollowCollectionSchema;
import com.netflix.hollow.core.util.IntList;
import com.netflix.hollow.tools.diff.exact.DiffEqualOrdinalMap;
import com.netflix.hollow.tools.diff.exact.DiffEqualityMapping;
import com.netflix.hollow.tools.diff.exact.mapper.DiffEqualityTypeMapper;

public class DiffEqualityCollectionMapper
extends DiffEqualityTypeMapper {
    private final boolean requiresTraversalForMissingFields;
    private final DiffEqualOrdinalMap referencedTypeEqualOrdinalMap;
    private final boolean orderingIsImportant;

    public DiffEqualityCollectionMapper(DiffEqualityMapping mapping, HollowCollectionTypeReadState fromState, HollowCollectionTypeReadState toState, boolean oneToOne) {
        this(mapping, fromState, toState, oneToOne, false);
    }

    public DiffEqualityCollectionMapper(DiffEqualityMapping mapping, HollowCollectionTypeReadState fromState, HollowCollectionTypeReadState toState, boolean oneToOne, boolean orderingIsImportant) {
        super(fromState, toState, oneToOne);
        HollowCollectionSchema schema = fromState.getSchema();
        this.referencedTypeEqualOrdinalMap = mapping.getEqualOrdinalMap(schema.getElementType());
        this.requiresTraversalForMissingFields = mapping.requiresMissingFieldTraversal(schema.getElementType());
        this.orderingIsImportant = orderingIsImportant;
    }

    @Override
    public boolean requiresTraversalForMissingFields() {
        return this.requiresTraversalForMissingFields;
    }

    @Override
    protected DiffEqualityTypeMapper.EqualityDeterminer getEqualityDeterminer() {
        return new DiffEqualityTypeMapper.EqualityDeterminer(){
            private final IntList fromIntList = new IntList();
            private final IntList toIntList = new IntList();

            @Override
            public boolean recordsAreEqual(int fromOrdinal, int toOrdinal) {
                if (!this.populateIntList(this.fromIntList, DiffEqualityCollectionMapper.this.fromState().ordinalIterator(fromOrdinal), DiffEqualityCollectionMapper.this.referencedTypeEqualOrdinalMap.getFromOrdinalIdentityTranslator())) {
                    return false;
                }
                if (!this.populateIntList(this.toIntList, DiffEqualityCollectionMapper.this.toState().ordinalIterator(toOrdinal), DiffEqualityCollectionMapper.this.referencedTypeEqualOrdinalMap.getToOrdinalIdentityTranslator())) {
                    return false;
                }
                return this.fromIntList.equals(this.toIntList);
            }

            private boolean populateIntList(IntList list, HollowOrdinalIterator iter, DiffEqualOrdinalMap.OrdinalIdentityTranslator identityTranslator) {
                list.clear();
                int nextOrdinal = iter.next();
                while (nextOrdinal != Integer.MAX_VALUE) {
                    int identityOrdinal = identityTranslator.getIdentityOrdinal(nextOrdinal);
                    if (identityOrdinal == -1 && nextOrdinal != -1) {
                        return false;
                    }
                    list.add(identityOrdinal);
                    nextOrdinal = iter.next();
                }
                if (!DiffEqualityCollectionMapper.this.orderingIsImportant) {
                    list.sort();
                }
                return true;
            }
        };
    }

    @Override
    protected int fromRecordHashCode(int ordinal) {
        return this.recordHashCode(this.fromState(), ordinal, this.referencedTypeEqualOrdinalMap.getFromOrdinalIdentityTranslator());
    }

    @Override
    protected int toRecordHashCode(int ordinal) {
        return this.recordHashCode(this.toState(), ordinal, this.referencedTypeEqualOrdinalMap.getToOrdinalIdentityTranslator());
    }

    protected int recordHashCode(HollowCollectionTypeReadState typeState, int ordinal, DiffEqualOrdinalMap.OrdinalIdentityTranslator identityTranslator) {
        HollowOrdinalIterator iter = typeState.ordinalIterator(ordinal);
        int elementOrdinal = iter.next();
        int hashCode = 0;
        while (elementOrdinal != Integer.MAX_VALUE) {
            int identityElementOrdinal = identityTranslator.getIdentityOrdinal(elementOrdinal);
            if (identityElementOrdinal == -1 && elementOrdinal != -1) {
                return -1;
            }
            if ((hashCode ^= HashCodes.hashInt(identityElementOrdinal)) == 0) {
                hashCode ^= HashCodes.hashInt(identityElementOrdinal);
            }
            elementOrdinal = iter.next();
        }
        return hashCode;
    }

    private HollowCollectionTypeReadState fromState() {
        return (HollowCollectionTypeReadState)this.fromState;
    }

    private HollowCollectionTypeReadState toState() {
        return (HollowCollectionTypeReadState)this.toState;
    }
}

