/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.tools.diff.exact;

import com.netflix.hollow.core.memory.encoding.HashCodes;
import com.netflix.hollow.core.util.IntList;
import java.util.Arrays;

public class DiffEqualOrdinalMap {
    public static final DiffEqualOrdinalMap EMPTY_MAP = new DiffEqualOrdinalMap(0);
    private final long[] fromOrdinalsMap;
    private final IntList pivotedToOrdinalClusters;
    private final long[] toOrdinalsIdentityMap;
    private final OrdinalIdentityTranslator fromIdentityTranslator = new OrdinalIdentityTranslator(){

        @Override
        public int getIdentityOrdinal(int ordinal) {
            return DiffEqualOrdinalMap.this.getIdentityFromOrdinal(ordinal);
        }
    };
    private final OrdinalIdentityTranslator toIdentityTranslator = new OrdinalIdentityTranslator(){

        @Override
        public int getIdentityOrdinal(int ordinal) {
            return DiffEqualOrdinalMap.this.getIdentityToOrdinal(ordinal);
        }
    };

    public DiffEqualOrdinalMap(int numMatches) {
        int hashTableSize = 1 << 32 - Integer.numberOfLeadingZeros(numMatches * 2 - 1);
        this.fromOrdinalsMap = new long[hashTableSize];
        this.toOrdinalsIdentityMap = new long[hashTableSize];
        this.pivotedToOrdinalClusters = new IntList();
        Arrays.fill(this.fromOrdinalsMap, -1L);
        Arrays.fill(this.toOrdinalsIdentityMap, -1L);
    }

    public void putEqualOrdinal(int fromOrdinal, int toOrdinal) {
        long fromOrdinalMapEntry = (long)toOrdinal << 32 | (long)fromOrdinal;
        int hashCode = HashCodes.hashInt(fromOrdinal);
        int bucket = hashCode & this.fromOrdinalsMap.length - 1;
        while (this.fromOrdinalsMap[bucket] != -1L) {
            bucket = bucket + 1 & this.fromOrdinalsMap.length - 1;
        }
        this.fromOrdinalsMap[bucket] = fromOrdinalMapEntry;
    }

    public void putEqualOrdinals(int fromOrdinal, IntList toOrdinals) {
        long fromOrdinalMapEntry = (long)toOrdinals.get(0) << 32 | (long)fromOrdinal;
        if (toOrdinals.size() > 1) {
            fromOrdinalMapEntry = Long.MIN_VALUE | (long)this.pivotedToOrdinalClusters.size() << 32 | (long)fromOrdinal;
            for (int i = 0; i < toOrdinals.size(); ++i) {
                int valueToAdd = toOrdinals.get(i);
                if (i == toOrdinals.size() - 1) {
                    valueToAdd |= Integer.MIN_VALUE;
                }
                this.pivotedToOrdinalClusters.add(valueToAdd);
            }
        }
        int hashCode = HashCodes.hashInt(fromOrdinal);
        int bucket = hashCode & this.fromOrdinalsMap.length - 1;
        while (this.fromOrdinalsMap[bucket] != -1L) {
            bucket = bucket + 1 & this.fromOrdinalsMap.length - 1;
        }
        this.fromOrdinalsMap[bucket] = fromOrdinalMapEntry;
    }

    public void buildToOrdinalIdentityMapping() {
        for (int i = 0; i < this.fromOrdinalsMap.length; ++i) {
            if (this.fromOrdinalsMap[i] < 0L) continue;
            int toOrdinal = (int)(this.fromOrdinalsMap[i] >> 32);
            this.addToOrdinalIdentity(toOrdinal, toOrdinal);
        }
        boolean newCluster = true;
        int currentIdentity = 0;
        for (int i = 0; i < this.pivotedToOrdinalClusters.size(); ++i) {
            if (newCluster) {
                currentIdentity = this.pivotedToOrdinalClusters.get(i);
            }
            this.addToOrdinalIdentity(this.pivotedToOrdinalClusters.get(i) & Integer.MAX_VALUE, currentIdentity);
            newCluster = (this.pivotedToOrdinalClusters.get(i) & Integer.MIN_VALUE) != 0;
        }
    }

    private void addToOrdinalIdentity(int toOrdinal, int identity) {
        int hashCode = HashCodes.hashInt(toOrdinal);
        int bucket = hashCode & this.toOrdinalsIdentityMap.length - 1;
        while (this.toOrdinalsIdentityMap[bucket] != -1L) {
            bucket = bucket + 1 & this.toOrdinalsIdentityMap.length - 1;
        }
        this.toOrdinalsIdentityMap[bucket] = (long)identity << 32 | (long)toOrdinal;
    }

    public MatchIterator getEqualOrdinals(int fromOrdinal) {
        int hashCode = HashCodes.hashInt(fromOrdinal);
        int bucket = hashCode & this.fromOrdinalsMap.length - 1;
        while (this.fromOrdinalsMap[bucket] != -1L) {
            if ((int)this.fromOrdinalsMap[bucket] == fromOrdinal) {
                if ((this.fromOrdinalsMap[bucket] & Long.MIN_VALUE) != 0L) {
                    return new PivotedMatchIterator((int)((this.fromOrdinalsMap[bucket] & Long.MAX_VALUE) >> 32));
                }
                return new SingleMatchIterator((int)(this.fromOrdinalsMap[bucket] >> 32));
            }
            bucket = bucket + 1 & this.fromOrdinalsMap.length - 1;
        }
        return EmptyMatchIterator.INSTANCE;
    }

    public int getIdentityFromOrdinal(int fromOrdinal) {
        int hashCode = HashCodes.hashInt(fromOrdinal);
        int bucket = hashCode & this.fromOrdinalsMap.length - 1;
        while (this.fromOrdinalsMap[bucket] != -1L) {
            if ((int)this.fromOrdinalsMap[bucket] == fromOrdinal) {
                if ((this.fromOrdinalsMap[bucket] & Long.MIN_VALUE) != 0L) {
                    return this.pivotedToOrdinalClusters.get((int)((this.fromOrdinalsMap[bucket] & Long.MAX_VALUE) >> 32));
                }
                return (int)(this.fromOrdinalsMap[bucket] >> 32);
            }
            bucket = bucket + 1 & this.fromOrdinalsMap.length - 1;
        }
        return -1;
    }

    public int getIdentityToOrdinal(int toOrdinal) {
        int hashCode = HashCodes.hashInt(toOrdinal);
        int bucket = hashCode & this.toOrdinalsIdentityMap.length - 1;
        while (this.toOrdinalsIdentityMap[bucket] != -1L) {
            if ((int)this.toOrdinalsIdentityMap[bucket] == toOrdinal) {
                return (int)(this.toOrdinalsIdentityMap[bucket] >> 32);
            }
            bucket = bucket + 1 & this.toOrdinalsIdentityMap.length - 1;
        }
        return -1;
    }

    public OrdinalIdentityTranslator getFromOrdinalIdentityTranslator() {
        return this.fromIdentityTranslator;
    }

    public OrdinalIdentityTranslator getToOrdinalIdentityTranslator() {
        return this.toIdentityTranslator;
    }

    public class PivotedMatchIterator
    implements MatchIterator {
        private int currentMatchListPosition;
        private boolean exhausted;

        public PivotedMatchIterator(int matchListPosition) {
            this.currentMatchListPosition = matchListPosition;
        }

        @Override
        public boolean hasNext() {
            return !this.exhausted;
        }

        @Override
        public int next() {
            int nextVal = DiffEqualOrdinalMap.this.pivotedToOrdinalClusters.get(this.currentMatchListPosition++);
            this.exhausted = (nextVal & Integer.MIN_VALUE) != 0;
            return nextVal & Integer.MAX_VALUE;
        }
    }

    public static class SingleMatchIterator
    implements MatchIterator {
        private final int singleMatch;
        private boolean exhausted;

        public SingleMatchIterator(int singleMatch) {
            this.singleMatch = singleMatch;
        }

        @Override
        public boolean hasNext() {
            return !this.exhausted;
        }

        @Override
        public int next() {
            this.exhausted = true;
            return this.singleMatch;
        }
    }

    public static class EmptyMatchIterator
    implements MatchIterator {
        static EmptyMatchIterator INSTANCE = new EmptyMatchIterator();

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public int next() {
            return -1;
        }
    }

    public static interface MatchIterator {
        public boolean hasNext();

        public int next();
    }

    public static interface OrdinalIdentityTranslator {
        public int getIdentityOrdinal(int var1);
    }
}

