/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.tools.diff.count;

import com.netflix.hollow.core.read.engine.HollowTypeReadState;
import com.netflix.hollow.core.read.engine.object.HollowObjectTypeReadState;
import com.netflix.hollow.core.schema.HollowObjectSchema;
import com.netflix.hollow.core.util.IntList;
import com.netflix.hollow.tools.diff.HollowDiff;
import com.netflix.hollow.tools.diff.HollowDiffNodeIdentifier;
import com.netflix.hollow.tools.diff.HollowTypeDiff;
import com.netflix.hollow.tools.diff.count.HollowDiffCountingNode;
import com.netflix.hollow.tools.diff.count.HollowDiffFieldCountingNode;
import com.netflix.hollow.tools.diff.count.HollowFieldDiff;
import com.netflix.hollow.tools.diff.exact.DiffEqualOrdinalFilter;
import java.util.ArrayList;
import java.util.List;

public class HollowDiffObjectCountingNode
extends HollowDiffCountingNode {
    private final HollowObjectTypeReadState fromState;
    private final HollowObjectTypeReadState toState;
    private final HollowObjectSchema fromSchema;
    private final HollowObjectSchema toSchema;
    private final HollowObjectSchema unionSchema;
    private final int[] fromFieldMapping;
    private final int[] toFieldMapping;
    private final HollowDiffCountingNode[] fieldNodes;
    private final boolean[] fieldRequiresMissingFieldTraversal;
    private final DiffEqualOrdinalFilter[] fieldEqualOrdinalFilters;
    private final IntList traversalFromOrdinals = new IntList();
    private final IntList traversalToOrdinals = new IntList();

    public HollowDiffObjectCountingNode(HollowDiff diff, HollowTypeDiff topLevelTypeDiff, HollowDiffNodeIdentifier nodeId, HollowObjectTypeReadState fromState, HollowObjectTypeReadState toState) {
        super(diff, topLevelTypeDiff, nodeId);
        this.fromState = fromState;
        this.toState = toState;
        this.fromSchema = fromState == null ? this.emptySchema(toState.getSchema()) : fromState.getSchema();
        HollowObjectSchema hollowObjectSchema = this.toSchema = toState == null ? this.emptySchema(fromState.getSchema()) : toState.getSchema();
        if (!this.fromSchema.getName().equals(this.toSchema.getName())) {
            throw new IllegalArgumentException("Cannot diff between two schemas with different names: from '" + this.fromSchema.getName() + "' to '" + this.toSchema.getName() + "'");
        }
        this.unionSchema = this.fromSchema.findUnionSchema(this.toSchema);
        this.fieldNodes = new HollowDiffCountingNode[this.unionSchema.numFields()];
        this.fromFieldMapping = this.createFieldMapping(this.unionSchema, this.fromSchema);
        this.toFieldMapping = this.createFieldMapping(this.unionSchema, this.toSchema);
        this.fieldRequiresMissingFieldTraversal = new boolean[this.unionSchema.numFields()];
        this.fieldEqualOrdinalFilters = new DiffEqualOrdinalFilter[this.unionSchema.numFields()];
        for (int i = 0; i < this.unionSchema.numFields(); ++i) {
            int fromFieldIndex = this.fromSchema.getPosition(this.unionSchema.getFieldName(i));
            int toFieldIndex = this.toSchema.getPosition(this.unionSchema.getFieldName(i));
            if (this.unionSchema.getFieldType(i) == HollowObjectSchema.FieldType.REFERENCE) {
                HollowTypeReadState refFromState = fromFieldIndex == -1 ? null : this.fromSchema.getReferencedTypeState(fromFieldIndex);
                HollowTypeReadState refToState = toFieldIndex == -1 ? null : this.toSchema.getReferencedTypeState(toFieldIndex);
                this.fieldNodes[i] = this.getHollowDiffCountingNode(refFromState, refToState, this.unionSchema.getFieldName(i));
                this.fieldEqualOrdinalFilters[i] = new DiffEqualOrdinalFilter(this.equalityMapping.getEqualOrdinalMap(this.unionSchema.getReferencedType(i)));
                if (refFromState != null && refToState != null && !this.equalityMapping.requiresMissingFieldTraversal(this.unionSchema.getReferencedType(i))) continue;
                this.fieldRequiresMissingFieldTraversal[i] = true;
                continue;
            }
            HollowDiffNodeIdentifier childNodeId = new HollowDiffNodeIdentifier(nodeId, this.unionSchema.getFieldName(i), this.unionSchema.getFieldType(i).toString());
            this.fieldNodes[i] = new HollowDiffFieldCountingNode(diff, topLevelTypeDiff, childNodeId, fromState, toState, this.unionSchema, i);
        }
    }

    private HollowObjectSchema emptySchema(HollowObjectSchema other) {
        return new HollowObjectSchema(other.getName(), 0, new String[0]);
    }

    @Override
    public void prepare(int topLevelFromOrdinal, int topLevelToOrdinal) {
        for (int i = 0; i < this.fieldNodes.length; ++i) {
            this.fieldNodes[i].prepare(topLevelFromOrdinal, topLevelToOrdinal);
        }
    }

    @Override
    public int traverseDiffs(IntList fromOrdinals, IntList toOrdinals) {
        int score = 0;
        for (int i = 0; i < this.fieldNodes.length; ++i) {
            int fromFieldIdx = this.fromFieldMapping[i];
            int toFieldIdx = this.toFieldMapping[i];
            if (this.unionSchema.getFieldType(i) == HollowObjectSchema.FieldType.REFERENCE) {
                int refOrdinal;
                int j;
                this.traversalFromOrdinals.clear();
                this.traversalToOrdinals.clear();
                if (fromFieldIdx != -1) {
                    for (j = 0; j < fromOrdinals.size(); ++j) {
                        int fromOrdinal = fromOrdinals.get(j);
                        refOrdinal = this.fromState.readOrdinal(fromOrdinal, fromFieldIdx);
                        if (refOrdinal == -1) continue;
                        this.traversalFromOrdinals.add(refOrdinal);
                    }
                }
                if (toFieldIdx != -1) {
                    for (j = 0; j < toOrdinals.size(); ++j) {
                        int toOrdinal = toOrdinals.get(j);
                        refOrdinal = this.toState.readOrdinal(toOrdinal, toFieldIdx);
                        if (refOrdinal == -1) continue;
                        this.traversalToOrdinals.add(refOrdinal);
                    }
                }
                if (this.traversalFromOrdinals.size() == 0 && this.traversalToOrdinals.size() == 0) continue;
                this.fieldEqualOrdinalFilters[i].filter(this.traversalFromOrdinals, this.traversalToOrdinals);
                if (this.fieldEqualOrdinalFilters[i].getUnmatchedFromOrdinals().size() != 0 || this.fieldEqualOrdinalFilters[i].getUnmatchedToOrdinals().size() != 0) {
                    score += this.fieldNodes[i].traverseDiffs(this.fieldEqualOrdinalFilters[i].getUnmatchedFromOrdinals(), this.fieldEqualOrdinalFilters[i].getUnmatchedToOrdinals());
                }
                if (!this.fieldRequiresMissingFieldTraversal[i] || this.fieldEqualOrdinalFilters[i].getMatchedFromOrdinals().size() == 0 && this.fieldEqualOrdinalFilters[i].getMatchedToOrdinals().size() == 0) continue;
                score += this.fieldNodes[i].traverseMissingFields(this.fieldEqualOrdinalFilters[i].getMatchedFromOrdinals(), this.fieldEqualOrdinalFilters[i].getMatchedToOrdinals());
                continue;
            }
            if (fromFieldIdx == -1) {
                score += this.fieldNodes[i].traverseDiffs(EMPTY_ORDINAL_LIST, toOrdinals);
                continue;
            }
            if (toFieldIdx == -1) {
                score += this.fieldNodes[i].traverseDiffs(fromOrdinals, EMPTY_ORDINAL_LIST);
                continue;
            }
            score += this.fieldNodes[i].traverseDiffs(fromOrdinals, toOrdinals);
        }
        return score;
    }

    @Override
    public int traverseMissingFields(IntList fromOrdinals, IntList toOrdinals) {
        int score = 0;
        for (int i = 0; i < this.fieldNodes.length; ++i) {
            if (this.fieldRequiresMissingFieldTraversal[i]) {
                int j;
                this.traversalFromOrdinals.clear();
                this.traversalToOrdinals.clear();
                if (this.fromFieldMapping[i] != -1) {
                    for (j = 0; j < fromOrdinals.size(); ++j) {
                        int fromOrdinal = this.fromState.readOrdinal(fromOrdinals.get(j), this.fromFieldMapping[i]);
                        if (fromOrdinal == -1) continue;
                        this.traversalFromOrdinals.add(fromOrdinal);
                    }
                }
                if (this.toFieldMapping[i] != -1) {
                    for (j = 0; j < toOrdinals.size(); ++j) {
                        int toOrdinal = this.toState.readOrdinal(toOrdinals.get(j), this.toFieldMapping[i]);
                        if (toOrdinal == -1) continue;
                        this.traversalToOrdinals.add(toOrdinal);
                    }
                }
                score += this.fieldNodes[i].traverseMissingFields(this.traversalFromOrdinals, this.traversalToOrdinals);
                continue;
            }
            if (!(this.fieldNodes[i] instanceof HollowDiffFieldCountingNode)) continue;
            score += this.fieldNodes[i].traverseMissingFields(fromOrdinals, toOrdinals);
        }
        return score;
    }

    private int[] createFieldMapping(HollowObjectSchema unionSchema, HollowObjectSchema individualSchema) {
        int[] mapping = new int[unionSchema.numFields()];
        for (int i = 0; i < unionSchema.numFields(); ++i) {
            String fieldName = unionSchema.getFieldName(i);
            mapping[i] = individualSchema.getPosition(fieldName);
        }
        return mapping;
    }

    @Override
    public List<HollowFieldDiff> getFieldDiffs() {
        ArrayList<HollowFieldDiff> list = new ArrayList<HollowFieldDiff>();
        for (HollowDiffCountingNode node : this.fieldNodes) {
            list.addAll(node.getFieldDiffs());
        }
        return list;
    }
}

