/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.core.write.objectmapper.flatrecords.traversal;

import com.netflix.hollow.core.schema.HollowObjectSchema;
import com.netflix.hollow.core.schema.HollowSetSchema;
import com.netflix.hollow.core.write.objectmapper.flatrecords.FlatRecordOrdinalReader;
import com.netflix.hollow.core.write.objectmapper.flatrecords.traversal.FlatRecordTraversalListNode;
import com.netflix.hollow.core.write.objectmapper.flatrecords.traversal.FlatRecordTraversalMapNode;
import com.netflix.hollow.core.write.objectmapper.flatrecords.traversal.FlatRecordTraversalNode;
import com.netflix.hollow.core.write.objectmapper.flatrecords.traversal.FlatRecordTraversalObjectNode;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Map;

public class FlatRecordTraversalSetNode
extends AbstractSet<FlatRecordTraversalNode>
implements FlatRecordTraversalNode {
    private final FlatRecordOrdinalReader reader;
    private final HollowSetSchema schema;
    private final int ordinal;
    private final int[] elementOrdinals;
    private Map<String, HollowObjectSchema> commonSchemaMap;

    public FlatRecordTraversalSetNode(FlatRecordOrdinalReader reader, HollowSetSchema schema, int ordinal) {
        this.reader = reader;
        this.ordinal = ordinal;
        this.schema = schema;
        int size = reader.readSize(ordinal);
        this.elementOrdinals = new int[size];
        reader.readSetElementsInto(ordinal, this.elementOrdinals);
    }

    @Override
    public HollowSetSchema getSchema() {
        return this.schema;
    }

    @Override
    public int getOrdinal() {
        return this.ordinal;
    }

    @Override
    public void setCommonSchema(Map<String, HollowObjectSchema> commonSchema) {
        this.commonSchemaMap = commonSchema;
    }

    public Iterator<FlatRecordTraversalObjectNode> objects() {
        return new IteratorImpl<FlatRecordTraversalObjectNode>();
    }

    public Iterator<FlatRecordTraversalListNode> lists() {
        return new IteratorImpl<FlatRecordTraversalListNode>();
    }

    public Iterator<FlatRecordTraversalSetNode> sets() {
        return new IteratorImpl<FlatRecordTraversalSetNode>();
    }

    public Iterator<FlatRecordTraversalMapNode> maps() {
        return new IteratorImpl<FlatRecordTraversalMapNode>();
    }

    @Override
    public Iterator<FlatRecordTraversalNode> iterator() {
        return new IteratorImpl<FlatRecordTraversalNode>();
    }

    @Override
    public int size() {
        return this.elementOrdinals.length;
    }

    @Override
    public int hashCode() {
        int h = 0;
        for (FlatRecordTraversalNode obj : this) {
            if (obj == null || !this.commonSchemaMap.containsKey(obj.getSchema().getName())) continue;
            obj.setCommonSchema(this.commonSchemaMap);
            h += obj.hashCode();
        }
        return h;
    }

    private class IteratorImpl<T extends FlatRecordTraversalNode>
    implements Iterator<T> {
        private int index = 0;

        private IteratorImpl() {
        }

        @Override
        public boolean hasNext() {
            return this.index < FlatRecordTraversalSetNode.this.elementOrdinals.length;
        }

        @Override
        public T next() {
            int elementOrdinal = FlatRecordTraversalSetNode.this.elementOrdinals[this.index++];
            if (elementOrdinal == -1) {
                return null;
            }
            return (T)FlatRecordTraversalSetNode.this.createNode(FlatRecordTraversalSetNode.this.reader, elementOrdinal);
        }
    }
}

