/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.core.write.objectmapper.flatrecords.traversal;

import com.netflix.hollow.core.schema.HollowListSchema;
import com.netflix.hollow.core.schema.HollowObjectSchema;
import com.netflix.hollow.core.write.objectmapper.flatrecords.FlatRecordOrdinalReader;
import com.netflix.hollow.core.write.objectmapper.flatrecords.traversal.FlatRecordTraversalMapNode;
import com.netflix.hollow.core.write.objectmapper.flatrecords.traversal.FlatRecordTraversalNode;
import com.netflix.hollow.core.write.objectmapper.flatrecords.traversal.FlatRecordTraversalObjectNode;
import com.netflix.hollow.core.write.objectmapper.flatrecords.traversal.FlatRecordTraversalSetNode;
import java.util.AbstractList;
import java.util.Map;

public class FlatRecordTraversalListNode
extends AbstractList<FlatRecordTraversalNode>
implements FlatRecordTraversalNode {
    private final FlatRecordOrdinalReader reader;
    private final HollowListSchema schema;
    private final int ordinal;
    private final int[] elementOrdinals;
    private Map<String, HollowObjectSchema> commonSchemaMap;

    public FlatRecordTraversalListNode(FlatRecordOrdinalReader reader, HollowListSchema schema, int ordinal) {
        this.reader = reader;
        this.ordinal = ordinal;
        this.schema = schema;
        int size = reader.readSize(ordinal);
        this.elementOrdinals = new int[size];
        reader.readListElementsInto(ordinal, this.elementOrdinals);
    }

    @Override
    public HollowListSchema getSchema() {
        return this.schema;
    }

    @Override
    public int getOrdinal() {
        return this.ordinal;
    }

    @Override
    public void setCommonSchema(Map<String, HollowObjectSchema> commonSchema) {
        this.commonSchemaMap = commonSchema;
    }

    public FlatRecordTraversalObjectNode getObject(int index) {
        return (FlatRecordTraversalObjectNode)this.get(index);
    }

    public FlatRecordTraversalListNode getList(int index) {
        return (FlatRecordTraversalListNode)this.get(index);
    }

    public FlatRecordTraversalSetNode getSet(int index) {
        return (FlatRecordTraversalSetNode)this.get(index);
    }

    public FlatRecordTraversalMapNode getMap(int index) {
        return (FlatRecordTraversalMapNode)this.get(index);
    }

    @Override
    public FlatRecordTraversalNode get(int index) {
        if (index >= this.elementOrdinals.length) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.elementOrdinals.length);
        }
        int elementOrdinal = this.elementOrdinals[index];
        if (elementOrdinal == -1) {
            return null;
        }
        return this.createNode(this.reader, elementOrdinal);
    }

    @Override
    public int size() {
        return this.elementOrdinals.length;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        for (FlatRecordTraversalNode e : this) {
            FlatRecordTraversalObjectNode objectNode = (FlatRecordTraversalObjectNode)e;
            if (objectNode != null && this.commonSchemaMap.containsKey(objectNode.getSchema().getName())) {
                objectNode.setCommonSchema(this.commonSchemaMap);
                hashCode = 31 * hashCode + objectNode.hashCode();
                continue;
            }
            if (objectNode != null) continue;
            hashCode = 31 * hashCode;
        }
        return hashCode;
    }
}

