/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.core.write.objectmapper;

import com.netflix.hollow.api.objects.HollowRecord;
import com.netflix.hollow.core.memory.ByteDataArray;
import com.netflix.hollow.core.write.HollowTypeWriteState;
import com.netflix.hollow.core.write.HollowWriteRecord;
import com.netflix.hollow.core.write.HollowWriteStateEngine;
import com.netflix.hollow.core.write.objectmapper.HollowTypeName;
import com.netflix.hollow.core.write.objectmapper.flatrecords.FlatRecordWriter;
import com.netflix.hollow.core.write.objectmapper.flatrecords.traversal.FlatRecordTraversalNode;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class HollowTypeMapper {
    public static final long ASSIGNED_ORDINAL_CYCLE_MASK = -4294967296L;
    private final ThreadLocal<HollowWriteRecord> writeRec = new ThreadLocal();
    private final ThreadLocal<ByteDataArray> flatRecBuffer = new ThreadLocal();

    protected abstract String getTypeName();

    protected abstract int write(Object var1);

    protected abstract int writeFlat(Object var1, FlatRecordWriter var2);

    protected abstract Object parseHollowRecord(HollowRecord var1);

    protected abstract Object parseFlatRecord(FlatRecordTraversalNode var1);

    protected abstract HollowWriteRecord newWriteRecord();

    protected abstract HollowTypeWriteState getTypeWriteState();

    protected void addTypeState(HollowWriteStateEngine stateEngine) {
        if (stateEngine.getTypeState(this.getTypeName()) == null) {
            stateEngine.addTypeState(this.getTypeWriteState());
        }
    }

    protected HollowWriteRecord writeRecord() {
        HollowWriteRecord rec = this.writeRec.get();
        if (rec == null) {
            rec = this.newWriteRecord();
            this.writeRec.set(rec);
        }
        rec.reset();
        return rec;
    }

    protected ByteDataArray flatRecBuffer() {
        ByteDataArray buf = this.flatRecBuffer.get();
        if (buf == null) {
            buf = new ByteDataArray();
            this.flatRecBuffer.set(buf);
        }
        buf.reset();
        return buf;
    }

    public static String getDefaultTypeName(Type type) {
        if (type instanceof Class) {
            Class clazz = (Class)type;
            HollowTypeName explicitTypeName = clazz.getAnnotation(HollowTypeName.class);
            if (explicitTypeName != null) {
                return explicitTypeName.name();
            }
            return clazz.getSimpleName();
        }
        ParameterizedType parameterizedType = (ParameterizedType)type;
        Class clazz = (Class)parameterizedType.getRawType();
        if (List.class.isAssignableFrom(clazz)) {
            return "ListOf" + HollowTypeMapper.getDefaultTypeName(parameterizedType.getActualTypeArguments()[0]);
        }
        if (Set.class.isAssignableFrom(clazz)) {
            return "SetOf" + HollowTypeMapper.getDefaultTypeName(parameterizedType.getActualTypeArguments()[0]);
        }
        if (Map.class.isAssignableFrom(clazz)) {
            return "MapOf" + HollowTypeMapper.getDefaultTypeName(parameterizedType.getActualTypeArguments()[0]) + "To" + HollowTypeMapper.getDefaultTypeName(parameterizedType.getActualTypeArguments()[1]);
        }
        return clazz.getSimpleName();
    }

    protected long cycleSpecificAssignedOrdinalBits() {
        return this.getTypeWriteState().getStateEngine().getNextStateRandomizedTag() & 0xFFFFFFFF00000000L;
    }
}

