/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.core.write.objectmapper;

import com.netflix.hollow.api.objects.HollowRecord;
import com.netflix.hollow.api.objects.generic.GenericHollowObject;
import com.netflix.hollow.core.index.key.PrimaryKey;
import com.netflix.hollow.core.memory.HollowUnsafeHandle;
import com.netflix.hollow.core.schema.HollowObjectSchema;
import com.netflix.hollow.core.write.HollowObjectTypeWriteState;
import com.netflix.hollow.core.write.HollowObjectWriteRecord;
import com.netflix.hollow.core.write.HollowTypeWriteState;
import com.netflix.hollow.core.write.HollowWriteRecord;
import com.netflix.hollow.core.write.objectmapper.HollowHashKey;
import com.netflix.hollow.core.write.objectmapper.HollowInline;
import com.netflix.hollow.core.write.objectmapper.HollowObjectMapper;
import com.netflix.hollow.core.write.objectmapper.HollowPrimaryKey;
import com.netflix.hollow.core.write.objectmapper.HollowShardLargeType;
import com.netflix.hollow.core.write.objectmapper.HollowTransient;
import com.netflix.hollow.core.write.objectmapper.HollowTypeMapper;
import com.netflix.hollow.core.write.objectmapper.HollowTypeName;
import com.netflix.hollow.core.write.objectmapper.NullablePrimitiveBoolean;
import com.netflix.hollow.core.write.objectmapper.flatrecords.FlatRecordWriter;
import com.netflix.hollow.core.write.objectmapper.flatrecords.traversal.FlatRecordTraversalNode;
import com.netflix.hollow.core.write.objectmapper.flatrecords.traversal.FlatRecordTraversalObjectNode;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import sun.misc.Unsafe;

public class HollowObjectTypeMapper
extends HollowTypeMapper {
    private static final Set<Class<?>> BOXED_WRAPPERS = new HashSet<Class>(Arrays.asList(Boolean.class, Integer.class, Short.class, Byte.class, Character.class, Long.class, Float.class, Double.class, String.class, byte[].class, Date.class));
    private static final Unsafe unsafe = HollowUnsafeHandle.getUnsafe();
    private final HollowObjectMapper parentMapper;
    private final String typeName;
    private final Class<?> clazz;
    private final HollowObjectSchema schema;
    private final HollowObjectTypeWriteState writeState;
    private final boolean hasAssignedOrdinalField;
    private final long assignedOrdinalFieldOffset;
    private final List<MappedField> mappedFields;
    private volatile int[][] primaryKeyFieldPathIdx;

    public HollowObjectTypeMapper(HollowObjectMapper parentMapper, Class<?> clazz, String declaredTypeName, Set<Type> visited) {
        int numShardsByAnnotation;
        this.parentMapper = parentMapper;
        this.clazz = clazz;
        this.typeName = declaredTypeName != null ? declaredTypeName : HollowObjectTypeMapper.getDefaultTypeName(clazz);
        this.mappedFields = new ArrayList<MappedField>();
        boolean hasAssignedOrdinalField = false;
        long assignedOrdinalFieldOffset = -1L;
        if (clazz == String.class) {
            try {
                this.mappedFields.add(new MappedField(clazz.getDeclaredField("value")));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        } else if (clazz == Date.class) {
            try {
                this.mappedFields.add(new MappedField(MappedFieldType.DATE_TIME));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        } else {
            for (Class<?> currentClass = clazz; currentClass != Object.class && currentClass != Enum.class; currentClass = currentClass.getSuperclass()) {
                if (currentClass.isInterface()) {
                    throw new IllegalArgumentException("Unexpected interface " + currentClass.getSimpleName() + " passed as field.");
                }
                if (currentClass.isArray()) {
                    throw new IllegalArgumentException("Unexpected array " + currentClass.getSimpleName() + " passed as field. Consider using collections or marking as transient.");
                }
                Field[] declaredFields = currentClass.getDeclaredFields();
                for (int i = 0; i < declaredFields.length; ++i) {
                    Field declaredField = declaredFields[i];
                    int modifiers = declaredField.getModifiers();
                    if (!(Modifier.isTransient(modifiers) || Modifier.isStatic(modifiers) || "__assigned_ordinal".equals(declaredField.getName()) || declaredField.isAnnotationPresent(HollowTransient.class))) {
                        this.mappedFields.add(new MappedField(declaredField, visited));
                        continue;
                    }
                    if (!"__assigned_ordinal".equals(declaredField.getName()) || currentClass != clazz || declaredField.getType() != Long.TYPE) continue;
                    assignedOrdinalFieldOffset = unsafe.objectFieldOffset(declaredField);
                    hasAssignedOrdinalField = true;
                }
                if (!currentClass.isEnum()) continue;
                this.mappedFields.add(new MappedField(MappedFieldType.ENUM_NAME));
            }
        }
        this.schema = new HollowObjectSchema(this.typeName, this.mappedFields.size(), HollowObjectTypeMapper.getKeyFieldPaths(clazz));
        HashSet<String> fieldNamesSeen = new HashSet<String>();
        for (MappedField field : this.mappedFields) {
            if (!fieldNamesSeen.add(field.getFieldName())) {
                throw new IllegalArgumentException("Duplicate field name '" + field.getFieldName() + "' found in class hierarchy for class " + clazz.getName());
            }
            if (field.getFieldType() == MappedFieldType.REFERENCE) {
                this.schema.addField(field.getFieldName(), field.getFieldType().getSchemaFieldType(), field.getReferencedTypeName());
                continue;
            }
            this.schema.addField(field.getFieldName(), field.getFieldType().getSchemaFieldType());
        }
        HollowObjectTypeWriteState existingWriteState = (HollowObjectTypeWriteState)parentMapper.getStateEngine().getTypeState(this.typeName);
        this.writeState = existingWriteState != null ? existingWriteState : new HollowObjectTypeWriteState(this.schema, numShardsByAnnotation, (numShardsByAnnotation = HollowObjectTypeMapper.getNumShardsByAnnotation(clazz)) != -1);
        this.assignedOrdinalFieldOffset = assignedOrdinalFieldOffset;
        this.hasAssignedOrdinalField = hasAssignedOrdinalField;
    }

    private static String[] getKeyFieldPaths(Class<?> clazz) {
        HollowPrimaryKey primaryKey = clazz.getAnnotation(HollowPrimaryKey.class);
        while (primaryKey == null && clazz != Object.class && clazz.isInterface()) {
            clazz = clazz.getSuperclass();
            primaryKey = clazz.getAnnotation(HollowPrimaryKey.class);
        }
        return primaryKey == null ? null : primaryKey.fields();
    }

    private static int getNumShardsByAnnotation(Class<?> clazz) {
        HollowShardLargeType numShardsAnnotation = clazz.getAnnotation(HollowShardLargeType.class);
        if (numShardsAnnotation != null) {
            return numShardsAnnotation.numShards();
        }
        return -1;
    }

    @Override
    public String getTypeName() {
        return this.typeName;
    }

    @Override
    public int write(Object obj) {
        long assignedOrdinal;
        if (this.hasAssignedOrdinalField && ((assignedOrdinal = unsafe.getLong(obj, this.assignedOrdinalFieldOffset)) & 0xFFFFFFFF00000000L) == this.cycleSpecificAssignedOrdinalBits()) {
            return (int)assignedOrdinal & Integer.MAX_VALUE;
        }
        HollowObjectWriteRecord rec = this.copyToWriteRecord(obj, null);
        int assignedOrdinal2 = this.writeState.add(rec);
        if (this.hasAssignedOrdinalField) {
            unsafe.putLong(obj, this.assignedOrdinalFieldOffset, (long)assignedOrdinal2 | this.cycleSpecificAssignedOrdinalBits());
        }
        return assignedOrdinal2;
    }

    @Override
    public int writeFlat(Object obj, FlatRecordWriter flatRecordWriter) {
        HollowObjectWriteRecord rec = this.copyToWriteRecord(obj, flatRecordWriter);
        return flatRecordWriter.write(this.schema, rec);
    }

    private HollowObjectWriteRecord copyToWriteRecord(Object obj, FlatRecordWriter flatRecordWriter) {
        if (obj.getClass() != this.clazz && !this.clazz.isAssignableFrom(obj.getClass())) {
            throw new IllegalArgumentException("Attempting to write unexpected class!  Expected " + this.clazz + " but object was " + obj.getClass());
        }
        HollowObjectWriteRecord rec = (HollowObjectWriteRecord)this.writeRecord();
        for (int i = 0; i < this.mappedFields.size(); ++i) {
            this.mappedFields.get(i).copy(obj, rec, flatRecordWriter);
        }
        return rec;
    }

    @Override
    protected Object parseHollowRecord(HollowRecord record) {
        try {
            GenericHollowObject hollowObject = (GenericHollowObject)record;
            HollowObjectSchema objectSchema = (HollowObjectSchema)record.getSchema();
            Object obj = null;
            if (BOXED_WRAPPERS.contains(this.clazz)) {
                for (int i = 0; i < objectSchema.numFields(); ++i) {
                    int posInPojoSchema = this.schema.getPosition(objectSchema.getFieldName(i));
                    if (posInPojoSchema == -1) continue;
                    obj = this.mappedFields.get(posInPojoSchema).parseBoxedWrapper(hollowObject);
                }
            } else if (this.clazz.isEnum()) {
                for (int i = 0; i < objectSchema.numFields(); ++i) {
                    String fieldName = objectSchema.getFieldName(i);
                    int posInPojoSchema = this.schema.getPosition(fieldName);
                    if (!fieldName.equals(MappedFieldType.ENUM_NAME.getSpecialFieldName()) || posInPojoSchema == -1) continue;
                    obj = this.mappedFields.get(posInPojoSchema).parseBoxedWrapper(hollowObject);
                }
            } else {
                obj = unsafe.allocateInstance(this.clazz);
                for (int i = 0; i < objectSchema.numFields(); ++i) {
                    int posInPojoSchema = this.schema.getPosition(objectSchema.getFieldName(i));
                    if (posInPojoSchema == -1) continue;
                    this.mappedFields.get(posInPojoSchema).copy(obj, hollowObject);
                }
            }
            return obj;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected Object parseFlatRecord(FlatRecordTraversalNode node) {
        try {
            FlatRecordTraversalObjectNode objectNode = (FlatRecordTraversalObjectNode)node;
            HollowObjectSchema flatRecordSchema = objectNode.getSchema();
            Object obj = null;
            if (BOXED_WRAPPERS.contains(this.clazz)) {
                for (int i = 0; i < flatRecordSchema.numFields(); ++i) {
                    int posInPojoSchema = this.schema.getPosition(flatRecordSchema.getFieldName(i));
                    if (posInPojoSchema == -1) continue;
                    obj = this.mappedFields.get(posInPojoSchema).parseBoxedWrapper(objectNode);
                }
            } else if (this.clazz.isEnum()) {
                for (int i = 0; i < flatRecordSchema.numFields(); ++i) {
                    String fieldName = flatRecordSchema.getFieldName(i);
                    int posInPojoSchema = this.schema.getPosition(fieldName);
                    if (!fieldName.equals(MappedFieldType.ENUM_NAME.getSpecialFieldName()) || posInPojoSchema == -1) continue;
                    obj = this.mappedFields.get(posInPojoSchema).parseBoxedWrapper(objectNode);
                }
            } else {
                obj = unsafe.allocateInstance(this.clazz);
                for (int i = 0; i < flatRecordSchema.numFields(); ++i) {
                    int posInPojoSchema = this.schema.getPosition(flatRecordSchema.getFieldName(i));
                    if (posInPojoSchema == -1) continue;
                    this.mappedFields.get(posInPojoSchema).copy(obj, objectNode);
                }
            }
            return obj;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    Object[] extractPrimaryKey(Object obj) {
        int[][] primaryKeyFieldPathIdx = this.primaryKeyFieldPathIdx;
        if (primaryKeyFieldPathIdx == null) {
            this.primaryKeyFieldPathIdx = primaryKeyFieldPathIdx = this.calculatePrimaryKeyFieldPathIdx(primaryKeyFieldPathIdx);
        }
        Object[] key = new Object[primaryKeyFieldPathIdx.length];
        for (int i = 0; i < key.length; ++i) {
            key[i] = this.retrieveFieldValue(obj, primaryKeyFieldPathIdx[i], 0);
        }
        return key;
    }

    private int[][] calculatePrimaryKeyFieldPathIdx(int[][] primaryKeyFieldPathIdx) {
        if (this.schema.getPrimaryKey() == null) {
            throw new IllegalArgumentException("Type " + this.typeName + " does not have a primary key defined");
        }
        primaryKeyFieldPathIdx = new int[this.schema.getPrimaryKey().numFields()][];
        for (int i = 0; i < ((int[][])primaryKeyFieldPathIdx).length; ++i) {
            primaryKeyFieldPathIdx[i] = this.schema.getPrimaryKey().getFieldPathIndex(this.parentMapper.getStateEngine(), i);
        }
        return primaryKeyFieldPathIdx;
    }

    String[] getDefaultElementHashKey() {
        MappedField singleField;
        PrimaryKey pKey = this.schema.getPrimaryKey();
        if (pKey != null) {
            return pKey.getFieldPaths();
        }
        if (this.mappedFields.size() == 1 && (singleField = this.mappedFields.get(0)).getFieldType() != MappedFieldType.REFERENCE) {
            return new String[]{singleField.getFieldName()};
        }
        return null;
    }

    @Override
    protected HollowWriteRecord newWriteRecord() {
        return new HollowObjectWriteRecord(this.schema);
    }

    @Override
    protected HollowTypeWriteState getTypeWriteState() {
        return this.writeState;
    }

    private Object retrieveFieldValue(Object obj, int[] fieldPathIdx, int idx) {
        return this.mappedFields.get(fieldPathIdx[idx]).retrieveFieldValue(obj, fieldPathIdx, idx);
    }

    private static enum MappedFieldType {
        BOOLEAN(HollowObjectSchema.FieldType.BOOLEAN),
        NULLABLE_PRIMITIVE_BOOLEAN(HollowObjectSchema.FieldType.BOOLEAN),
        BYTES(HollowObjectSchema.FieldType.BYTES),
        DOUBLE(HollowObjectSchema.FieldType.DOUBLE),
        FLOAT(HollowObjectSchema.FieldType.FLOAT),
        INT(HollowObjectSchema.FieldType.INT),
        SHORT(HollowObjectSchema.FieldType.INT),
        BYTE(HollowObjectSchema.FieldType.INT),
        CHAR(HollowObjectSchema.FieldType.INT),
        LONG(HollowObjectSchema.FieldType.LONG),
        STRING(HollowObjectSchema.FieldType.STRING),
        INLINED_BOOLEAN(HollowObjectSchema.FieldType.BOOLEAN),
        INLINED_DOUBLE(HollowObjectSchema.FieldType.DOUBLE),
        INLINED_FLOAT(HollowObjectSchema.FieldType.FLOAT),
        INLINED_INT(HollowObjectSchema.FieldType.INT),
        INLINED_SHORT(HollowObjectSchema.FieldType.INT),
        INLINED_BYTE(HollowObjectSchema.FieldType.INT),
        INLINED_CHAR(HollowObjectSchema.FieldType.INT),
        INLINED_LONG(HollowObjectSchema.FieldType.LONG),
        INLINED_STRING(HollowObjectSchema.FieldType.STRING),
        REFERENCE(HollowObjectSchema.FieldType.REFERENCE),
        ENUM_NAME(HollowObjectSchema.FieldType.STRING, "_name"),
        DATE_TIME(HollowObjectSchema.FieldType.LONG, "value");

        private final HollowObjectSchema.FieldType schemaFieldType;
        private final String specialFieldName;

        private MappedFieldType(HollowObjectSchema.FieldType schemaFieldType) {
            this.specialFieldName = null;
            this.schemaFieldType = schemaFieldType;
        }

        private MappedFieldType(HollowObjectSchema.FieldType schemaFieldType, String specialFieldName) {
            this.schemaFieldType = schemaFieldType;
            this.specialFieldName = specialFieldName;
        }

        public String getSpecialFieldName() {
            return this.specialFieldName;
        }

        public HollowObjectSchema.FieldType getSchemaFieldType() {
            return this.schemaFieldType;
        }
    }

    private class MappedField {
        private final String fieldName;
        private final long fieldOffset;
        private final Type type;
        private final MappedFieldType fieldType;
        private final HollowTypeMapper subTypeMapper;
        private final HollowTypeName typeNameAnnotation;
        private final HollowHashKey hashKeyAnnotation;
        private final HollowShardLargeType numShardsAnnotation;
        private final boolean isInlinedField;

        private MappedField(Field f) {
            this(f, new HashSet<Type>());
        }

        private MappedField(Field f, Set<Type> visitedTypes) {
            this.fieldOffset = unsafe.objectFieldOffset(f);
            this.fieldName = f.getName();
            this.type = f.getGenericType();
            this.typeNameAnnotation = f.getAnnotation(HollowTypeName.class);
            this.hashKeyAnnotation = f.getAnnotation(HollowHashKey.class);
            this.numShardsAnnotation = f.getAnnotation(HollowShardLargeType.class);
            this.isInlinedField = f.isAnnotationPresent(HollowInline.class);
            HollowTypeMapper subTypeMapper = null;
            if (this.type == Integer.TYPE) {
                this.fieldType = MappedFieldType.INT;
            } else if (this.type == Short.TYPE) {
                this.fieldType = MappedFieldType.SHORT;
            } else if (this.type == Byte.TYPE) {
                this.fieldType = MappedFieldType.BYTE;
            } else if (this.type == Character.TYPE) {
                this.fieldType = MappedFieldType.CHAR;
            } else if (this.type == Long.TYPE) {
                this.fieldType = MappedFieldType.LONG;
            } else if (this.type == Boolean.TYPE) {
                this.fieldType = MappedFieldType.BOOLEAN;
            } else if (this.type == Float.TYPE) {
                this.fieldType = MappedFieldType.FLOAT;
            } else if (this.type == Double.TYPE) {
                this.fieldType = MappedFieldType.DOUBLE;
            } else if (this.type == byte[].class && HollowObjectTypeMapper.this.clazz == String.class) {
                this.fieldType = MappedFieldType.STRING;
            } else if (this.type == byte[].class) {
                this.fieldType = MappedFieldType.BYTES;
            } else if (this.type == char[].class) {
                this.fieldType = MappedFieldType.STRING;
            } else if (this.isInlinedField && this.type == Integer.class) {
                this.fieldType = MappedFieldType.INLINED_INT;
            } else if (this.isInlinedField && this.type == Short.class) {
                this.fieldType = MappedFieldType.INLINED_SHORT;
            } else if (this.isInlinedField && this.type == Byte.class) {
                this.fieldType = MappedFieldType.INLINED_BYTE;
            } else if (this.isInlinedField && this.type == Character.class) {
                this.fieldType = MappedFieldType.INLINED_CHAR;
            } else if (this.isInlinedField && this.type == Long.class) {
                this.fieldType = MappedFieldType.INLINED_LONG;
            } else if (this.isInlinedField && this.type == Boolean.class) {
                this.fieldType = MappedFieldType.INLINED_BOOLEAN;
            } else if (this.isInlinedField && this.type == Float.class) {
                this.fieldType = MappedFieldType.INLINED_FLOAT;
            } else if (this.isInlinedField && this.type == Double.class) {
                this.fieldType = MappedFieldType.INLINED_DOUBLE;
            } else if (this.isInlinedField && this.type == String.class) {
                this.fieldType = MappedFieldType.INLINED_STRING;
            } else if (this.type == NullablePrimitiveBoolean.class) {
                this.fieldType = MappedFieldType.NULLABLE_PRIMITIVE_BOOLEAN;
            } else {
                if (this.isInlinedField) {
                    throw new IllegalStateException("@HollowInline annotation defined on field " + f + ", which is not either a String or boxed primitive.");
                }
                this.fieldType = MappedFieldType.REFERENCE;
                if (visitedTypes.contains(this.type)) {
                    throw new IllegalStateException("circular reference detected on field " + f + "; this type of relationship is not supported");
                }
                visitedTypes.add(this.type);
                subTypeMapper = HollowObjectTypeMapper.this.parentMapper.getTypeMapper(this.type, this.typeNameAnnotation != null ? this.typeNameAnnotation.name() : null, this.hashKeyAnnotation != null ? this.hashKeyAnnotation.fields() : null, this.numShardsAnnotation != null ? this.numShardsAnnotation.numShards() : -1, visitedTypes);
                visitedTypes.remove(this.type);
            }
            this.subTypeMapper = subTypeMapper;
        }

        private MappedField(MappedFieldType specialField) {
            this.fieldOffset = -1L;
            this.type = null;
            this.typeNameAnnotation = null;
            this.hashKeyAnnotation = null;
            this.numShardsAnnotation = null;
            this.fieldName = specialField.getSpecialFieldName();
            this.fieldType = specialField;
            this.subTypeMapper = null;
            this.isInlinedField = false;
        }

        public String getFieldName() {
            return this.fieldName;
        }

        public MappedFieldType getFieldType() {
            return this.fieldType;
        }

        public String getReferencedTypeName() {
            if (this.typeNameAnnotation != null) {
                return this.typeNameAnnotation.name();
            }
            return this.subTypeMapper.getTypeName();
        }

        public void copy(Object obj, HollowObjectWriteRecord rec, FlatRecordWriter flatRecordWriter) {
            switch (this.fieldType) {
                case BOOLEAN: {
                    rec.setBoolean(this.fieldName, unsafe.getBoolean(obj, this.fieldOffset));
                    break;
                }
                case INT: {
                    rec.setInt(this.fieldName, unsafe.getInt(obj, this.fieldOffset));
                    break;
                }
                case SHORT: {
                    short shortValue = unsafe.getShort(obj, this.fieldOffset);
                    if (shortValue == Short.MIN_VALUE) {
                        rec.setInt(this.fieldName, Integer.MIN_VALUE);
                        break;
                    }
                    rec.setInt(this.fieldName, shortValue);
                    break;
                }
                case BYTE: {
                    byte byteValue = unsafe.getByte(obj, this.fieldOffset);
                    if (byteValue == -128) {
                        rec.setInt(this.fieldName, Integer.MIN_VALUE);
                        break;
                    }
                    rec.setInt(this.fieldName, byteValue);
                    break;
                }
                case CHAR: {
                    char charValue = unsafe.getChar(obj, this.fieldOffset);
                    if (charValue == '\u0000') {
                        rec.setInt(this.fieldName, Integer.MIN_VALUE);
                        break;
                    }
                    rec.setInt(this.fieldName, charValue);
                    break;
                }
                case LONG: {
                    rec.setLong(this.fieldName, unsafe.getLong(obj, this.fieldOffset));
                    break;
                }
                case DOUBLE: {
                    double d = unsafe.getDouble(obj, this.fieldOffset);
                    if (Double.isNaN(d)) break;
                    rec.setDouble(this.fieldName, d);
                    break;
                }
                case FLOAT: {
                    float f = unsafe.getFloat(obj, this.fieldOffset);
                    if (Float.isNaN(f)) break;
                    rec.setFloat(this.fieldName, f);
                    break;
                }
                case STRING: {
                    Object fieldObject = unsafe.getObject(obj, this.fieldOffset);
                    if (fieldObject == null) break;
                    rec.setString(this.fieldName, this.getStringFromField(obj, fieldObject));
                    break;
                }
                case BYTES: {
                    Object fieldObject = unsafe.getObject(obj, this.fieldOffset);
                    if (fieldObject == null) break;
                    rec.setBytes(this.fieldName, (byte[])fieldObject);
                    break;
                }
                case INLINED_BOOLEAN: {
                    Object fieldObject = unsafe.getObject(obj, this.fieldOffset);
                    if (fieldObject == null) break;
                    rec.setBoolean(this.fieldName, (Boolean)fieldObject);
                    break;
                }
                case INLINED_INT: {
                    Object fieldObject = unsafe.getObject(obj, this.fieldOffset);
                    if (fieldObject == null) break;
                    rec.setInt(this.fieldName, (Integer)fieldObject);
                    break;
                }
                case INLINED_SHORT: {
                    Object fieldObject = unsafe.getObject(obj, this.fieldOffset);
                    if (fieldObject == null) break;
                    rec.setInt(this.fieldName, ((Short)fieldObject).intValue());
                    break;
                }
                case INLINED_BYTE: {
                    Object fieldObject = unsafe.getObject(obj, this.fieldOffset);
                    if (fieldObject == null) break;
                    rec.setInt(this.fieldName, ((Byte)fieldObject).intValue());
                    break;
                }
                case INLINED_CHAR: {
                    Object fieldObject = unsafe.getObject(obj, this.fieldOffset);
                    if (fieldObject == null) break;
                    rec.setInt(this.fieldName, ((Character)fieldObject).charValue());
                    break;
                }
                case INLINED_LONG: {
                    Object fieldObject = unsafe.getObject(obj, this.fieldOffset);
                    if (fieldObject == null) break;
                    rec.setLong(this.fieldName, (Long)fieldObject);
                    break;
                }
                case INLINED_DOUBLE: {
                    Object fieldObject = unsafe.getObject(obj, this.fieldOffset);
                    if (fieldObject == null) break;
                    rec.setDouble(this.fieldName, (Double)fieldObject);
                    break;
                }
                case INLINED_FLOAT: {
                    Object fieldObject = unsafe.getObject(obj, this.fieldOffset);
                    if (fieldObject == null) break;
                    rec.setFloat(this.fieldName, ((Float)fieldObject).floatValue());
                    break;
                }
                case INLINED_STRING: {
                    Object fieldObject = unsafe.getObject(obj, this.fieldOffset);
                    if (fieldObject == null) break;
                    rec.setString(this.fieldName, (String)fieldObject);
                    break;
                }
                case NULLABLE_PRIMITIVE_BOOLEAN: {
                    Object fieldObject = unsafe.getObject(obj, this.fieldOffset);
                    if (fieldObject == null) break;
                    rec.setBoolean(this.fieldName, ((NullablePrimitiveBoolean)((Object)fieldObject)).getBooleanValue());
                    break;
                }
                case DATE_TIME: {
                    rec.setLong(this.fieldName, ((Date)obj).getTime());
                    break;
                }
                case ENUM_NAME: {
                    rec.setString(this.fieldName, ((Enum)obj).name());
                    break;
                }
                case REFERENCE: {
                    Object fieldObject = unsafe.getObject(obj, this.fieldOffset);
                    if (fieldObject == null) break;
                    if (flatRecordWriter == null) {
                        rec.setReference(this.fieldName, this.subTypeMapper.write(fieldObject));
                        break;
                    }
                    rec.setReference(this.fieldName, this.subTypeMapper.writeFlat(fieldObject, flatRecordWriter));
                }
            }
        }

        public void copy(Object pojo, GenericHollowObject rec) {
            switch (this.fieldType) {
                case BOOLEAN: {
                    unsafe.putBoolean(pojo, this.fieldOffset, rec.getBoolean(this.fieldName));
                    break;
                }
                case INT: {
                    int intValue = rec.getInt(this.fieldName);
                    unsafe.putInt(pojo, this.fieldOffset, intValue);
                    break;
                }
                case SHORT: {
                    int shortValue = rec.getInt(this.fieldName);
                    if (shortValue == Integer.MIN_VALUE) {
                        unsafe.putShort(pojo, this.fieldOffset, (short)Short.MIN_VALUE);
                        break;
                    }
                    unsafe.putShort(pojo, this.fieldOffset, (short)shortValue);
                    break;
                }
                case BYTE: {
                    int byteValue = rec.getInt(this.fieldName);
                    if (byteValue == Integer.MIN_VALUE) {
                        unsafe.putByte(pojo, this.fieldOffset, (byte)-128);
                        break;
                    }
                    unsafe.putByte(pojo, this.fieldOffset, (byte)byteValue);
                    break;
                }
                case CHAR: {
                    int charValue = rec.getInt(this.fieldName);
                    if (charValue == Integer.MIN_VALUE) {
                        unsafe.putChar(pojo, this.fieldOffset, '\u0000');
                        break;
                    }
                    unsafe.putChar(pojo, this.fieldOffset, (char)charValue);
                    break;
                }
                case LONG: {
                    long longValue = rec.getLong(this.fieldName);
                    unsafe.putLong(pojo, this.fieldOffset, longValue);
                    break;
                }
                case DOUBLE: {
                    double doubleValue = rec.getDouble(this.fieldName);
                    unsafe.putDouble(pojo, this.fieldOffset, doubleValue);
                    break;
                }
                case FLOAT: {
                    float floatValue = rec.getFloat(this.fieldName);
                    unsafe.putFloat(pojo, this.fieldOffset, floatValue);
                    break;
                }
                case STRING: {
                    unsafe.putObject(pojo, this.fieldOffset, rec.getString(this.fieldName));
                    break;
                }
                case BYTES: {
                    unsafe.putObject(pojo, this.fieldOffset, rec.getBytes(this.fieldName));
                    break;
                }
                case INLINED_BOOLEAN: {
                    if (rec.isNull(this.fieldName)) break;
                    unsafe.putObject(pojo, this.fieldOffset, rec.getBoolean(this.fieldName));
                    break;
                }
                case INLINED_INT: {
                    int inlinedIntValue = rec.getInt(this.fieldName);
                    if (inlinedIntValue == Integer.MIN_VALUE) break;
                    unsafe.putObject(pojo, this.fieldOffset, inlinedIntValue);
                    break;
                }
                case INLINED_SHORT: {
                    int inlinedShortValue = rec.getInt(this.fieldName);
                    if (inlinedShortValue == Integer.MIN_VALUE) break;
                    unsafe.putObject(pojo, this.fieldOffset, (short)inlinedShortValue);
                    break;
                }
                case INLINED_BYTE: {
                    int inlinedByteValue = rec.getInt(this.fieldName);
                    if (inlinedByteValue == Integer.MIN_VALUE) break;
                    unsafe.putObject(pojo, this.fieldOffset, (byte)inlinedByteValue);
                    break;
                }
                case INLINED_CHAR: {
                    int inlinedCharValue = rec.getInt(this.fieldName);
                    if (inlinedCharValue == Integer.MIN_VALUE) break;
                    unsafe.putObject(pojo, this.fieldOffset, Character.valueOf((char)inlinedCharValue));
                    break;
                }
                case INLINED_LONG: {
                    long inlinedLongValue = rec.getLong(this.fieldName);
                    if (inlinedLongValue == Long.MIN_VALUE) break;
                    unsafe.putObject(pojo, this.fieldOffset, inlinedLongValue);
                    break;
                }
                case INLINED_DOUBLE: {
                    double inlinedDoubleValue = rec.getDouble(this.fieldName);
                    if (Double.isNaN(inlinedDoubleValue)) break;
                    unsafe.putObject(pojo, this.fieldOffset, inlinedDoubleValue);
                    break;
                }
                case INLINED_FLOAT: {
                    float inlinedFloatValue = rec.getFloat(this.fieldName);
                    if (Float.isNaN(inlinedFloatValue)) break;
                    unsafe.putObject(pojo, this.fieldOffset, Float.valueOf(inlinedFloatValue));
                    break;
                }
                case INLINED_STRING: {
                    unsafe.putObject(pojo, this.fieldOffset, rec.getString(this.fieldName));
                    break;
                }
                case DATE_TIME: {
                    long dateValue = rec.getLong(this.fieldName);
                    if (dateValue == Long.MIN_VALUE) break;
                    unsafe.putObject(pojo, this.fieldOffset, new Date(dateValue));
                    break;
                }
                case ENUM_NAME: {
                    String enumNameValue = rec.getString(this.fieldName);
                    if (enumNameValue == null) break;
                    unsafe.putObject(pojo, this.fieldOffset, Enum.valueOf((Class)this.type, enumNameValue));
                    break;
                }
                case REFERENCE: {
                    HollowRecord fieldRecord = rec.getReferencedGenericRecord(this.fieldName);
                    if (fieldRecord == null) break;
                    unsafe.putObject(pojo, this.fieldOffset, this.subTypeMapper.parseHollowRecord(fieldRecord));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unexpected field type " + (Object)((Object)this.fieldType) + " for field " + this.fieldName);
                }
            }
        }

        private Object parseBoxedWrapper(GenericHollowObject record) {
            switch (this.fieldType) {
                case BOOLEAN: {
                    return record.getBoolean(this.fieldName);
                }
                case INT: {
                    int intValue = record.getInt(this.fieldName);
                    if (intValue == Integer.MIN_VALUE) {
                        return null;
                    }
                    return intValue;
                }
                case SHORT: {
                    int shortValue = record.getInt(this.fieldName);
                    if (shortValue == Integer.MIN_VALUE) {
                        return null;
                    }
                    return (short)shortValue;
                }
                case BYTE: {
                    int byteValue = record.getInt(this.fieldName);
                    if (byteValue == Integer.MIN_VALUE) {
                        return null;
                    }
                    return (byte)byteValue;
                }
                case CHAR: {
                    int charValue = record.getInt(this.fieldName);
                    if (charValue == Integer.MIN_VALUE) {
                        return null;
                    }
                    return Character.valueOf((char)charValue);
                }
                case LONG: {
                    long longValue = record.getLong(this.fieldName);
                    if (longValue == Long.MIN_VALUE) {
                        return null;
                    }
                    return longValue;
                }
                case FLOAT: {
                    float floatValue = record.getFloat(this.fieldName);
                    if (Float.isNaN(floatValue)) {
                        return null;
                    }
                    return Float.valueOf(floatValue);
                }
                case DOUBLE: {
                    double doubleValue = record.getDouble(this.fieldName);
                    if (Double.isNaN(doubleValue)) {
                        return null;
                    }
                    return doubleValue;
                }
                case STRING: {
                    return record.getString(this.fieldName);
                }
                case BYTES: {
                    return record.getBytes(this.fieldName);
                }
                case ENUM_NAME: {
                    String enumName = record.getString(this.fieldName);
                    if (enumName == null) {
                        return null;
                    }
                    return Enum.valueOf(HollowObjectTypeMapper.this.clazz, enumName);
                }
                case DATE_TIME: {
                    long dateValue = record.getLong(this.fieldName);
                    if (dateValue == Long.MIN_VALUE) {
                        return null;
                    }
                    return new Date(dateValue);
                }
            }
            throw new IllegalArgumentException("Unexpected field type " + (Object)((Object)this.fieldType) + " for field " + this.fieldName);
        }

        private Object parseBoxedWrapper(FlatRecordTraversalObjectNode record) {
            switch (this.fieldType) {
                case BOOLEAN: {
                    return record.getFieldValueBooleanBoxed(this.fieldName);
                }
                case INT: {
                    return record.getFieldValueIntBoxed(this.fieldName);
                }
                case SHORT: {
                    int shortValue = record.getFieldValueInt(this.fieldName);
                    if (shortValue == Integer.MIN_VALUE) {
                        return null;
                    }
                    return (short)shortValue;
                }
                case BYTE: {
                    int byteValue = record.getFieldValueInt(this.fieldName);
                    if (byteValue == Integer.MIN_VALUE) {
                        return null;
                    }
                    return (byte)byteValue;
                }
                case CHAR: {
                    int charValue = record.getFieldValueInt(this.fieldName);
                    if (charValue == Integer.MIN_VALUE) {
                        return null;
                    }
                    return Character.valueOf((char)charValue);
                }
                case LONG: {
                    return record.getFieldValueLongBoxed(this.fieldName);
                }
                case FLOAT: {
                    return record.getFieldValueFloatBoxed(this.fieldName);
                }
                case DOUBLE: {
                    return record.getFieldValueDoubleBoxed(this.fieldName);
                }
                case STRING: {
                    return record.getFieldValueString(this.fieldName);
                }
                case BYTES: {
                    return record.getFieldValueBytes(this.fieldName);
                }
                case ENUM_NAME: {
                    String enumName = record.getFieldValueString(this.fieldName);
                    if (enumName == null) {
                        return null;
                    }
                    return Enum.valueOf(HollowObjectTypeMapper.this.clazz, enumName);
                }
                case DATE_TIME: {
                    long dateValue = record.getFieldValueLong(this.fieldName);
                    if (dateValue == Long.MIN_VALUE) {
                        return null;
                    }
                    return new Date(dateValue);
                }
            }
            throw new IllegalArgumentException("Unexpected field type " + (Object)((Object)this.fieldType) + " for field " + this.fieldName);
        }

        private void copy(Object obj, FlatRecordTraversalObjectNode node) {
            switch (this.fieldType) {
                case BOOLEAN: {
                    Boolean value = node.getFieldValueBooleanBoxed(this.fieldName);
                    if (value == null) break;
                    unsafe.putBoolean(obj, this.fieldOffset, value == Boolean.TRUE);
                    break;
                }
                case INT: {
                    int value = node.getFieldValueInt(this.fieldName);
                    unsafe.putInt(obj, this.fieldOffset, value);
                    break;
                }
                case SHORT: {
                    int value = node.getFieldValueInt(this.fieldName);
                    if (value == Integer.MIN_VALUE) {
                        unsafe.putShort(obj, this.fieldOffset, (short)Short.MIN_VALUE);
                        break;
                    }
                    unsafe.putShort(obj, this.fieldOffset, (short)value);
                    break;
                }
                case BYTE: {
                    int value = node.getFieldValueInt(this.fieldName);
                    if (value == Integer.MIN_VALUE) {
                        unsafe.putByte(obj, this.fieldOffset, (byte)-128);
                        break;
                    }
                    unsafe.putByte(obj, this.fieldOffset, (byte)value);
                    break;
                }
                case CHAR: {
                    int value = node.getFieldValueInt(this.fieldName);
                    if (value == Integer.MIN_VALUE) {
                        unsafe.putChar(obj, this.fieldOffset, '\u0000');
                        break;
                    }
                    unsafe.putChar(obj, this.fieldOffset, (char)value);
                    break;
                }
                case LONG: {
                    long value = node.getFieldValueLong(this.fieldName);
                    unsafe.putLong(obj, this.fieldOffset, value);
                    break;
                }
                case FLOAT: {
                    float value = node.getFieldValueFloat(this.fieldName);
                    unsafe.putFloat(obj, this.fieldOffset, value);
                    break;
                }
                case DOUBLE: {
                    double value = node.getFieldValueDouble(this.fieldName);
                    unsafe.putDouble(obj, this.fieldOffset, value);
                    break;
                }
                case STRING: {
                    String value = node.getFieldValueString(this.fieldName);
                    if (value == null) break;
                    unsafe.putObject(obj, this.fieldOffset, value);
                    break;
                }
                case BYTES: {
                    byte[] value = node.getFieldValueBytes(this.fieldName);
                    if (value == null) break;
                    unsafe.putObject(obj, this.fieldOffset, value);
                    break;
                }
                case INLINED_BOOLEAN: {
                    Boolean value = node.getFieldValueBooleanBoxed(this.fieldName);
                    if (value == null) break;
                    unsafe.putObject(obj, this.fieldOffset, value);
                    break;
                }
                case INLINED_INT: {
                    int value = node.getFieldValueInt(this.fieldName);
                    if (value == Integer.MIN_VALUE) break;
                    unsafe.putObject(obj, this.fieldOffset, value);
                    break;
                }
                case INLINED_SHORT: {
                    int value = node.getFieldValueInt(this.fieldName);
                    if (value == Integer.MIN_VALUE) break;
                    unsafe.putObject(obj, this.fieldOffset, (short)value);
                    break;
                }
                case INLINED_BYTE: {
                    int value = node.getFieldValueInt(this.fieldName);
                    if (value == Integer.MIN_VALUE) break;
                    unsafe.putObject(obj, this.fieldOffset, (byte)value);
                    break;
                }
                case INLINED_CHAR: {
                    int value = node.getFieldValueInt(this.fieldName);
                    if (value == Integer.MIN_VALUE) break;
                    unsafe.putObject(obj, this.fieldOffset, Character.valueOf((char)value));
                    break;
                }
                case INLINED_LONG: {
                    long value = node.getFieldValueLong(this.fieldName);
                    if (value == Long.MIN_VALUE) break;
                    unsafe.putObject(obj, this.fieldOffset, value);
                    break;
                }
                case INLINED_FLOAT: {
                    float value = node.getFieldValueFloat(this.fieldName);
                    if (Float.isNaN(value)) break;
                    unsafe.putObject(obj, this.fieldOffset, Float.valueOf(value));
                    break;
                }
                case INLINED_DOUBLE: {
                    double value = node.getFieldValueDouble(this.fieldName);
                    if (Double.isNaN(value)) break;
                    unsafe.putObject(obj, this.fieldOffset, value);
                    break;
                }
                case INLINED_STRING: {
                    String value = node.getFieldValueString(this.fieldName);
                    if (value == null) break;
                    unsafe.putObject(obj, this.fieldOffset, value);
                    break;
                }
                case DATE_TIME: {
                    long value = node.getFieldValueLong(this.fieldName);
                    if (value == Long.MIN_VALUE) break;
                    unsafe.putObject(obj, this.fieldOffset, new Date(value));
                    break;
                }
                case ENUM_NAME: {
                    String value = node.getFieldValueString(this.fieldName);
                    if (value == null) break;
                    unsafe.putObject(obj, this.fieldOffset, Enum.valueOf((Class)this.type, value));
                    break;
                }
                case REFERENCE: {
                    FlatRecordTraversalNode childNode = node.getFieldNode(this.fieldName);
                    if (childNode == null) break;
                    unsafe.putObject(obj, this.fieldOffset, this.subTypeMapper.parseFlatRecord(childNode));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown field type: " + (Object)((Object)this.fieldType));
                }
            }
        }

        public Object retrieveFieldValue(Object obj, int[] fieldPathIdx, int idx) {
            if (idx < fieldPathIdx.length - 1) {
                if (this.fieldType != MappedFieldType.REFERENCE) {
                    throw new IllegalArgumentException("Expected REFERENCE mapped field type but found " + (Object)((Object)this.fieldType));
                }
                Object fieldObject = unsafe.getObject(obj, this.fieldOffset);
                if (fieldObject == null) {
                    return null;
                }
                return ((HollowObjectTypeMapper)this.subTypeMapper).retrieveFieldValue(fieldObject, fieldPathIdx, idx + 1);
            }
            switch (this.fieldType) {
                case BOOLEAN: {
                    return unsafe.getBoolean(obj, this.fieldOffset);
                }
                case INT: {
                    return unsafe.getInt(obj, this.fieldOffset);
                }
                case SHORT: {
                    return (int)unsafe.getShort(obj, this.fieldOffset);
                }
                case BYTE: {
                    return (int)unsafe.getByte(obj, this.fieldOffset);
                }
                case CHAR: {
                    return (int)unsafe.getChar(obj, this.fieldOffset);
                }
                case LONG: {
                    return unsafe.getLong(obj, this.fieldOffset);
                }
                case DOUBLE: {
                    double d = unsafe.getDouble(obj, this.fieldOffset);
                    if (Double.isNaN(d)) {
                        return null;
                    }
                    return d;
                }
                case FLOAT: {
                    float f = unsafe.getFloat(obj, this.fieldOffset);
                    if (Float.isNaN(f)) {
                        return null;
                    }
                    return Float.valueOf(f);
                }
                case STRING: {
                    Object fieldObject = unsafe.getObject(obj, this.fieldOffset);
                    return fieldObject == null ? null : this.getStringFromField(obj, fieldObject);
                }
                case BYTES: {
                    Object fieldObject = unsafe.getObject(obj, this.fieldOffset);
                    return fieldObject == null ? null : (byte[])fieldObject;
                }
                case INLINED_BOOLEAN: 
                case INLINED_INT: 
                case INLINED_LONG: 
                case INLINED_DOUBLE: 
                case INLINED_FLOAT: 
                case INLINED_STRING: {
                    return unsafe.getObject(obj, this.fieldOffset);
                }
                case INLINED_SHORT: {
                    Object fieldObject = unsafe.getObject(obj, this.fieldOffset);
                    return fieldObject == null ? null : Integer.valueOf(((Short)fieldObject).shortValue());
                }
                case INLINED_BYTE: {
                    Object fieldObject = unsafe.getObject(obj, this.fieldOffset);
                    return fieldObject == null ? null : Integer.valueOf(((Byte)fieldObject).byteValue());
                }
                case INLINED_CHAR: {
                    Object fieldObject = unsafe.getObject(obj, this.fieldOffset);
                    return fieldObject == null ? null : Integer.valueOf(((Character)fieldObject).charValue());
                }
                case NULLABLE_PRIMITIVE_BOOLEAN: {
                    Object fieldObject = unsafe.getObject(obj, this.fieldOffset);
                    return fieldObject == null ? null : Boolean.valueOf(((NullablePrimitiveBoolean)((Object)fieldObject)).getBooleanValue());
                }
                case DATE_TIME: {
                    return ((Date)obj).getTime();
                }
                case ENUM_NAME: {
                    return String.valueOf(((Enum)obj).name());
                }
            }
            throw new IllegalArgumentException("Cannot extract POJO primary key from a " + (Object)((Object)this.fieldType) + " mapped field type");
        }

        private String getStringFromField(Object obj, Object fieldObject) {
            if (obj instanceof String) {
                return (String)obj;
            }
            if (fieldObject instanceof char[]) {
                return new String((char[])fieldObject);
            }
            throw new IllegalArgumentException("Expected char[] or String value container for STRING.");
        }
    }
}

