/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.core.write.objectmapper;

import com.netflix.hollow.api.objects.HollowRecord;
import com.netflix.hollow.api.objects.generic.GenericHollowMap;
import com.netflix.hollow.core.schema.HollowMapSchema;
import com.netflix.hollow.core.util.HollowObjectHashCodeFinder;
import com.netflix.hollow.core.write.HollowMapTypeWriteState;
import com.netflix.hollow.core.write.HollowMapWriteRecord;
import com.netflix.hollow.core.write.HollowTypeWriteState;
import com.netflix.hollow.core.write.HollowWriteRecord;
import com.netflix.hollow.core.write.HollowWriteStateEngine;
import com.netflix.hollow.core.write.objectmapper.HollowObjectMapper;
import com.netflix.hollow.core.write.objectmapper.HollowObjectTypeMapper;
import com.netflix.hollow.core.write.objectmapper.HollowTypeMapper;
import com.netflix.hollow.core.write.objectmapper.MemoizedMap;
import com.netflix.hollow.core.write.objectmapper.flatrecords.FlatRecordWriter;
import com.netflix.hollow.core.write.objectmapper.flatrecords.traversal.FlatRecordTraversalMapNode;
import com.netflix.hollow.core.write.objectmapper.flatrecords.traversal.FlatRecordTraversalNode;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class HollowMapTypeMapper
extends HollowTypeMapper {
    private static final String NULL_KEY_MESSAGE = "Null key contained in instance of a Map with schema \"%s\". Maps cannot contain null keys or values";
    private static final String NULL_VALUE_MESSAGE = "Null value contained in instance of a Map with schema \"%s\". Maps cannot contain null keys or values";
    private final HollowMapSchema schema;
    private final HollowMapTypeWriteState writeState;
    private final HollowObjectHashCodeFinder hashCodeFinder;
    private HollowTypeMapper keyMapper;
    private HollowTypeMapper valueMapper;

    public HollowMapTypeMapper(HollowObjectMapper parentMapper, ParameterizedType type, String declaredName, String[] hashKeyFieldPaths, int numShards, HollowWriteStateEngine stateEngine, boolean useDefaultHashKeys, Set<Type> visited) {
        String typeName;
        this.keyMapper = parentMapper.getTypeMapper(type.getActualTypeArguments()[0], null, null, -1, visited);
        this.valueMapper = parentMapper.getTypeMapper(type.getActualTypeArguments()[1], null, null, -1, visited);
        String string = typeName = declaredName != null ? declaredName : HollowMapTypeMapper.getDefaultTypeName(type);
        if (hashKeyFieldPaths == null && useDefaultHashKeys && this.keyMapper instanceof HollowObjectTypeMapper) {
            hashKeyFieldPaths = ((HollowObjectTypeMapper)this.keyMapper).getDefaultElementHashKey();
        }
        this.schema = new HollowMapSchema(typeName, this.keyMapper.getTypeName(), this.valueMapper.getTypeName(), hashKeyFieldPaths);
        this.hashCodeFinder = stateEngine.getHashCodeFinder();
        HollowMapTypeWriteState typeState = (HollowMapTypeWriteState)parentMapper.getStateEngine().getTypeState(typeName);
        this.writeState = typeState != null ? typeState : new HollowMapTypeWriteState(this.schema, numShards);
    }

    @Override
    protected String getTypeName() {
        return this.schema.getName();
    }

    @Override
    protected int write(Object obj) {
        long assignedOrdinal;
        if (obj instanceof MemoizedMap && ((assignedOrdinal = ((MemoizedMap)obj).__assigned_ordinal) & 0xFFFFFFFF00000000L) == this.cycleSpecificAssignedOrdinalBits()) {
            return (int)assignedOrdinal & Integer.MAX_VALUE;
        }
        Map m = (Map)obj;
        HollowMapWriteRecord rec = this.copyToWriteRecord(m, null);
        int assignedOrdinal2 = this.writeState.add(rec);
        if (obj instanceof MemoizedMap) {
            ((MemoizedMap)obj).__assigned_ordinal = (long)assignedOrdinal2 | this.cycleSpecificAssignedOrdinalBits();
        }
        return assignedOrdinal2;
    }

    @Override
    protected int writeFlat(Object obj, FlatRecordWriter flatRecordWriter) {
        HollowMapWriteRecord rec = this.copyToWriteRecord((Map)obj, flatRecordWriter);
        return flatRecordWriter.write(this.schema, rec);
    }

    private HollowMapWriteRecord copyToWriteRecord(Map<?, ?> m, FlatRecordWriter flatRecordWriter) {
        HollowMapWriteRecord rec = (HollowMapWriteRecord)this.writeRecord();
        for (Map.Entry<?, ?> entry : m.entrySet()) {
            int valueOrdinal;
            int keyOrdinal;
            Object key = entry.getKey();
            if (key == null) {
                throw new NullPointerException(String.format(NULL_KEY_MESSAGE, this.schema));
            }
            Object value = entry.getValue();
            if (value == null) {
                throw new NullPointerException(String.format(NULL_VALUE_MESSAGE, this.schema));
            }
            if (flatRecordWriter == null) {
                keyOrdinal = this.keyMapper.write(key);
                valueOrdinal = this.valueMapper.write(value);
            } else {
                keyOrdinal = this.keyMapper.writeFlat(key, flatRecordWriter);
                valueOrdinal = this.valueMapper.writeFlat(value, flatRecordWriter);
            }
            int hashCode = this.hashCodeFinder.hashCode(this.keyMapper.getTypeName(), keyOrdinal, key);
            rec.addEntry(keyOrdinal, valueOrdinal, hashCode);
        }
        return rec;
    }

    @Override
    protected Object parseHollowRecord(HollowRecord record) {
        GenericHollowMap hollowMap = (GenericHollowMap)record;
        HashMap<Object, Object> m = new HashMap<Object, Object>();
        for (Map.Entry entry : hollowMap.entries()) {
            Object key = this.keyMapper.parseHollowRecord((HollowRecord)entry.getKey());
            Object value = this.valueMapper.parseHollowRecord((HollowRecord)entry.getValue());
            m.put(key, value);
        }
        return m;
    }

    @Override
    protected Object parseFlatRecord(FlatRecordTraversalNode node) {
        FlatRecordTraversalMapNode mapNode = (FlatRecordTraversalMapNode)node;
        HashMap<Object, Object> collection = new HashMap<Object, Object>();
        for (Map.Entry<FlatRecordTraversalNode, FlatRecordTraversalNode> entry : mapNode.entrySet()) {
            Object key = this.keyMapper.parseFlatRecord(entry.getKey());
            Object value = this.valueMapper.parseFlatRecord(entry.getValue());
            collection.put(key, value);
        }
        return collection;
    }

    @Override
    protected HollowWriteRecord newWriteRecord() {
        return new HollowMapWriteRecord();
    }

    @Override
    protected HollowTypeWriteState getTypeWriteState() {
        return this.writeState;
    }
}

