/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.core.write;

import com.netflix.hollow.api.producer.ProducerOptionalBlobPartConfig;
import com.netflix.hollow.core.HollowBlobHeader;
import com.netflix.hollow.core.HollowBlobOptionalPartHeader;
import com.netflix.hollow.core.memory.encoding.VarInt;
import com.netflix.hollow.core.schema.HollowSchema;
import com.netflix.hollow.core.util.SimultaneousExecutor;
import com.netflix.hollow.core.write.HollowBlobHeaderWriter;
import com.netflix.hollow.core.write.HollowTypeWriteState;
import com.netflix.hollow.core.write.HollowWriteStateEngine;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class HollowBlobWriter {
    private final HollowWriteStateEngine stateEngine;
    private final HollowBlobHeaderWriter headerWriter;

    public HollowBlobWriter(HollowWriteStateEngine stateEngine) {
        this.stateEngine = stateEngine;
        this.headerWriter = new HollowBlobHeaderWriter();
    }

    public void writeSnapshot(OutputStream os) throws IOException {
        this.writeSnapshot(os, null);
    }

    public void writeHeader(OutputStream os, ProducerOptionalBlobPartConfig.OptionalBlobPartOutputStreams partStreams) throws IOException {
        this.stateEngine.prepareForWrite();
        DataOutputStream dos = new DataOutputStream(os);
        HollowBlobHeaderWrapper hollowBlobHeaderWrapper = this.buildHeader(partStreams, this.stateEngine.getSchemas(), false);
        this.writeHeaders(dos, partStreams, false, hollowBlobHeaderWrapper);
        os.flush();
        if (partStreams != null) {
            partStreams.flush();
        }
    }

    public void writeSnapshot(OutputStream os, ProducerOptionalBlobPartConfig.OptionalBlobPartOutputStreams partStreams) throws IOException {
        Map<Object, Object> partStreamsByType = Collections.emptyMap();
        if (partStreams != null) {
            partStreamsByType = partStreams.getStreamsByType();
        }
        this.stateEngine.prepareForWrite();
        DataOutputStream dos = new DataOutputStream(os);
        HollowBlobHeaderWrapper hollowBlobHeaderWrapper = this.buildHeader(partStreams, this.stateEngine.getSchemas(), false);
        this.writeHeaders(dos, partStreams, false, hollowBlobHeaderWrapper);
        SimultaneousExecutor executor = new SimultaneousExecutor(this.getClass(), "write-snapshot");
        for (final HollowTypeWriteState typeState : this.stateEngine.getOrderedTypeStates()) {
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    typeState.calculateSnapshot();
                }
            });
        }
        try {
            executor.awaitSuccessfulCompletion();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        for (final HollowTypeWriteState typeState : this.stateEngine.getOrderedTypeStates()) {
            DataOutputStream partStream = (DataOutputStream)partStreamsByType.get(typeState.getSchema().getName());
            if (partStream == null) {
                partStream = dos;
            }
            HollowSchema schema = typeState.getSchema();
            schema.writeTo(partStream);
            this.writeNumShards(partStream, typeState.getNumShards());
            typeState.writeSnapshot(partStream);
        }
        os.flush();
        if (partStreams != null) {
            partStreams.flush();
        }
    }

    public void writeDelta(OutputStream os) throws IOException {
        this.writeDelta(os, null);
    }

    public void writeDelta(OutputStream os, ProducerOptionalBlobPartConfig.OptionalBlobPartOutputStreams partStreams) throws IOException {
        Map<Object, Object> partStreamsByType = Collections.emptyMap();
        if (partStreams != null) {
            partStreamsByType = partStreams.getStreamsByType();
        }
        this.stateEngine.prepareForWrite();
        if (this.stateEngine.isRestored()) {
            this.stateEngine.ensureAllNecessaryStatesRestored();
        }
        List<HollowSchema> changedTypes = this.changedTypes();
        DataOutputStream dos = new DataOutputStream(os);
        HollowBlobHeaderWrapper hollowBlobHeaderWrapper = this.buildHeader(partStreams, changedTypes, false);
        this.writeHeaders(dos, partStreams, false, hollowBlobHeaderWrapper);
        SimultaneousExecutor executor = new SimultaneousExecutor(this.getClass(), "write-delta");
        for (final HollowTypeWriteState typeState : this.stateEngine.getOrderedTypeStates()) {
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    if (typeState.hasChangedSinceLastCycle()) {
                        typeState.calculateDelta();
                    }
                }
            });
        }
        try {
            executor.awaitSuccessfulCompletion();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        for (final HollowTypeWriteState typeState : this.stateEngine.getOrderedTypeStates()) {
            if (!typeState.hasChangedSinceLastCycle()) continue;
            DataOutputStream partStream = (DataOutputStream)partStreamsByType.get(typeState.getSchema().getName());
            if (partStream == null) {
                partStream = dos;
            }
            HollowSchema schema = typeState.getSchema();
            schema.writeTo(partStream);
            this.writeNumShards(partStream, typeState.getNumShards());
            typeState.writeDelta(partStream);
        }
        os.flush();
        if (partStreams != null) {
            partStreams.flush();
        }
    }

    public void writeReverseDelta(OutputStream os) throws IOException {
        this.writeReverseDelta(os, null);
    }

    public void writeReverseDelta(OutputStream os, ProducerOptionalBlobPartConfig.OptionalBlobPartOutputStreams partStreams) throws IOException {
        Map<Object, Object> partStreamsByType = Collections.emptyMap();
        if (partStreams != null) {
            partStreamsByType = partStreams.getStreamsByType();
        }
        this.stateEngine.prepareForWrite();
        if (this.stateEngine.isRestored()) {
            this.stateEngine.ensureAllNecessaryStatesRestored();
        }
        List<HollowSchema> changedTypes = this.changedTypes();
        DataOutputStream dos = new DataOutputStream(os);
        HollowBlobHeaderWrapper hollowBlobHeaderWrapper = this.buildHeader(partStreams, changedTypes, true);
        this.writeHeaders(dos, partStreams, true, hollowBlobHeaderWrapper);
        SimultaneousExecutor executor = new SimultaneousExecutor(this.getClass(), "write-reverse-delta");
        for (final HollowTypeWriteState typeState : this.stateEngine.getOrderedTypeStates()) {
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    if (typeState.hasChangedSinceLastCycle()) {
                        typeState.calculateReverseDelta();
                    }
                }
            });
        }
        try {
            executor.awaitSuccessfulCompletion();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        for (final HollowTypeWriteState typeState : this.stateEngine.getOrderedTypeStates()) {
            if (!typeState.hasChangedSinceLastCycle()) continue;
            DataOutputStream partStream = (DataOutputStream)partStreamsByType.get(typeState.getSchema().getName());
            if (partStream == null) {
                partStream = dos;
            }
            HollowSchema schema = typeState.getSchema();
            schema.writeTo(partStream);
            this.writeNumShards(partStream, typeState.getRevNumShards());
            typeState.writeReverseDelta(partStream);
        }
        os.flush();
        if (partStreams != null) {
            partStreams.flush();
        }
    }

    private List<HollowSchema> changedTypes() {
        ArrayList<HollowSchema> changedTypes = new ArrayList<HollowSchema>();
        List<HollowTypeWriteState> orderedTypeStates = this.stateEngine.getOrderedTypeStates();
        for (int i = 0; i < orderedTypeStates.size(); ++i) {
            HollowTypeWriteState writeState = orderedTypeStates.get(i);
            if (!writeState.hasChangedSinceLastCycle()) continue;
            changedTypes.add(writeState.getSchema());
        }
        return changedTypes;
    }

    private void writeNumShards(DataOutputStream dos, int numShards) throws IOException {
        VarInt.writeVInt(dos, 1 + VarInt.sizeOfVInt(numShards));
        VarInt.writeVInt(dos, 0);
        VarInt.writeVInt(dos, numShards);
    }

    public HollowBlobHeaderWrapper buildHeader(ProducerOptionalBlobPartConfig.OptionalBlobPartOutputStreams partStreams, List<HollowSchema> schemasToInclude, boolean isReverseDelta) {
        HollowBlobHeader header = new HollowBlobHeader();
        List<HollowSchema> mainSchemas = schemasToInclude;
        Map<String, List<HollowSchema>> schemasByPartName = Collections.emptyMap();
        if (partStreams != null) {
            mainSchemas = new ArrayList<HollowSchema>();
            Map<String, String> partNameByType = partStreams.getPartNameByType();
            schemasByPartName = new HashMap();
            for (HollowSchema schema : schemasToInclude) {
                String partName = partNameByType.get(schema.getName());
                if (partName == null) {
                    mainSchemas.add(schema);
                    continue;
                }
                List partSchemas = schemasByPartName.computeIfAbsent(partName, n -> new ArrayList());
                partSchemas.add(schema);
            }
        }
        if (isReverseDelta) {
            header.setHeaderTags(this.stateEngine.getPreviousHeaderTags());
            header.setOriginRandomizedTag(this.stateEngine.getNextStateRandomizedTag());
            header.setDestinationRandomizedTag(this.stateEngine.getPreviousStateRandomizedTag());
        } else {
            header.setHeaderTags(this.stateEngine.getHeaderTags());
            header.setOriginRandomizedTag(this.stateEngine.getPreviousStateRandomizedTag());
            header.setDestinationRandomizedTag(this.stateEngine.getNextStateRandomizedTag());
        }
        header.setSchemas(mainSchemas);
        return new HollowBlobHeaderWrapper(header, schemasByPartName);
    }

    private void writeHeaders(DataOutputStream os, ProducerOptionalBlobPartConfig.OptionalBlobPartOutputStreams partStreams, boolean isReverseDelta, HollowBlobHeaderWrapper hollowBlobHeaderWrapper) throws IOException {
        this.headerWriter.writeHeader(hollowBlobHeaderWrapper.header, os);
        VarInt.writeVInt(os, hollowBlobHeaderWrapper.header.getSchemas().size());
        if (partStreams != null) {
            for (Map.Entry<String, ProducerOptionalBlobPartConfig.ConfiguredOutputStream> entry : partStreams.getPartStreams().entrySet()) {
                String partName = entry.getKey();
                HollowBlobOptionalPartHeader partHeader = new HollowBlobOptionalPartHeader(partName);
                if (isReverseDelta) {
                    partHeader.setOriginRandomizedTag(this.stateEngine.getNextStateRandomizedTag());
                    partHeader.setDestinationRandomizedTag(this.stateEngine.getPreviousStateRandomizedTag());
                } else {
                    partHeader.setOriginRandomizedTag(this.stateEngine.getPreviousStateRandomizedTag());
                    partHeader.setDestinationRandomizedTag(this.stateEngine.getNextStateRandomizedTag());
                }
                List<HollowSchema> partSchemas = (List<HollowSchema>)hollowBlobHeaderWrapper.schemasByPartName.get(partName);
                if (partSchemas == null) {
                    partSchemas = Collections.emptyList();
                }
                partHeader.setSchemas(partSchemas);
                this.headerWriter.writePartHeader(partHeader, entry.getValue().getStream());
                VarInt.writeVInt(entry.getValue().getStream(), partSchemas.size());
            }
        }
    }

    private static class HollowBlobHeaderWrapper {
        private final HollowBlobHeader header;
        private final Map<String, List<HollowSchema>> schemasByPartName;

        HollowBlobHeaderWrapper(HollowBlobHeader header, Map<String, List<HollowSchema>> schemasByPartName) {
            this.header = header;
            this.schemasByPartName = schemasByPartName;
        }
    }
}

