/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.core.util;

import java.util.AbstractCollection;
import java.util.BitSet;
import java.util.Iterator;

public abstract class HollowRecordCollection<T>
extends AbstractCollection<T> {
    private final BitSet populatedOrdinals;

    public HollowRecordCollection(BitSet populatedOrdinals) {
        this.populatedOrdinals = populatedOrdinals;
    }

    @Override
    public Iterator<T> iterator() {
        return new Iterator<T>(){
            private int ordinal;
            {
                this.ordinal = HollowRecordCollection.this.populatedOrdinals.nextSetBit(0);
            }

            @Override
            public boolean hasNext() {
                return this.ordinal != -1;
            }

            @Override
            public T next() {
                Object t = HollowRecordCollection.this.getForOrdinal(this.ordinal);
                this.ordinal = HollowRecordCollection.this.populatedOrdinals.nextSetBit(this.ordinal + 1);
                return t;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public int size() {
        return this.populatedOrdinals.cardinality();
    }

    protected abstract T getForOrdinal(int var1);
}

