/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.core.type.delegate;

import com.netflix.hollow.api.custom.HollowTypeAPI;
import com.netflix.hollow.api.objects.delegate.HollowCachedDelegate;
import com.netflix.hollow.api.objects.delegate.HollowObjectAbstractDelegate;
import com.netflix.hollow.core.read.dataaccess.HollowObjectTypeDataAccess;
import com.netflix.hollow.core.schema.HollowObjectSchema;
import com.netflix.hollow.core.type.LongTypeAPI;
import com.netflix.hollow.core.type.delegate.LongDelegate;

public class LongDelegateCachedImpl
extends HollowObjectAbstractDelegate
implements HollowCachedDelegate,
LongDelegate {
    private final Long value;
    private LongTypeAPI typeAPI;

    public LongDelegateCachedImpl(LongTypeAPI typeAPI, int ordinal) {
        this.value = typeAPI.getValueBoxed(ordinal);
        this.typeAPI = typeAPI;
    }

    @Override
    public long getValue(int ordinal) {
        if (this.value == null) {
            return Long.MIN_VALUE;
        }
        return this.value;
    }

    @Override
    public Long getValueBoxed(int ordinal) {
        return this.value;
    }

    @Override
    public HollowObjectSchema getSchema() {
        return this.typeAPI.getTypeDataAccess().getSchema();
    }

    @Override
    public HollowObjectTypeDataAccess getTypeDataAccess() {
        return this.typeAPI.getTypeDataAccess();
    }

    @Override
    public LongTypeAPI getTypeAPI() {
        return this.typeAPI;
    }

    @Override
    public void updateTypeAPI(HollowTypeAPI typeAPI) {
        this.typeAPI = (LongTypeAPI)typeAPI;
    }
}

