/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.core.type.delegate;

import com.netflix.hollow.api.custom.HollowTypeAPI;
import com.netflix.hollow.api.objects.delegate.HollowCachedDelegate;
import com.netflix.hollow.api.objects.delegate.HollowObjectAbstractDelegate;
import com.netflix.hollow.core.read.dataaccess.HollowObjectTypeDataAccess;
import com.netflix.hollow.core.schema.HollowObjectSchema;
import com.netflix.hollow.core.type.IntegerTypeAPI;
import com.netflix.hollow.core.type.delegate.IntegerDelegate;

public class IntegerDelegateCachedImpl
extends HollowObjectAbstractDelegate
implements HollowCachedDelegate,
IntegerDelegate {
    private final Integer value;
    private IntegerTypeAPI typeAPI;

    public IntegerDelegateCachedImpl(IntegerTypeAPI typeAPI, int ordinal) {
        this.value = typeAPI.getValueBoxed(ordinal);
        this.typeAPI = typeAPI;
    }

    @Override
    public int getValue(int ordinal) {
        if (this.value == null) {
            return Integer.MIN_VALUE;
        }
        return this.value;
    }

    @Override
    public Integer getValueBoxed(int ordinal) {
        return this.value;
    }

    @Override
    public HollowObjectSchema getSchema() {
        return this.typeAPI.getTypeDataAccess().getSchema();
    }

    @Override
    public HollowObjectTypeDataAccess getTypeDataAccess() {
        return this.typeAPI.getTypeDataAccess();
    }

    @Override
    public IntegerTypeAPI getTypeAPI() {
        return this.typeAPI;
    }

    @Override
    public void updateTypeAPI(HollowTypeAPI typeAPI) {
        this.typeAPI = (IntegerTypeAPI)typeAPI;
    }
}

