/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.core.schema;

import com.netflix.hollow.api.error.SchemaNotFoundException;
import com.netflix.hollow.core.HollowDataset;
import com.netflix.hollow.core.schema.HollowSchema;
import com.netflix.hollow.core.write.HollowWriteStateEngine;
import com.netflix.hollow.core.write.objectmapper.HollowObjectMapper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SimpleHollowDataset
implements HollowDataset {
    private final Map<String, HollowSchema> schemas;

    public SimpleHollowDataset(Map<String, HollowSchema> schemas) {
        this.schemas = schemas;
    }

    public SimpleHollowDataset(List<HollowSchema> schemas) {
        HashMap<String, HollowSchema> schemaMap = new HashMap<String, HollowSchema>(schemas.size());
        for (HollowSchema schema : schemas) {
            schemaMap.put(schema.getName(), schema);
        }
        this.schemas = schemaMap;
    }

    @Override
    public List<HollowSchema> getSchemas() {
        return new ArrayList<HollowSchema>(this.schemas.values());
    }

    @Override
    public HollowSchema getSchema(String typeName) {
        return this.schemas.get(typeName);
    }

    @Override
    public HollowSchema getNonNullSchema(String typeName) throws SchemaNotFoundException {
        HollowSchema schema = this.getSchema(typeName);
        if (schema == null) {
            throw new SchemaNotFoundException(typeName, this.schemas.keySet());
        }
        return schema;
    }

    public static SimpleHollowDataset fromClassDefinitions(Class<?> ... classes) {
        HollowWriteStateEngine stateEngine = new HollowWriteStateEngine();
        HollowObjectMapper mapper = new HollowObjectMapper(stateEngine);
        for (Class<?> clazz : classes) {
            mapper.initializeTypeState(clazz);
        }
        return new SimpleHollowDataset(stateEngine.getSchemas());
    }
}

