/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.core.schema;

import com.netflix.hollow.core.HollowStateEngine;
import com.netflix.hollow.core.memory.encoding.HashCodes;
import com.netflix.hollow.core.schema.HollowSchema;
import java.util.Collection;
import java.util.Objects;
import java.util.TreeMap;

public class HollowSchemaHash {
    private final String hash;

    public HollowSchemaHash(String hash) {
        this.hash = hash;
    }

    public HollowSchemaHash(HollowStateEngine stateEngine) {
        this(stateEngine.getSchemas());
    }

    public HollowSchemaHash(Collection<HollowSchema> schemas) {
        TreeMap<String, HollowSchema> schemaMap = new TreeMap<String, HollowSchema>();
        schemas.forEach(s -> schemaMap.put(s.getName(), (HollowSchema)s));
        StringBuilder schemaSB = new StringBuilder();
        schemaMap.forEach((k, v) -> schemaSB.append(v));
        this.hash = this.calculateHash(schemaSB.toString());
    }

    private String calculateHash(String schemaString) {
        int hashCode = HashCodes.hashCode(schemaString);
        return String.valueOf(hashCode);
    }

    public String getHash() {
        return this.hash;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HollowSchemaHash that = (HollowSchemaHash)o;
        return Objects.equals(this.hash, that.hash);
    }

    public int hashCode() {
        return Objects.hash(this.hash);
    }

    public String toString() {
        return this.getHash();
    }
}

