/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.core.schema;

import com.netflix.hollow.core.read.engine.HollowTypeReadState;
import com.netflix.hollow.core.schema.HollowCollectionSchema;
import com.netflix.hollow.core.schema.HollowSchema;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class HollowListSchema
extends HollowCollectionSchema {
    private final String elementType;
    private HollowTypeReadState elementTypeState;

    public HollowListSchema(String schemaName, String elementType) {
        super(schemaName);
        this.elementType = elementType;
    }

    @Override
    public String getElementType() {
        return this.elementType;
    }

    public void setElementTypeState(HollowTypeReadState typeState) {
        this.elementTypeState = typeState;
    }

    @Override
    public HollowTypeReadState getElementTypeState() {
        return this.elementTypeState;
    }

    @Override
    public HollowSchema.SchemaType getSchemaType() {
        return HollowSchema.SchemaType.LIST;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof HollowListSchema)) {
            return false;
        }
        HollowListSchema otherSchema = (HollowListSchema)other;
        if (!this.getName().equals(otherSchema.getName())) {
            return false;
        }
        return this.getElementType().equals(otherSchema.getElementType());
    }

    public int hashCode() {
        int result = this.getName().hashCode();
        result = 31 * result + this.getSchemaType().hashCode();
        result = 31 * result + this.elementType.hashCode();
        return result;
    }

    public String toString() {
        return this.getName() + " List<" + this.getElementType() + ">;";
    }

    @Override
    public void writeTo(OutputStream os) throws IOException {
        DataOutputStream dos = new DataOutputStream(os);
        dos.write(HollowSchema.SchemaType.LIST.getTypeId());
        dos.writeUTF(this.getName());
        dos.writeUTF(this.getElementType());
    }
}

