/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.core.read.engine.set;

import com.netflix.hollow.core.memory.encoding.HashCodes;
import com.netflix.hollow.core.read.engine.HollowTypeReadStateShard;
import com.netflix.hollow.core.read.engine.set.HollowSetTypeDataElements;
import com.netflix.hollow.tools.checksum.HollowChecksum;
import java.util.BitSet;

class HollowSetTypeReadStateShard
implements HollowTypeReadStateShard {
    final HollowSetTypeDataElements dataElements;
    final int shardOrdinalShift;

    @Override
    public HollowSetTypeDataElements getDataElements() {
        return this.dataElements;
    }

    @Override
    public int getShardOrdinalShift() {
        return this.shardOrdinalShift;
    }

    public HollowSetTypeReadStateShard(HollowSetTypeDataElements dataElements, int shardOrdinalShift) {
        this.shardOrdinalShift = shardOrdinalShift;
        this.dataElements = dataElements;
    }

    public int size(int ordinal) {
        int size = (int)this.dataElements.setPointerAndSizeData.getElementValue((long)ordinal * (long)this.dataElements.bitsPerFixedLengthSetPortion + (long)this.dataElements.bitsPerSetPointer, this.dataElements.bitsPerSetSizeValue);
        return size;
    }

    boolean foundData(int hashCode, long startBucket, long endBucket, int value) {
        hashCode = HashCodes.hashInt(hashCode);
        long bucket = startBucket + ((long)hashCode & endBucket - startBucket - 1L);
        int bucketOrdinal = this.dataElements.getBucketValue(bucket);
        while (bucketOrdinal != this.dataElements.emptyBucketValue) {
            if (bucketOrdinal == value) {
                return true;
            }
            if (++bucket == endBucket) {
                bucket = startBucket;
            }
            bucketOrdinal = this.dataElements.getBucketValue(bucket);
        }
        return false;
    }

    protected void applyShardToChecksum(HollowChecksum checksum, BitSet populatedOrdinals, int shardNumber, int numShards) {
        int ordinal = populatedOrdinals.nextSetBit(shardNumber);
        while (ordinal != -1) {
            if ((ordinal & numShards - 1) == shardNumber) {
                int shardOrdinal = ordinal / numShards;
                int numBuckets = HashCodes.hashTableSize(this.size(shardOrdinal));
                long offset = this.dataElements.getStartBucket(shardOrdinal);
                checksum.applyInt(ordinal);
                for (int i = 0; i < numBuckets; ++i) {
                    int bucketValue = this.dataElements.getBucketValue(offset + (long)i);
                    if (bucketValue == this.dataElements.emptyBucketValue) continue;
                    checksum.applyInt(i);
                    checksum.applyInt(bucketValue);
                }
                ordinal += numShards;
            } else {
                int r = (ordinal & -numShards) + shardNumber;
                ordinal = r <= ordinal ? r + numShards : r;
            }
            ordinal = populatedOrdinals.nextSetBit(ordinal);
        }
    }

    public long getApproximateHeapFootprintInBytes() {
        long requiredBitsForSetPointers = ((long)this.dataElements.maxOrdinal + 1L) * (long)this.dataElements.bitsPerFixedLengthSetPortion;
        long requiredBitsForBuckets = this.dataElements.totalNumberOfBuckets * (long)this.dataElements.bitsPerElement;
        long requiredBits = requiredBitsForSetPointers + requiredBitsForBuckets;
        return requiredBits / 8L;
    }

    public long getApproximateHoleCostInBytes(BitSet populatedOrdinals, int shardNumber, int numShards) {
        long holeBits = 0L;
        int holeOrdinal = populatedOrdinals.nextClearBit(0);
        while (holeOrdinal <= this.dataElements.maxOrdinal) {
            if ((holeOrdinal & numShards - 1) == shardNumber) {
                holeBits += (long)this.dataElements.bitsPerFixedLengthSetPortion;
            }
            holeOrdinal = populatedOrdinals.nextClearBit(holeOrdinal + 1);
        }
        return holeBits / 8L;
    }
}

