/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.core.read.engine.set;

import com.netflix.hollow.core.memory.encoding.FixedLengthElementArray;
import com.netflix.hollow.core.memory.encoding.HashCodes;
import com.netflix.hollow.core.memory.pool.WastefulRecycler;
import com.netflix.hollow.core.read.engine.PopulatedOrdinalListener;
import com.netflix.hollow.core.read.engine.set.HollowSetTypeDataElements;
import com.netflix.hollow.core.read.engine.set.HollowSetTypeReadState;
import com.netflix.hollow.core.util.IntMap;
import com.netflix.hollow.core.util.RemovedOrdinalIterator;

public class HollowSetDeltaHistoricalStateCreator {
    private final HollowSetTypeDataElements historicalDataElements;
    private final int shardNumberMask;
    private final int shardOrdinalShift;
    private HollowSetTypeReadState typeState;
    private HollowSetTypeDataElements[] stateEngineDataElements;
    private RemovedOrdinalIterator iter;
    private IntMap ordinalMapping;
    private int nextOrdinal;
    private long nextStartBucket;

    public HollowSetDeltaHistoricalStateCreator(HollowSetTypeReadState typeState, boolean reverse) {
        this.typeState = typeState;
        this.stateEngineDataElements = typeState.currentDataElements();
        this.historicalDataElements = new HollowSetTypeDataElements(WastefulRecycler.DEFAULT_INSTANCE);
        this.iter = new RemovedOrdinalIterator(typeState.getListener(PopulatedOrdinalListener.class), reverse);
        this.shardNumberMask = this.stateEngineDataElements.length - 1;
        this.shardOrdinalShift = 31 - Integer.numberOfLeadingZeros(this.stateEngineDataElements.length);
    }

    public void populateHistory() {
        this.populateStats();
        this.historicalDataElements.setPointerAndSizeData = new FixedLengthElementArray(this.historicalDataElements.memoryRecycler, ((long)this.historicalDataElements.maxOrdinal + 1L) * (long)this.historicalDataElements.bitsPerFixedLengthSetPortion);
        this.historicalDataElements.elementData = new FixedLengthElementArray(this.historicalDataElements.memoryRecycler, this.historicalDataElements.totalNumberOfBuckets * (long)this.historicalDataElements.bitsPerElement);
        this.iter.reset();
        int ordinal = this.iter.next();
        while (ordinal != -1) {
            this.ordinalMapping.put(ordinal, this.nextOrdinal);
            this.copyRecord(ordinal);
            ordinal = this.iter.next();
        }
    }

    public void dereferenceTypeState() {
        this.typeState = null;
        this.stateEngineDataElements = null;
        this.iter = null;
    }

    public IntMap getOrdinalMapping() {
        return this.ordinalMapping;
    }

    public HollowSetTypeReadState createHistoricalTypeReadState() {
        HollowSetTypeReadState historicalTypeState = new HollowSetTypeReadState(this.typeState.getSchema(), this.historicalDataElements);
        return historicalTypeState;
    }

    private void populateStats() {
        this.iter.reset();
        int removedEntryCount = 0;
        int maxSize = 0;
        long totalBucketCount = 0L;
        int ordinal = this.iter.next();
        while (ordinal != -1) {
            ++removedEntryCount;
            int size = this.typeState.size(ordinal);
            if (size > maxSize) {
                maxSize = size;
            }
            totalBucketCount += (long)HashCodes.hashTableSize(size);
            ordinal = this.iter.next();
        }
        this.historicalDataElements.maxOrdinal = removedEntryCount - 1;
        this.historicalDataElements.bitsPerSetPointer = 64 - Long.numberOfLeadingZeros(totalBucketCount);
        this.historicalDataElements.bitsPerSetSizeValue = 64 - Long.numberOfLeadingZeros(maxSize);
        this.historicalDataElements.bitsPerFixedLengthSetPortion = this.historicalDataElements.bitsPerSetPointer + this.historicalDataElements.bitsPerSetSizeValue;
        for (int i = 0; i < this.stateEngineDataElements.length; ++i) {
            if (this.stateEngineDataElements[i].bitsPerElement <= this.historicalDataElements.bitsPerElement) continue;
            this.historicalDataElements.bitsPerElement = this.stateEngineDataElements[i].bitsPerElement;
            this.historicalDataElements.emptyBucketValue = this.stateEngineDataElements[i].emptyBucketValue;
        }
        this.historicalDataElements.totalNumberOfBuckets = totalBucketCount;
        this.ordinalMapping = new IntMap(removedEntryCount);
    }

    private void copyRecord(int ordinal) {
        int shard = ordinal & this.shardNumberMask;
        int shardOrdinal = ordinal >> this.shardOrdinalShift;
        long bitsPerBucket = this.historicalDataElements.bitsPerElement;
        long size = this.typeState.size(ordinal);
        long fromStartBucket = this.stateEngineDataElements[shard].getStartBucket(shardOrdinal);
        long fromEndBucket = this.stateEngineDataElements[shard].getEndBucket(shardOrdinal);
        long numBuckets = fromEndBucket - fromStartBucket;
        this.historicalDataElements.setPointerAndSizeData.setElementValue((long)this.nextOrdinal * (long)this.historicalDataElements.bitsPerFixedLengthSetPortion, this.historicalDataElements.bitsPerSetPointer, this.nextStartBucket + numBuckets);
        this.historicalDataElements.setPointerAndSizeData.setElementValue((long)(this.nextOrdinal * this.historicalDataElements.bitsPerFixedLengthSetPortion) + (long)this.historicalDataElements.bitsPerSetPointer, this.historicalDataElements.bitsPerSetSizeValue, size);
        this.historicalDataElements.elementData.copyBits(this.stateEngineDataElements[shard].elementData, fromStartBucket * bitsPerBucket, this.nextStartBucket * bitsPerBucket, numBuckets * bitsPerBucket);
        ++this.nextOrdinal;
        this.nextStartBucket += numBuckets;
    }
}

