/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.core.read.engine.list;

import com.netflix.hollow.core.memory.FixedLengthDataFactory;
import com.netflix.hollow.core.read.engine.HollowTypeDataElementsSplitter;
import com.netflix.hollow.core.read.engine.list.HollowListTypeDataElements;

public class HollowListTypeDataElementsSplitter
extends HollowTypeDataElementsSplitter<HollowListTypeDataElements> {
    public HollowListTypeDataElementsSplitter(HollowListTypeDataElements from, int numSplits) {
        super(from, numSplits);
    }

    @Override
    public void initToElements() {
        this.to = new HollowListTypeDataElements[this.numSplits];
        for (int i = 0; i < ((HollowListTypeDataElements[])this.to).length; ++i) {
            ((HollowListTypeDataElements[])this.to)[i] = new HollowListTypeDataElements(((HollowListTypeDataElements)this.from).memoryMode, ((HollowListTypeDataElements)this.from).memoryRecycler);
        }
    }

    @Override
    public void populateStats() {
        int toIndex;
        long[] totalOfListSizes = new long[this.numSplits];
        for (int ordinal = 0; ordinal <= ((HollowListTypeDataElements)this.from).maxOrdinal; ++ordinal) {
            int toOrdinal;
            int toIndex2 = ordinal & this.toMask;
            ((HollowListTypeDataElements[])this.to)[toIndex2].maxOrdinal = toOrdinal = ordinal >> this.toOrdinalShift;
            long startElement = ((HollowListTypeDataElements)this.from).getStartElement(ordinal);
            long endElement = ((HollowListTypeDataElements)this.from).getEndElement(ordinal);
            long numElements = endElement - startElement;
            int n = toIndex2;
            totalOfListSizes[n] = totalOfListSizes[n] + numElements;
        }
        long maxShardTotalOfListSizes = 0L;
        for (toIndex = 0; toIndex < this.numSplits; ++toIndex) {
            if (totalOfListSizes[toIndex] <= maxShardTotalOfListSizes) continue;
            maxShardTotalOfListSizes = totalOfListSizes[toIndex];
        }
        for (toIndex = 0; toIndex < this.numSplits; ++toIndex) {
            HollowListTypeDataElements target = ((HollowListTypeDataElements[])this.to)[toIndex];
            target.bitsPerElement = ((HollowListTypeDataElements)this.from).bitsPerElement;
            target.bitsPerListPointer = maxShardTotalOfListSizes == 0L ? 1 : 64 - Long.numberOfLeadingZeros(maxShardTotalOfListSizes);
            target.totalNumberOfElements = totalOfListSizes[toIndex];
        }
    }

    @Override
    public void copyRecords() {
        int numSplits = ((HollowListTypeDataElements[])this.to).length;
        long[] elementCounter = new long[numSplits];
        for (int toIndex = 0; toIndex < numSplits; ++toIndex) {
            HollowListTypeDataElements target = ((HollowListTypeDataElements[])this.to)[toIndex];
            target.listPointerData = FixedLengthDataFactory.get((long)target.bitsPerListPointer * (long)(target.maxOrdinal + 1), target.memoryMode, target.memoryRecycler);
            target.elementData = FixedLengthDataFactory.get((long)target.bitsPerElement * target.totalNumberOfElements, target.memoryMode, target.memoryRecycler);
        }
        for (int ordinal = 0; ordinal <= ((HollowListTypeDataElements)this.from).maxOrdinal; ++ordinal) {
            int toIndex = ordinal & this.toMask;
            int toOrdinal = ordinal >> this.toOrdinalShift;
            long startElement = ((HollowListTypeDataElements)this.from).getStartElement(ordinal);
            long endElement = ((HollowListTypeDataElements)this.from).getEndElement(ordinal);
            HollowListTypeDataElements target = ((HollowListTypeDataElements[])this.to)[toIndex];
            long numElements = endElement - startElement;
            target.copyElementsFrom(elementCounter[toIndex], (HollowListTypeDataElements)this.from, startElement, endElement);
            int n = toIndex;
            elementCounter[n] = elementCounter[n] + numElements;
            target.listPointerData.setElementValue((long)target.bitsPerListPointer * (long)toOrdinal, target.bitsPerListPointer, elementCounter[toIndex]);
        }
    }
}

