/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.core.read.engine;

import com.netflix.hollow.core.read.engine.HollowTypeDataElements;
import com.netflix.hollow.core.read.engine.HollowTypeDataElementsJoiner;
import com.netflix.hollow.core.read.engine.HollowTypeDataElementsSplitter;
import com.netflix.hollow.core.read.engine.HollowTypeReadState;
import com.netflix.hollow.core.read.engine.HollowTypeReadStateShard;
import com.netflix.hollow.core.read.engine.ShardsHolder;
import com.netflix.hollow.core.read.engine.list.HollowListTypeReadState;
import com.netflix.hollow.core.read.engine.list.HollowListTypeReshardingStrategy;
import com.netflix.hollow.core.read.engine.map.HollowMapTypeReadState;
import com.netflix.hollow.core.read.engine.map.HollowMapTypeReshardingStrategy;
import com.netflix.hollow.core.read.engine.object.HollowObjectTypeReadState;
import com.netflix.hollow.core.read.engine.object.HollowObjectTypeReshardingStrategy;
import com.netflix.hollow.core.read.engine.set.HollowSetTypeReadState;
import com.netflix.hollow.core.read.engine.set.HollowSetTypeReshardingStrategy;
import java.util.Arrays;

public abstract class HollowTypeReshardingStrategy {
    private static final HollowTypeReshardingStrategy OBJECT_RESHARDING_STRATEGY = new HollowObjectTypeReshardingStrategy();
    private static final HollowTypeReshardingStrategy LIST_RESHARDING_STRATEGY = new HollowListTypeReshardingStrategy();
    private static final HollowTypeReshardingStrategy SET_RESHARDING_STRATEGY = new HollowSetTypeReshardingStrategy();
    private static final HollowTypeReshardingStrategy MAP_RESHARDING_STRATEGY = new HollowMapTypeReshardingStrategy();

    public abstract HollowTypeDataElementsSplitter createDataElementsSplitter(HollowTypeDataElements var1, int var2);

    public abstract HollowTypeDataElementsJoiner createDataElementsJoiner(HollowTypeDataElements[] var1);

    public static HollowTypeReshardingStrategy getInstance(HollowTypeReadState typeState) {
        if (typeState instanceof HollowObjectTypeReadState) {
            return OBJECT_RESHARDING_STRATEGY;
        }
        if (typeState instanceof HollowListTypeReadState) {
            return LIST_RESHARDING_STRATEGY;
        }
        if (typeState instanceof HollowSetTypeReadState) {
            return SET_RESHARDING_STRATEGY;
        }
        if (typeState instanceof HollowMapTypeReadState) {
            return MAP_RESHARDING_STRATEGY;
        }
        throw new IllegalArgumentException("Unexpected type state: " + typeState.getClass().getName());
    }

    public void reshard(HollowTypeReadState typeState, int prevNumShards, int newNumShards) {
        int shardingFactor = HollowTypeReshardingStrategy.shardingFactor(prevNumShards, newNumShards);
        try {
            if (newNumShards > prevNumShards) {
                typeState.updateShardsVolatile(this.expandWithOriginalDataElements(typeState.getShardsVolatile(), shardingFactor));
                for (int i = 0; i < prevNumShards; ++i) {
                    HollowTypeDataElements originalDataElements = typeState.getShardsVolatile().getShards()[i].getDataElements();
                    typeState.updateShardsVolatile(this.splitDataElementsForOneShard(typeState, i, prevNumShards, shardingFactor));
                    typeState.destroyOriginalDataElements(originalDataElements);
                }
            } else {
                for (int i = 0; i < newNumShards; ++i) {
                    HollowTypeDataElements[] destroyCandidates = this.joinCandidates(typeState, i, shardingFactor);
                    typeState.updateShardsVolatile(this.joinDataElementsForOneShard(typeState, i, shardingFactor));
                    for (int j = 0; j < shardingFactor; ++j) {
                        typeState.destroyOriginalDataElements(destroyCandidates[j]);
                    }
                }
                HollowTypeDataElements[] newDataElements = typeState.createTypeDataElements(typeState.getShardsVolatile().getShards().length);
                int[] shardOrdinalShifts = new int[typeState.getShardsVolatile().getShards().length];
                this.copyShardDataElements(typeState.getShardsVolatile(), newDataElements, shardOrdinalShifts);
                HollowTypeReadStateShard[] newShards = Arrays.copyOfRange(typeState.getShardsVolatile().getShards(), 0, newNumShards);
                typeState.updateShardsVolatile(newShards);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Error in re-sharding", e);
        }
    }

    public static int shardingFactor(int oldNumShards, int newNumShards) {
        int divisor;
        if (newNumShards <= 0 || oldNumShards <= 0 || newNumShards == oldNumShards) {
            throw new IllegalStateException("Invalid shard resizing, oldNumShards=" + oldNumShards + ", newNumShards=" + newNumShards);
        }
        boolean isNewGreater = newNumShards > oldNumShards;
        int dividend = isNewGreater ? newNumShards : oldNumShards;
        int n = divisor = isNewGreater ? oldNumShards : newNumShards;
        if (dividend % divisor != 0) {
            throw new IllegalStateException("Invalid shard resizing, oldNumShards=" + oldNumShards + ", newNumShards=" + newNumShards);
        }
        return dividend / divisor;
    }

    private void copyShardDataElements(ShardsHolder from, HollowTypeDataElements[] newDataElements, int[] shardOrdinalShifts) {
        for (int i = 0; i < from.getShards().length; ++i) {
            newDataElements[i] = from.getShards()[i].getDataElements();
            shardOrdinalShifts[i] = from.getShards()[i].getShardOrdinalShift();
        }
    }

    private HollowTypeDataElements[] joinCandidates(HollowTypeReadState typeState, int indexIntoShards, int shardingFactor) {
        HollowTypeReadStateShard[] shards = typeState.getShardsVolatile().getShards();
        HollowTypeDataElements[] result = typeState.createTypeDataElements(shardingFactor);
        int newNumShards = shards.length / shardingFactor;
        for (int i = 0; i < shardingFactor; ++i) {
            result[i] = shards[indexIntoShards + newNumShards * i].getDataElements();
        }
        return result;
    }

    public HollowTypeReadStateShard[] joinDataElementsForOneShard(HollowTypeReadState typeState, int currentIndex, int shardingFactor) {
        ShardsHolder shardsHolder = typeState.getShardsVolatile();
        int newNumShards = shardsHolder.getShards().length / shardingFactor;
        int newShardOrdinalShift = 31 - Integer.numberOfLeadingZeros(newNumShards);
        HollowTypeDataElements[] joinCandidates = this.joinCandidates(typeState, currentIndex, shardingFactor);
        HollowTypeDataElementsJoiner joiner = this.createDataElementsJoiner(joinCandidates);
        Object joined = joiner.join();
        HollowTypeReadStateShard[] newShards = Arrays.copyOf(shardsHolder.getShards(), shardsHolder.getShards().length);
        for (int i = 0; i < shardingFactor; ++i) {
            newShards[currentIndex + newNumShards * i] = typeState.createTypeReadStateShard(typeState.getSchema(), (HollowTypeDataElements)joined, newShardOrdinalShift);
        }
        return newShards;
    }

    public HollowTypeReadStateShard[] expandWithOriginalDataElements(ShardsHolder shardsHolder, int shardingFactor) {
        int prevNumShards = shardsHolder.getShards().length;
        int newNumShards = prevNumShards * shardingFactor;
        HollowTypeReadStateShard[] newShards = new HollowTypeReadStateShard[newNumShards];
        for (int i = 0; i < prevNumShards; ++i) {
            for (int j = 0; j < shardingFactor; ++j) {
                newShards[i + prevNumShards * j] = shardsHolder.getShards()[i];
            }
        }
        return newShards;
    }

    public HollowTypeReadStateShard[] splitDataElementsForOneShard(HollowTypeReadState typeState, int currentIndex, int prevNumShards, int shardingFactor) {
        ShardsHolder shardsHolder = typeState.getShardsVolatile();
        int newNumShards = shardsHolder.getShards().length;
        int newShardOrdinalShift = 31 - Integer.numberOfLeadingZeros(newNumShards);
        HollowTypeDataElements dataElementsToSplit = shardsHolder.getShards()[currentIndex].getDataElements();
        HollowTypeDataElementsSplitter splitter = this.createDataElementsSplitter(dataElementsToSplit, shardingFactor);
        HollowTypeDataElements[] splits = splitter.split();
        HollowTypeReadStateShard[] newShards = Arrays.copyOf(shardsHolder.getShards(), shardsHolder.getShards().length);
        for (int i = 0; i < shardingFactor; ++i) {
            newShards[currentIndex + prevNumShards * i] = typeState.createTypeReadStateShard(typeState.getSchema(), splits[i], newShardOrdinalShift);
        }
        return newShards;
    }
}

