/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.core.read.engine;

import com.netflix.hollow.core.memory.encoding.GapEncodedVariableLengthIntegerReader;
import com.netflix.hollow.core.read.engine.HollowTypeDataElements;

public abstract class HollowTypeDataElementsSplitter<T extends HollowTypeDataElements> {
    public final int numSplits;
    public final int toMask;
    public final int toOrdinalShift;
    public final T from;
    public T[] to;

    public HollowTypeDataElementsSplitter(T from, int numSplits) {
        this.from = from;
        this.numSplits = numSplits;
        this.toMask = numSplits - 1;
        this.toOrdinalShift = 31 - Integer.numberOfLeadingZeros(numSplits);
        if (numSplits <= 0 || (numSplits & numSplits - 1) != 0) {
            throw new IllegalStateException("Must split by power of 2");
        }
        if (((HollowTypeDataElements)from).encodedAdditions != null) {
            throw new IllegalStateException("Encountered encodedAdditions in data elements splitter- this is not expected since encodedAdditions only exist on delta data elements and they dont carry over to target data elements, delta data elements are never split/joined");
        }
    }

    public T[] split() {
        this.initToElements();
        for (int i = 0; i < this.to.length; ++i) {
            ((HollowTypeDataElements)this.to[i]).maxOrdinal = -1;
        }
        this.populateStats();
        this.copyRecords();
        if (((HollowTypeDataElements)this.from).encodedRemovals != null) {
            GapEncodedVariableLengthIntegerReader[] splitRemovals = ((HollowTypeDataElements)this.from).encodedRemovals.split(this.numSplits);
            for (int i = 0; i < this.to.length; ++i) {
                ((HollowTypeDataElements)this.to[i]).encodedRemovals = splitRemovals[i];
            }
        }
        return this.to;
    }

    public abstract void initToElements();

    public abstract void populateStats();

    public abstract void copyRecords();
}

